--
-- PoettingerAlpha
-- Specialization for PoettingerAlpha
--
-- @author  	fruktor 
-- @version 	v0.1
-- @date  		28/07/11
-- @history:	v0.1 - Initial version
--

 
PoettingerAlpha = {};

function PoettingerAlpha.prerequisitesPresent(specializations)
    Vehicle.registerJointType("FastCoupling");
	return true;
end;

function PoettingerAlpha:load(xmlFile)

	self.setLiftUp = SpecializationUtil.callSpecializationsFunction("setLiftUp");
	self.setTurnedOn = SpecializationUtil.callSpecializationsFunction("setTurnedOn");
	--self.setSwath = SpecializationUtil.callSpecializationsFunction("setSwath");
	--self.setCollector = SpecializationUtil.callSpecializationsFunction("setCollector");
	self.setTransport = SpecializationUtil.callSpecializationsFunction("setTransport");
	--self.setSelection = SpecializationUtil.callSpecializationsFunction("setSelection");
	self.setPSstate = SpecializationUtil.callSpecializationsFunction("setPSstate");

	self.attacherJoint.jointType = Vehicle.JOINTTYPE_FASTCOUPLING;
	
	self.alpMot = {};
	
	self.alpMot.left = {};
	self.alpMot.left.node = Utils.indexToObject( self.components, getXMLString(xmlFile, "vehicle.PoetAlpha.left#idx") );
	self.alpMot.left.rotMin = Utils.getVectorNFromString(getXMLString(xmlFile, "vehicle.PoetAlpha.left#rotMin")); 
	self.alpMot.left.rotMax = Utils.getVectorNFromString(getXMLString(xmlFile, "vehicle.PoetAlpha.left#rotMax")); 
	for i=1,3 do
		self.alpMot.left.rotMin[i] = Utils.degToRad(self.alpMot.left.rotMin[i]);
		self.alpMot.left.rotMax[i] = Utils.degToRad(self.alpMot.left.rotMax[i]);
	end;
	self.alpMot.right = {};
	self.alpMot.right.node = Utils.indexToObject( self.components, getXMLString(xmlFile, "vehicle.PoetAlpha.right#idx") );
	self.alpMot.right.rotMin = Utils.getVectorNFromString(getXMLString(xmlFile, "vehicle.PoetAlpha.right#rotMin")); 
	self.alpMot.right.rotMax = Utils.getVectorNFromString(getXMLString(xmlFile, "vehicle.PoetAlpha.right#rotMax")); 
	for i=1,3 do
		self.alpMot.right.rotMin[i] = Utils.degToRad(self.alpMot.right.rotMin[i]);
		self.alpMot.right.rotMax[i] = Utils.degToRad(self.alpMot.right.rotMax[i]);
	end;	
	self.alpMot.walze = Utils.indexToObject( self.components, getXMLString(xmlFile, "vehicle.PoetAlpha.walze#idx") );
	self.alpMot.halter = {};
	self.alpMot.halter.node = Utils.indexToObject( self.components, getXMLString(xmlFile, "vehicle.PoetAlpha.halter#idx") );
	self.alpMot.halter.rotMin = Utils.getVectorNFromString(getXMLString(xmlFile, "vehicle.PoetAlpha.halter#rotMin")); 
	self.alpMot.halter.rotMax = Utils.getVectorNFromString(getXMLString(xmlFile, "vehicle.PoetAlpha.halter#rotMax")); 
	for i=1,3 do
		self.alpMot.halter.rotMin[i] = Utils.degToRad(self.alpMot.halter.rotMin[i]);
		self.alpMot.halter.rotMax[i] = Utils.degToRad(self.alpMot.halter.rotMax[i]);
	end;	

	self.alpMot.groundReferenceNode = Utils.indexToObject( self.components, getXMLString(xmlFile, "vehicle.PoetAlpha.groundReference#idx"));
	self.alpMot.groundReferenceThreshold = getXMLFloat(xmlFile, "vehicle.PoetAlpha.groundReference#thresh");
	
	self.alpMot.cuttingArea = {};
	self.alpMot.cuttingArea.start = Utils.indexToObject( self.components, getXMLString(xmlFile, "vehicle.PoetAlpha.cutArea#startIndex"));
	self.alpMot.cuttingArea.width = Utils.indexToObject( self.components, getXMLString(xmlFile, "vehicle.PoetAlpha.cutArea#widthIndex"));
	self.alpMot.cuttingArea.height = Utils.indexToObject( self.components, getXMLString(xmlFile, "vehicle.PoetAlpha.cutArea#heightIndex"));
	self.alpMot.cuttingArea.groundthreshold = Utils.indexToObject( self.components, getXMLString(xmlFile, "vehicle.PoetAlpha.cutArea#groundthreshold"), 0.2);
    self.alpMot.cuttingArea.groundindex =Utils.indexToObject( self.components, getXMLString(xmlFile,  "vehicle.PoetAlpha.cutArea#groundindex"));
	self.alpMot.windrowDropArea = {};
	self.alpMot.windrowDropArea.start = Utils.indexToObject( self.components, getXMLString(xmlFile, "vehicle.PoetAlpha.windrowDropArea#startIndex"));
	self.alpMot.windrowDropArea.width = Utils.indexToObject( self.components, getXMLString(xmlFile, "vehicle.PoetAlpha.windrowDropArea#widthIndex"));
	self.alpMot.windrowDropArea.height = Utils.indexToObject( self.components, getXMLString(xmlFile, "vehicle.PoetAlpha.windrowDropArea#heightIndex"));			
	

	-- ps
	self.alpMot.cutPS = {};
	self.alpMot.cutPS.ps = {};
	self.alpMot.cutPS.active = false;
	baseName = "vehicle.PoetAlpha.PScut";
	Utils.loadParticleSystem(xmlFile, self.alpMot.cutPS.ps, baseName, self.components, false, nil, self.baseDirectory);			
	self.alpMot.cutPS.node = Utils.indexToObject( self.components, getXMLString(xmlFile, "vehicle.PoetAlpha.PScut#node"));	
	self.psTime = 300;
	self.psTimeT = 300;

	self.alpMot.setTransport = true;
	self.alpMot.isWorking = false;
	self.alpMot.isTransport = true;
	
	self.alpMot.setTurnedOn = false;
	self.alpMot.setSwath = true;
	
	self.alpMot.setLiftUp = true;
	self.alpMot.isLiftUp = true;
	self.alpMot.isLiftDown = false;
	self.alpMot.currentTransLimit = {0};
	self.alpMot.maxTrans = {0.5};
	self.alpMot.minTrans = {0};
	
	self.accumulatedCuttingAreaValues = {0};
	
	self.alpMot.curFCjointRotLimit = {};
	self.alpMot.curFCjointRotLimit.z = 0;
	
	-- "dynamic" plane, aka the flagshader from SRS
	--<dynPlane idx="1>0|5">
	self.alpMot.dynPlanes = {};
	local i=0;
	while true do
		i = i + 1;
		local node = Utils.indexToObject( self.components, getXMLString(xmlFile, string.format("vehicle.PoetAlpha.dynPlane%d#idx", i)));
		if node == nil then break; end;
		local scale = Utils.getNoNil( getXMLBool(xmlFile,  string.format("vehicle.PoetAlpha.dynPlane%d#scale", i)), false );
		local e = {};
		e.node = node;
		e.scale = scale;
		table.insert(self.alpMot.dynPlanes, e);
	end;
	self.alpMot.dynPlanesActive = true;

	
	-- sound
	local mowerStartSound = getXMLString(xmlFile, string.format("vehicle.mowerStartSound#file"));
	mowerStartSound = Utils.getFilename(mowerStartSound, self.baseDirectory); 
	self.mowerStartSound = {};
	self.mowerStartSound = createSample(string.format("mowerStartSound"));
	loadSample(self.mowerStartSound, mowerStartSound, false);
	self.mowerStartSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, string.format("vehicle.mowerStartSound#pitchOffset")), 1);
	self.mowerStartSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, string.format("vehicle.mowerStartSound#volume")), 1);
	self.mowerStartSoundActive = false;	
	self.mowerStartDuration = getSampleDuration(self.mowerStartSound);
	
	-- sound
	local mowerLoopSound = getXMLString(xmlFile, string.format("vehicle.mowerLoopSound#file"));
	mowerLoopSound = Utils.getFilename(mowerLoopSound, self.baseDirectory); 
	self.mowerLoopSound = {};
	self.mowerLoopSound = createSample(string.format("mowerLoopSound"));
	loadSample(self.mowerLoopSound, mowerLoopSound, false);
	self.mowerLoopSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, string.format("vehicle.mowerLoopSound#pitchOffset")), 1);
	self.mowerLoopSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, string.format("vehicle.mowerLoopSound#volume")), 1);
	self.mowerLoopSoundActive = false;
	self.mowerLoopTime = -1;	

	-- sound
	local mowerStopSound = getXMLString(xmlFile, string.format("vehicle.mowerStopSound#file"));
	mowerStopSound = Utils.getFilename(mowerStopSound, self.baseDirectory); 
	self.mowerStopSound = {};
	self.mowerStopSound = createSample(string.format("mowerStopSound"));
	loadSample(self.mowerStopSound, mowerStopSound, false);
	self.mowerStopSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, string.format("vehicle.mowerStopSound#pitchOffset")), 1);
	self.mowerStopSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, string.format("vehicle.mowerStopSound#volume")), 1);
	self.mowerStopSoundActive = false;		
	self.mowerStopDuration = getSampleDuration(self.mowerStopSound);
	self.mowerLoopEndTime = -1;	-- used to syn the rolls' movement
end

function PoettingerAlpha:delete()
	stopSample(self.mowerStartSound);
	stopSample(self.mowerLoopSound);
	stopSample(self.mowerStopSound);
	delete(self.mowerStartSound);
	delete(self.mowerLoopSound);
	delete(self.mowerStopSound);
	Utils.deleteParticleSystem(self.alpMot.cutPS.ps);
end;

function PoettingerAlpha:mouseEvent(posX, posY, isDown, isUp, button)
end;

function PoettingerAlpha:keyEvent(unicode, sym, modifier, isDown)
end;

function PoettingerAlpha:readStream(streamId, connection)
	self.alpMot.setTransport = streamReadBool(streamId);
	self.alpMot.isWorking = streamReadBool(streamId);
	self.alpMot.isTransport = streamReadBool(streamId);
	self.alpMot.setTurnedOn = streamReadBool(streamId);
	self.alpMot.setLiftUp = streamReadBool(streamId);
	self.alpMot.isLiftUp = streamReadBool(streamId);
	self.alpMot.isLiftDown = streamReadBool(streamId);
	local rx = streamReadFloat32(streamId);
	local ry = streamReadFloat32(streamId);
	local rz = streamReadFloat32(streamId);
	
	local newVal = {0, 0, 0};
	--[[if self.alpMot.setTransport == true then
		newVal = self.alpMot.left.rotMax;
	else
		newVal = self.alpMot.left.rotMin;
	end;]]--
	setRotation(self.alpMot.left.node, rx, ry, rz);
	setRotation(self.alpMot.right.node, rx, ry, -rz);
	
	for i,plane in pairs(self.alpMot.dynPlanes) do
		if plane.scale then
			if self.alpMot.setTransport then
				setScale(plane.node, 1, 0.5, 1);
			else
				setScale(plane.node, 1, 1.0, 1);
			end;
		end;
	end;	
end;


function PoettingerAlpha:writeStream(streamId, connection)
	streamWriteBool(streamId, self.alpMot.setTransport);
	streamWriteBool(streamId, self.alpMot.isWorking);
	streamWriteBool(streamId, self.alpMot.isTransport);
	streamWriteBool(streamId, self.alpMot.setTurnedOn);
	streamWriteBool(streamId, self.alpMot.setLiftUp);
	streamWriteBool(streamId, self.alpMot.isLiftUp);
	streamWriteBool(streamId, self.alpMot.isLiftDown);
	local rx, ry, rz = getRotation(self.alpMot.left.node);
	streamWriteFloat32(streamId, rx);
	streamWriteFloat32(streamId, ry);
	streamWriteFloat32(streamId, rz);
	
end;

function PoettingerAlpha:readStreamUpdate(streamId, connection)

	
end;

function PoettingerAlpha:writeStreamUpdate(streamId, connection)
end;


function PoettingerAlpha:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)

	self.alpMot.setTurnedOn = Utils.getNoNil( getXMLBool(xmlFile,key..string.format("#alpMot.setTurnedOn")), false);
	self.alpMot.setTransport = Utils.getNoNil( getXMLBool(xmlFile,key..string.format("#alpMot.setTransport")), false);
	self.alpMot.isWorking = Utils.getNoNil( getXMLBool(xmlFile,key..string.format("#alpMot.isWorking")), false);
	self.alpMot.isTransport = Utils.getNoNil( getXMLBool(xmlFile,key..string.format("#alpMot.isTransport")), false);
	self.alpMot.setLiftUp = Utils.getNoNil( getXMLBool(xmlFile,key..string.format("#alpMot.setLiftUp")), false);
	self.alpMot.isLiftUp = Utils.getNoNil( getXMLBool(xmlFile,key..string.format("#alpMot.isLiftUp")), false);
	self.alpMot.isLiftDown = Utils.getNoNil( getXMLBool(xmlFile,key..string.format("#alpMot.isLiftDown")), false);
	
	local x,y,z = getTranslation(self.componentJoints[1].jointNode);
	local newY = Utils.getNoNil( getXMLFloat(xmlFile,key..string.format("#alpMot.comp1.jointNodeY")), -0.28515);
	setTranslation(self.componentJoints[1].jointNode, x, newY, z);
	setJointFrame(self.componentJoints[1].jointIndex, 0, self.componentJoints[1].jointNode);		
	
	local newVal = {0, 0, 0};
	if self.alpMot.setTransport == true then
		newVal = self.alpMot.left.rotMax;
	else
		newVal = self.alpMot.left.rotMin;
	end;
	setRotation(self.alpMot.left.node, newVal[1], newVal[2], newVal[3]);
	setRotation(self.alpMot.right.node, newVal[1], newVal[2], -newVal[3]);	
	
	for i,plane in pairs(self.alpMot.dynPlanes) do
		if plane.scale then
			if self.alpMot.setTransport then
				setScale(plane.node, 1, 0.5, 1);
			else
				setScale(plane.node, 1, 1.0, 1);
			end;
		end;
	end;	
	return BaseMission.VEHICLE_LOAD_OK;
end;

function PoettingerAlpha:getSaveAttributesAndNodes(nodeIdent)

	local attributes = ' ';
	local mystring = 	
		' alpMot.setTurnedOn="'..tostring(self.alpMot.setTurnedOn)..'"'..
		' alpMot.setTransport="'..tostring(self.alpMot.setTransport)..'"'..
		' alpMot.isWorking="'..tostring(self.alpMot.isWorking)..'"'..
		' alpMot.isTransport="'..tostring(self.alpMot.isTransport)..'"'..
		' alpMot.setLiftUp="'..tostring(self.alpMot.setLiftUp)..'"'..
		' alpMot.isLiftUp="'..tostring(self.alpMot.isLiftUp)..'"'..
		' alpMot.isLiftDown="'..tostring(self.alpMot.isLiftDown)..'"';
	attributes = attributes .. mystring;
	
	local x,y,z = getTranslation(self.componentJoints[1].jointNode);
	attributes = attributes .. string.format(' alpMot.comp1.jointNodeY="%f"', y);
	
	local node = nil;
    return attributes, node;
end;


function PoettingerAlpha:update(dt)
	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.LOWER_IMPLEMENT) then
			if self.alpMot.isWorking then
				self:setLiftUp( not self.alpMot.setLiftUp );
			end;
		end;
		if InputBinding.hasEvent(InputBinding.POETX_TURNONOFF) then
			if self.alpMot.isWorking then
				self:setTurnedOn( not self.alpMot.setTurnedOn );
			end;
		end;
		--if InputBinding.hasEvent(InputBinding.POETX_SWATHONOFF) then
			--self:setSwath( not self.alpMot.setSwath );
		--end;
		if InputBinding.hasEvent(InputBinding.POETX_TRANSPORT) then
			if self.alpMot.isLiftUp then
				self:setTransport( not self.alpMot.setTransport );
			end;
		end;

	end;

	
end;

function PoettingerAlpha:updateTick(dt)

	
	--if self.fastCouplerJoint ~= nil and self.isExpanded then
	_=[[if self.attacherVehicle ~= nil then
		if self.fastCouplerJoint ~= nil then
			self.fastCouplerJoint.moveDown = false;
			self.attacherVehicle.needsLowering = false;
		else
			self.attacherVehicle.needsLowering = true;
		end;	
	end; ]]
	
	--if self.mowerIsAttached and self.attacherVehicle ~= nil then
	if self.fastCouplerJoint ~= nil and self.attacherVehicle ~= nil then
	
		local spd = self.lastSpeed*3600;		
		
		if spd < 5 and self.alpMot.dynPlanesActive == true then
			self.alpMot.dynPlanesActive = false;
			for i,plane in pairs(self.alpMot.dynPlanes) do
				setShaderParameter(plane.node, "displacementSpeedFrequencyAndTexOff", 0.1, 0, 0, 0.05,false);
			end;
		elseif self.alpMot.dynPlanesActive == false and spd > 5 then
			self.alpMot.dynPlanesActive = true;
			for i,plane in pairs(self.alpMot.dynPlanes) do
				--0.1 4 0.9 0.05			
				--print(".");
				setShaderParameter(plane.node, "displacementSpeedFrequencyAndTexOff", 0.1, 4, 0.9, 0.05,false);
			end;
		end;
		
		if self.fastCouplerJoint ~= nil then
			self.fastCouplerJoint.moveDown = false;
		end;		
	else
		local spd = self.lastSpeed*3600;
		if spd < 5 and self.alpMot.dynPlanesActive == true then
			self.alpMot.dynPlanesActive = false;
			for i,plane in pairs(self.alpMot.dynPlanes) do
				setShaderParameter(plane.node, "displacementSpeedFrequencyAndTexOff", 0.1, 0, 0, 0.05,false);
			end;
		end;
	
		--self.fastCouplerJoint.moveDown = false;
		
		--self.attacherJoint.allowsJointTransLimitMovement = false;
		--self.attacherJoint.allowsJointRotLimitMovement = true;
		
		--self.attacherVehicle.attacherJoint.allowsJointTransLimitMovement = false;
		--self.attacherVehicle.attacherJoint.allowsJointRotLimitMovement = true;
		
		if self.fastCouplerJoint ~= nil then
			self.fastCouplerJoint.moveDown = false;
		end;
		
	
		--[[
		self.fastCouplerJointBackUp = {};
		self.fastCouplerJointBackUp.maxRot = {};
		self.fastCouplerJointBackUp.maxRot2 = {};
		self.fastCouplerJointBackUp.minRot = {};
		self.fastCouplerJointBackUp.minRot2 = {};
		self.fastCouplerJointBackUp.maxRotLimit = {};
		for i=1,3 do
			self.fastCouplerJointBackUp.maxRot[i] = self.fastCouplerJoint.maxRot[i];
			self.fastCouplerJointBackUp.maxRot2[i] = self.fastCouplerJoint.maxRot2[i];
			self.fastCouplerJointBackUp.minRot[i] = self.fastCouplerJoint.minRot[i];
			self.fastCouplerJointBackUp.minRot2[i] = self.fastCouplerJoint.minRot2[i];
			self.fastCouplerJointBackUp.maxRotLimit[i] = self.fastCouplerJoint.maxRotLimit[i];
		end; 
		--for i=1,3 do
		for i=1,3 do
			self.fastCouplerJoint.maxRot[i] = self.fastCouplerJoint.minRot[i];
			self.fastCouplerJoint.maxRot2[i] = self.fastCouplerJoint.minRot2[i];
			self.fastCouplerJoint.maxRotLimit[i] = 0;
			self.fastCouplerJoint.minTransLimit[i] = 0;
			self.fastCouplerJoint.maxTransLimit[i] = 0;
		end; 
		self.fastCouplerJoint.maxRotLimit[1] = Utils.degToRad(16);
		]]--
		--end;
		--self.fastCouplerJointBackUp.allowsJointLimitMovement = self.fastCouplerJoint.allowsJointLimitMovement;	
		--print("allowsJointLimitMovement = "..tostring(self.fastCouplerJoint.allowsJointLimitMovement));		
		--print("allowsJointTransLimitMovement = "..tostring(self.attacherJoint.allowsJointTransLimitMovement));
		--self.fastCouplerJoint.allowsJointTransLimitMovement = false;
		--self.mowerIsAttached = false;
	end;	
	
	--if self.fastCouplerJoint ~= nil then
	--	self.fastCouplerJoint.moveDown = false;
	--end; 

	
	for k, part in pairs(self.movingParts) do
		part.isDirty = true;
	end;
	

	
	self.wasToFast = false;

	if self:getIsActive() then
			
		local toFast = self:doCheckSpeedLimit() and self.lastSpeed*3600 > 31;		
		local cuttingAreasSend = {};
		local winCutAreasSend = {};
		local winDropAreasSend = {};
		local validCutter = false;

		-- transport
		if self.alpMot.isLiftUp then
			
			if (self.alpMot.setTransport == true and self.alpMot.isTransport == false) or 
				(self.alpMot.setTransport == false and self.alpMot.isWorking == false) then
				
				
				for i,plane in pairs(self.alpMot.dynPlanes) do
					if plane.scale then
						local sx, sy, sz = getScale(plane.node)
						local newS = Utils.getMovedLimitedValues({sy}, {1.0}, {0.5}, 1, 4000, dt, self.alpMot.setTransport);
						setScale(plane.node, 1, newS[1], 1);
					end;
				end;				
					
				local x,y,z = getTranslation(self.componentJoints[1].jointNode);
				local newY = Utils.getMovedLimitedValues({y}, {-0.28515}, {-0.12023}, 1, 2000, dt, self.alpMot.setTransport);
				if self.isServer then
					setTranslation(self.componentJoints[1].jointNode, x, newY[1], z);
					setJointFrame(self.componentJoints[1].jointIndex, 0, self.componentJoints[1].jointNode);				
				end;
				
				local rx, ry, rz = getRotation(self.alpMot.left.node);
				local newVal = Utils.getMovedLimitedValues({rx, ry, rz}, self.alpMot.left.rotMin, self.alpMot.left.rotMax, 3, 4000, dt, self.alpMot.setTransport);
				setRotation(self.alpMot.left.node, newVal[1], newVal[2], newVal[3]);
				setRotation(self.alpMot.right.node, newVal[1], newVal[2], -newVal[3]);
				
				self.alpMot.isWorking = false;
				self.alpMot.isTransport = false;
				local chk = 0;
				for i=1,3 do
					if (newVal[i] == self.alpMot.left.rotMin[i])then 
						chk = chk + 1;
					end;
				end;
				if chk == 3 then
					self.alpMot.isWorking = true;
				end;
				if not self.alpMot.isWorking then
					chk = 0;
					for i=1,3 do
						if (newVal[i] == self.alpMot.left.rotMax[i]) then 
							chk = chk + 1;
						end;
					end;
					if chk == 3 then
						self.alpMot.isTransport = true;
					end;
				end;
				--print(tostring(self).."rz."..tostring(rz)..": "..tostring(self.alpMot.left.rotMin[3]).." "..tostring(self.alpMot.left.rotMax[3]).." "..tostring(self.alpMot.isWorking).." "..tostring(self.alpMot.isTransport));
				
			end;
				
			if self.alpMot.isWorking == false then
				self.alpMot.setTurnedOn = false;
			end;

		end;
			
		-- lift
		if self.alpMot.isWorking then 

			if (self.alpMot.setLiftUp == true and self.alpMot.isLiftUp == false) or 
				(self.alpMot.setLiftUp == false and self.alpMot.isLiftDown == false) then

				
				
				local rz = Utils.getMovedLimitedValues({self.alpMot.curFCjointRotLimit.z}, {Utils.degToRad(16)}, {0}, 1, 1500, dt, self.alpMot.setLiftUp);	
				setJointRotationLimit(self.fastCouplerJoint.jointIndex, 2, true, -rz[1], rz[1]);
				self.alpMot.curFCjointRotLimit.z = rz[1];					
				
				local newTransLimit = Utils.getMovedLimitedValues(self.alpMot.currentTransLimit, self.alpMot.maxTrans, self.alpMot.minTrans, 1, 1500, dt, self.alpMot.setLiftUp);
				--if math.abs(newTransLimit[1] * 100 - self.alpMot.currentTransLimit[1]*100) > 0.001 then		
				if self.isServer then				
					setJointTranslationLimit(self.componentJoints[1].jointIndex, 1, true, -newTransLimit[1], 0);
					local fac = ((self.alpMot.currentTransLimit[1]-self.alpMot.minTrans[1])/(self.alpMot.maxTrans[1]-self.alpMot.minTrans[1]));
					setJointRotationLimit(self.componentJoints[1].jointIndex, 0, true, 0, fac*Utils.degToRad(16));
					setJointRotationLimit(self.componentJoints[1].jointIndex, 2, true, 0, fac*Utils.degToRad(16));					
				end;
				--end;		
				self.alpMot.currentTransLimit = newTransLimit;		
				
				self.alpMot.isLiftDown = false;
				self.alpMot.isLiftUp = false;
				local chk = 0;
				for i=1,1 do
					if (self.alpMot.currentTransLimit[i] == self.alpMot.maxTrans[i]) then 
						chk = chk + 1;
					end;
				end;
				if chk == 1 then
					self.alpMot.isLiftDown = true;
				end;
				if not self.alpMot.isLiftDown then
					chk = 0;
					for i=1,1 do
						if (self.alpMot.currentTransLimit[i] == self.alpMot.minTrans[i]) then 
							chk = chk + 1;
						end;
					end;
					if chk == 1 then
						self.alpMot.isLiftUp = true;
					end;
				end;
				--print(tostring(self).."lift."..tostring(self.alpMot.isLiftUp).." "..tostring(self.alpMot.isLiftDown));
				
			end;				
			
		end;
			
		-- conditioner
		--[[if self.alpMot.setTurnedOn then
			--if self.alpMot.setSwath then
				local rx, ry, rz = getRotation(self.alpMot.walze);
				rx = rx - Utils.degToRad(40);
				setRotation(self.alpMot.walze, rx, ry, rz);
			--end;
		end;]]--
		
		if self.alpMot.setTurnedOn then
			if self.mowerStartSoundActive then
				local fac = 1.0;
				if self.mowerLoopTime > self.time then
					fac = 1.0 - (self.mowerLoopTime - self.time) / self.mowerStartDuration;
				end;
				local rx, ry, rz = getRotation(self.alpMot.walze);
				rx = rx - Utils.degToRad(40);
				setRotation(self.alpMot.walze, rx, ry, rz);
			else
				local rx, ry, rz = getRotation(self.alpMot.walze);
				rx = rx - Utils.degToRad(40);
				setRotation(self.alpMot.walze, rx, ry, rz);
			end;
		else
			if self.mowerLoopTime == -1 then
				if self.mowerLoopEndTime > self.time then
					local fac = (self.mowerLoopEndTime - self.time) / self.mowerStopDuration;
					local rx, ry, rz = getRotation(self.alpMot.walze);
					rx = rx - Utils.degToRad(40);
					setRotation(self.alpMot.walze, rx, ry, rz);
				end;
			end;
			
		end;		
			

		------------------
		-- mower & conditioner
		if self.isServer then
		 
			if not toFast and self.alpMot.isWorking and self.alpMot.setTurnedOn then
				
			-- fahrgassen
		
				local x,y,z = getWorldTranslation(self.alpMot.groundReferenceNode);
	            local terrainHeight = getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, x, 0, z);
				 if terrainHeight+self.alpMot.groundReferenceThreshold >= y then
					local xw,yw,zw = getWorldTranslation(self.alpMot.cuttingArea.start);
					local x1w,y1w,z1w = getWorldTranslation(self.alpMot.cuttingArea.width);
					local x2w,y2w,z2w = getWorldTranslation(self.alpMot.cuttingArea.height);
					area = Utils.updateMeadowArea(xw, zw, x1w, z1w, x2w, z2w);
					Utils.updateFruitCutLongArea(FruitUtil.FRUITTYPE_GRASS, xw, zw, x1w, z1w, x2w, z2w, 0);
                 
				
			end; 
						
			
			-- normal mähen
			for k, cuttingArea in pairs(self.alpMot.cuttingArea) do
			    local x,y,z = getWorldTranslation(self.alpMot.groundReferenceNode);
	            local terrainHeight = getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, x, 0, z);
					
				 if terrainHeight+self.alpMot.groundReferenceThreshold >= y then
					local x,y,z = getWorldTranslation(self.alpMot.cuttingArea.start);
					local x1,y1,z1 = getWorldTranslation(self.alpMot.cuttingArea.width);
					local x2,y2,z2 = getWorldTranslation(self.alpMot.cuttingArea.height);
					area = Utils.updateMeadowArea(x, z, x1, z1, x2, z2);
					Utils.updateFruitCutLongArea(FruitUtil.FRUITTYPE_GRASS, xw, zw, x1w, z1w, x2w, z2w, 0);
                    local pixelToQm = 2048 / 8192 * 2048 / 8192; -- 8192px are mapped to 2048m
                    local qm = area*pixelToQm;
                    local ha = qm/10000;		
				end;
				

			
			end;	
			
			
		end;
		end;
		--[[if self.isClient then		
			if self.alpMot.setTurnedOn and self:getIsActiveForSound() then
				if self.mowerSoundActive == false then
					setSamplePitch(self.mowerSound, self.mowerSoundPitchOffset);
					playSample(self.mowerSound, 0, self.mowerSoundVolume, 0);
					self.mowerSoundActive = true;
				end;
			else
				if self.mowerSoundActive == true then
					stopSample(self.mowerSound);
					self.mowerSoundActive = false;
				end;		
			end;
		end;]]--
			
		if self.isServer then
			if (table.getn(cuttingAreasSend) > 0) then
				MowerAreaEvent.runLocally(cuttingAreasSend);
				g_server:broadcastEvent(MowerAreaEvent:new(cuttingAreasSend));
			end;
			if table.getn(winDropAreasSend) > 0 then	
				local cutAreasSend, dropAreasSend, fruitType, bitType = WindrowAreaEvent.runLocally(winCutAreasSend, winDropAreasSend, self.accumulatedCuttingAreaValues);			
				if table.getn(cutAreasSend) > 0 then
					g_server:broadcastEvent(WindrowAreaEvent:new(cutAreasSend, dropAreasSend, fruitType, bitType));			
				end;
			end;
		end;
		

		
		if self.isServer then
			local changed = false;
			local state = false;
			if validCutter == true then 
				self.psTime = 0;
			else
				self.psTime = self.psTime + dt;
			end;
			if self.psTime < self.psTimeT then
				state = true;
			else
				state = false;
			end;
			if state ~= self.oldPSstate then
				--self.oldPSstate = self.psState;
				changed = true;
			end;
			if changed then
				self:setPSstate(state);
			end;
		end;		

			--if self.oldPSstate[i] ~= self.psState[i] then

		
			--end;
			
		-- attacher
		--if self.attacherVehicleJoint ~= nil then

		--end;
			
	else
		if self.isServer then
			local changed = false;
			local state = false;
			if state ~= self.oldPSstate then
				changed = true;
			end;
			if changed then
				self:setPSstate(state);
			end;
		end;
	end;
	
	
	if self.oldPSstate ~= self.psState then
		if self.alpMot.setTurnedOn and self.psState then
			Utils.setEmittingState(self.alpMot.cutPS.ps, self.alpMot.setTurnedOn);
		else
			Utils.setEmittingState(self.alpMot.cutPS.ps, false);			
		end;
		self.oldPSstate = self.psState;
	end;	
	
	
	if self.isClient then		
		if self.alpMot.setTurnedOn and self:getIsActiveForSound() then
			if self.mowerStartSoundActive == false then
				setSamplePitch(self.mowerStartSound, self.mowerStartSoundPitchOffset);
				playSample(self.mowerStartSound, 1, self.mowerStartSoundVolume, 0);
				self.mowerStartSoundActive = true;
				self.mowerLoopTime = self.time + self.mowerStartDuration;
			end;
		else
			if self.mowerLoopSoundActive == true then
				stopSample(self.mowerLoopSound);
				self.mowerLoopSoundActive = false;
				self.mowerLoopTime = -1;
				self.mowerStartSoundActive = false;
				setSamplePitch(self.mowerStopSound, self.mowerStopSoundPitchOffset);
				playSample(self.mowerStopSound, 1, self.mowerStopSoundVolume, 0);		
				self.mowerLoopEndTime = self.time + self.mowerStopDuration;				
			end;		
		end;
		if self:getIsActiveForSound() then
			if self.mowerLoopTime ~= -1 then
				if self.time > self.mowerLoopTime and self.mowerLoopSoundActive == false then
					setSamplePitch(self.mowerLoopSound, self.mowerLoopSoundPitchOffset);
					playSample(self.mowerLoopSound, 0, self.mowerLoopSoundVolume, 0);
					self.mowerLoopSoundActive = true;				
				end;
			end;
		else 
			if self.mowerLoopSoundActive == true then
				stopSample(self.mowerLoopSound);
				self.mowerLoopSoundActive = false;
				self.mowerLoopTime = -1;
				self.mowerStartSoundActive = false;
				setSamplePitch(self.mowerStopSound, self.mowerStopSoundPitchOffset);
				playSample(self.mowerStopSound, 1, self.mowerStopSoundVolume, 0);					
				self.mowerLoopEndTime = self.time + self.mowerStopDuration;
			end;				
		end;
	end;	
	


end;

function PoettingerAlpha:onAttach(attacherVehicle)
	self.mowerIsAttached = true;
	self.attacherVehicle = attacherVehicle;
	self.attacherVehicleCopy = attacherVehicle;
	
	--local rx, ry, rz = getRotation(self.alpMot.halter.node);
	--local newVal = Utils.getMovedLimitedValues({rx, ry, rz}, self.alpMot.halter.rotMax, self.alpMot.halter.rotMin, 3, 4000, dt, self.alpMot.setTransport);
	setRotation(self.alpMot.halter.node, self.alpMot.halter.rotMax[1], self.alpMot.halter.rotMax[2], self.alpMot.halter.rotMax[3]);	
	
	local x,y,z = getTranslation(self.componentJoints[1].jointNode);
	local newY = {-0.12023};
	setTranslation(self.componentJoints[1].jointNode, x, newY[1], z);
	setJointFrame(self.componentJoints[1].jointIndex, 0, self.componentJoints[1].jointNode);	
end;

function PoettingerAlpha:onDetach()
	self.attacherVehicleCopy.needsLowering = true;
	self.attacherVehicle = nil;
	self.parentAttVehJoint = nil;
	setRotation(self.alpMot.halter.node, self.alpMot.halter.rotMin[1], self.alpMot.halter.rotMin[2], self.alpMot.halter.rotMin[3]);	
	
	local x,y,z = getTranslation(self.componentJoints[1].jointNode);
	local newY = {-0.28515}; --{-0.10664}
	setTranslation(self.componentJoints[1].jointNode, x, newY[1], z);
	setJointFrame(self.componentJoints[1].jointIndex, 0, self.componentJoints[1].jointNode);		
end;

function PoettingerAlpha:draw()
	g_currentMission:addHelpButtonText(string.format(g_i18n:getText("POETX_TurnOnOff"), tostring(self.alpMot.setTurnedOn)), InputBinding.POETX_TURNONOFF );
	--g_currentMission:addHelpButtonText(string.format(g_i18n:getText("POETX_SwathOnOff"), tostring(self.alpMot.setSwath)), InputBinding.POETX_SWATHONOFF);
	g_currentMission:addHelpButtonText(string.format(g_i18n:getText("POETX_Transport"), tostring(self.alpMot.setTransport)), InputBinding.POETX_TRANSPORT);
--	g_currentMission:addHelpButtonText(string.format(g_i18n:getText("POETX_Select"), tostring(self.x8.selectionIdx)), InputBinding.POETX_SELECT);
end;


function PoettingerAlpha:setLiftUp(value, noEventSend)
	SetLiftUpEvent.sendEvent(self, value, noEventSend);
	self.alpMot.setLiftUp = value;

end;

function PoettingerAlpha:setTurnedOn(value, noEventSend)
	SetTurnedOnEvent.sendEvent(self, value, noEventSend);
	self.alpMot.setTurnedOn = value;
end;
 
--function PoettingerAlpha:setSwath(value, noEventSend)
	--SetSwathEvent.sendEvent(self, value, noEventSend);
	--self.alpMot.setSwath = value;
--end;
 

function PoettingerAlpha:setTransport(value, noEventSend)
	SetTransportEvent.sendEvent(self, value, noEventSend);
	self.alpMot.setTransport = value;
end;
 
function PoettingerAlpha:setPSstate(value, noEventSend)
	SetPSstateEvent.sendEvent(self, value, noEventSend);
	self.psState = value;
end;
 