SetSelectionEvent = {};
SetSelectionEvent_mt = Class(SetSelectionEvent, Event);

InitEventClass(SetSelectionEvent, "SetSelectionEvent");

function SetSelectionEvent:emptyNew()
    local self = Event:new(SetSelectionEvent_mt);
    self.className = "SetSelectionEvent";
    return self;
end;

function SetSelectionEvent:new(object, state)
    local self = SetSelectionEvent:emptyNew()
    self.object = object;
	self.state = state;
    return self;
end;

function SetSelectionEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.object = networkGetObject(id);
	self.state = streamReadInt8(streamId);
    self:run(connection);
end;

function SetSelectionEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteInt8(streamId, self.state);
end;

function SetSelectionEvent:run(connection)
	self.object:setSelection(self.state, true);
	if not connection:getIsServer() then
		g_server:broadcastEvent(SetSelectionEvent:new(self.object, self.state), nil, connection, self.object);
	end;
end;

function SetSelectionEvent.sendEvent(vehicle, state, noEventSend)
	if state ~= vehicle.x8.selectionIdx then
		if noEventSend == nil or noEventSend == false then
			if g_server ~= nil then
				g_server:broadcastEvent(SetSelectionEvent:new(vehicle, state), nil, nil, vehicle);
			else
				g_client:getServerConnection():sendEvent(SetSelectionEvent:new(vehicle, state));
			end;
		end;
	end;
end;

