SetTransportEvent = {};
SetTransportEvent_mt = Class(SetTransportEvent, Event);

InitEventClass(SetTransportEvent, "SetTransportEvent");

function SetTransportEvent:emptyNew()
    local self = Event:new(SetTransportEvent_mt);
    self.className = "SetTransportEvent";
    return self;
end;

function SetTransportEvent:new(object, state)
    local self = SetTransportEvent:emptyNew()
    self.object = object;
	self.state = state;
    return self;
end;

function SetTransportEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.object = networkGetObject(id);
	self.state = streamReadBool(streamId);
    self:run(connection);
end;

function SetTransportEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteBool(streamId, self.state);
end;

function SetTransportEvent:run(connection)
	self.object:setTransport(self.state, true);
	if not connection:getIsServer() then
		g_server:broadcastEvent(SetTransportEvent:new(self.object, self.state), nil, connection, self.object);
	end;
end;

function SetTransportEvent.sendEvent(vehicle, state, noEventSend)
	if state ~= vehicle.alpMot.setTransport then
		if noEventSend == nil or noEventSend == false then
			if g_server ~= nil then
				g_server:broadcastEvent(SetTransportEvent:new(vehicle, state), nil, nil, vehicle);
			else
				g_client:getServerConnection():sendEvent(SetTransportEvent:new(vehicle, state));
			end;
		end;
	end;
end;

