SetTurnedOnEvent = {};
SetTurnedOnEvent_mt = Class(SetTurnedOnEvent, Event);

InitEventClass(SetTurnedOnEvent, "SetTurnedOnEvent");

function SetTurnedOnEvent:emptyNew()
    local self = Event:new(SetTurnedOnEvent_mt);
    self.className = "SetTurnedOnEvent";
    return self;
end;

function SetTurnedOnEvent:new(object, state)
    local self = SetTurnedOnEvent:emptyNew()
    self.object = object;
	self.state = state;
    return self;
end;

function SetTurnedOnEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.object = networkGetObject(id);
	self.state = streamReadBool(streamId);
    self:run(connection);
end;

function SetTurnedOnEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteBool(streamId, self.state);
end;

function SetTurnedOnEvent:run(connection)
	self.object:setTurnedOn(self.state, true);
	if not connection:getIsServer() then
		g_server:broadcastEvent(SetTurnedOnEvent:new(self.object, self.state), nil, connection, self.object);
	end;
end;

function SetTurnedOnEvent.sendEvent(vehicle, state, noEventSend)
	if state ~= vehicle.x8.mowers[vehicle.x8.selectionIdx].setTurnedOn then
		if noEventSend == nil or noEventSend == false then
			if g_server ~= nil then
				g_server:broadcastEvent(SetTurnedOnEvent:new(vehicle, state), nil, nil, vehicle);
			else
				g_client:getServerConnection():sendEvent(SetTurnedOnEvent:new(vehicle, state));
			end;
		end;
	end;
end;

