SetSwathEvent = {};
SetSwathEvent_mt = Class(SetSwathEvent, Event);

InitEventClass(SetSwathEvent, "SetSwathEvent");

function SetSwathEvent:emptyNew()
    local self = Event:new(SetSwathEvent_mt);
    self.className = "SetSwathEvent";
    return self;
end;

function SetSwathEvent:new(object, state)
    local self = SetSwathEvent:emptyNew()
    self.object = object;
	self.state = state;
    return self;
end;

function SetSwathEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.object = networkGetObject(id);
	self.state = streamReadBool(streamId);
    self:run(connection);
end;

function SetSwathEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteBool(streamId, self.state);
end;

function SetSwathEvent:run(connection)
	self.object:setSwath(self.state, true);
	if not connection:getIsServer() then
		g_server:broadcastEvent(SetSwathEvent:new(self.object, self.state), nil, connection, self.object);
	end;
end;

function SetSwathEvent.sendEvent(vehicle, state, noEventSend)
	if state ~= vehicle.x8.mowers[vehicle.x8.selectionIdx].setSwath then
		if noEventSend == nil or noEventSend == false then
			if g_server ~= nil then
				g_server:broadcastEvent(SetSwathEvent:new(vehicle, state), nil, nil, vehicle);
			else
				g_client:getServerConnection():sendEvent(SetSwathEvent:new(vehicle, state));
			end;
		end;
	end;
end;

