SetPSstatesEvent = {};
SetPSstatesEvent_mt = Class(SetPSstatesEvent, Event);

InitEventClass(SetPSstatesEvent, "SetPSstatesEvent");

function SetPSstatesEvent:emptyNew()
    local self = Event:new(SetPSstatesEvent_mt);
    self.className = "SetPSstatesEvent";
    return self;
end;

function SetPSstatesEvent:new(object, states)
    local self = SetPSstatesEvent:emptyNew()
    self.object = object;
	self.states = {};
	for i=1,2 do
		self.states[i] = states[i];
	end;
    return self;
end;

function SetPSstatesEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.object = networkGetObject(id);
	self.states = {};
	for i=1,2 do
		self.states[i] = streamReadBool(streamId);
	end;
    self:run(connection);
end;

function SetPSstatesEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
	for i=1,2 do
		streamWriteBool(streamId, self.states[i]);
	end;
end;

function SetPSstatesEvent:run(connection)
	self.object:setPSstates(self.states, true);
	if not connection:getIsServer() then
		g_server:broadcastEvent(SetPSstatesEvent:new(self.object, self.states), nil, connection, self.object);
	end;
end;

function SetPSstatesEvent.sendEvent(vehicle, states, noEventSend)
	local check = false;
	for i=1,2 do
		if vehicle.psState[i] ~= states[i] then
			check = true;
			break;
		end;
	end;	
	if check then
		if noEventSend == nil or noEventSend == false then
			if g_server ~= nil then
				g_server:broadcastEvent(SetPSstatesEvent:new(vehicle, states), nil, nil, vehicle);
			else
				g_client:getServerConnection():sendEvent(SetPSstatesEvent:new(vehicle, states));
			end;
		end;
	end;
end;

