SetCollectorEvent = {};
SetCollectorEvent_mt = Class(SetCollectorEvent, Event);

InitEventClass(SetCollectorEvent, "SetCollectorEvent");

function SetCollectorEvent:emptyNew()
    local self = Event:new(SetCollectorEvent_mt);
    self.className = "SetCollectorEvent";
    return self;
end;

function SetCollectorEvent:new(object, state)
    local self = SetCollectorEvent:emptyNew()
    self.object = object;
	self.state = state;
    return self;
end;

function SetCollectorEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.object = networkGetObject(id);
	self.state = streamReadBool(streamId);
    self:run(connection);
end;

function SetCollectorEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteBool(streamId, self.state);
end;

function SetCollectorEvent:run(connection)
	self.object:setCollector(self.state, true);
	if not connection:getIsServer() then
		g_server:broadcastEvent(SetCollectorEvent:new(self.object, self.state), nil, connection, self.object);
	end;
end;

function SetCollectorEvent.sendEvent(vehicle, state, noEventSend)
	if state ~= vehicle.x8.mowers[vehicle.x8.selectionIdx].setCllctr then
		if noEventSend == nil or noEventSend == false then
			if g_server ~= nil then
				g_server:broadcastEvent(SetCollectorEvent:new(vehicle, state), nil, nil, vehicle);
			else
				g_client:getServerConnection():sendEvent(SetCollectorEvent:new(vehicle, state));
			end;
		end;
	end;
end;

