--
-- PoettingerX8
-- Specialization for PoettingerX8
--
-- @author  	fruktor 
-- @version 	v0.1
-- @date  		14/07/11
-- @history:	v0.1 - Initial version
--

 
PoettingerX8 = {};

function PoettingerX8.prerequisitesPresent(specializations)
	return true;
end;

function PoettingerX8:load(xmlFile)


 
         

		local numCuttingAreas = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.cuttingAreas#count"), 2);
		 self.cuttingAreas = {}
    for i=1, numCuttingAreas do
	  self.cuttingAreas[i] = {};
        local areanamei = string.format("vehicle.cuttingAreas.cuttingArea%d", i);
        self.cuttingAreas[i].start = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#startIndex"));
        self.cuttingAreas[i].width = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#widthIndex"));
        self.cuttingAreas[i].height = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#heightIndex"));
    end;

  local numWindrowerDropAreas = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.windrowerDropAreas#count"), 2);
    self.windrowerDropAreas = {}
    for i=1, numWindrowerDropAreas do
        self.windrowerDropAreas[i] = {};
        local areanamei = string.format("vehicle.windrowerDropAreas.windrowerDropArea%d", i);
        self.windrowerDropAreas[i].start = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#startIndex"));
        self.windrowerDropAreas[i].width = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#widthIndex"));
        self.windrowerDropAreas[i].height = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#heightIndex"));
    end;

    self.lowerRmp = SpecializationUtil.callSpecializationsFunction("lowerRmp");



	self.x8 = {};
	
	self.setLiftUp = SpecializationUtil.callSpecializationsFunction("setLiftUp");
	self.setTurnedOn = SpecializationUtil.callSpecializationsFunction("setTurnedOn");
	self.setSwath = SpecializationUtil.callSpecializationsFunction("setSwath");
	self.setCollector = SpecializationUtil.callSpecializationsFunction("setCollector");
	self.setTransport = SpecializationUtil.callSpecializationsFunction("setTransport");
	self.setSelection = SpecializationUtil.callSpecializationsFunction("setSelection");
	self.setPSstates = SpecializationUtil.callSpecializationsFunction("setPSstates");

	self.x8.selectionName = {};
	self.x8.selectionIdx = 1;
	self.x8.mowers = {};
	
	for i,j in pairs( {'left', 'right', 'all'} ) do
		self.x8.selectionName[i] = j;
		local entry = {};
		if j ~= 'all' then
			local key = "vehicle.PoetX8."..j;
			
			local jnts = {};
			for k=1,3 do 
				local jnt = {};
				jnt.Idx = getXMLInt(xmlFile, key..".jnt"..k.."#idx");
				jnt.rotMin1 = Utils.getVectorNFromString(getXMLString(xmlFile, key..".jnt"..k.."#rotMin1")); 
				jnt.rotMin2 = Utils.getVectorNFromString(getXMLString(xmlFile, key..".jnt"..k.."#rotMin2"));
				jnt.rotMax = Utils.getVectorNFromString(getXMLString(xmlFile, key..".jnt"..k.."#rotMax"));
				jnt.limitMin = Utils.getVectorNFromString(getXMLString(xmlFile, key..".jnt"..k.."#limitMin"));
				jnt.limitMax = Utils.getVectorNFromString(getXMLString(xmlFile, key..".jnt"..k.."#limitMax"));
				jnt.duration = getXMLFloat(xmlFile, key..".jnt"..k.."#duration");
				jnt.curLimit = {};
				for i=1,3 do
					jnt.rotMin1[i] = Utils.degToRad(jnt.rotMin1[i]);
					jnt.rotMin2[i] = Utils.degToRad(jnt.rotMin2[i]);
					jnt.rotMax[i] = Utils.degToRad(jnt.rotMax[i]);
					jnt.limitMin[i] = Utils.degToRad(jnt.limitMin[i]);
					jnt.limitMax[i] = Utils.degToRad(jnt.limitMax[i]);
					jnt.curLimit[i] = jnt.limitMin[i];
				end;
				table.insert(jnts, jnt);
			end;
			
			-- movement
			
			local springBase = {};
			springBase.node = Utils.indexToObject( self.components, getXMLString(xmlFile, key..".springBase#idx"));
			springBase.rotMin = Utils.getVectorNFromString( getXMLString(xmlFile, key..".springBase#rotMin") );
			springBase.rotMax = Utils.getVectorNFromString( getXMLString(xmlFile, key..".springBase#rotMax") );
			for i=1,3 do
				springBase.rotMin[i] = Utils.degToRad( springBase.rotMin[i] );
				springBase.rotMax[i] = Utils.degToRad( springBase.rotMax[i] );
			end;			
			
			local valve = {};
			valve.node = Utils.indexToObject( self.components, getXMLString(xmlFile, key..".valve#idx"));
			valve.rotMin = Utils.getVectorNFromString( getXMLString(xmlFile, key..".valve#rotMin") );
			valve.rotMax = Utils.getVectorNFromString( getXMLString(xmlFile, key..".valve#rotMax") );
			for i=1,3 do
				valve.rotMin[i] = Utils.degToRad( valve.rotMin[i] );
				valve.rotMax[i] = Utils.degToRad( valve.rotMax[i] );
			end;
			
			local clltr = {};
			clltr.node = Utils.indexToObject( self.components, getXMLString(xmlFile, key..".collector#idx"));
			clltr.rotMin = Utils.getVectorNFromString( getXMLString(xmlFile, key..".collector#rotMin") );
			clltr.rotMax = Utils.getVectorNFromString( getXMLString(xmlFile, key..".collector#rotMax") );
			for i=1,3 do
				clltr.rotMin[i] = Utils.degToRad( clltr.rotMin[i] );
				clltr.rotMax[i] = Utils.degToRad( clltr.rotMax[i] );
			end;
			
			local roll = {};
			roll.node = Utils.indexToObject( self.components, getXMLString(xmlFile, key..".roll#idx"));
			roll.speed = getXMLFloat(xmlFile, key..".roll#speed");
		
			entry.jnts = jnts;
			entry.springBase = springBase;
			entry.valve = valve;
			entry.clltr = clltr;
			entry.roll = roll;
		
		self.vehicleType = getXMLString(xmlFile, "vehicle#type");
					
			entry.groundReferenceNode = Utils.indexToObject( self.components, getXMLString(xmlFile, key..".groundReference#idx"));
			entry.groundReferenceThreshold = getXMLFloat(xmlFile, key..".groundReference#thresh");
		
		
			-- ps
			entry.cutPS = {};
			entry.cutPS.ps = {};
			entry.cutPS.active = false;
			baseName = key..".PScut";
			Utils.loadParticleSystem(xmlFile, entry.cutPS.ps, baseName, self.components, false, nil, self.baseDirectory);			
			entry.cutPS.node = Utils.indexToObject( self.components, getXMLString(xmlFile, key..".PScut#node"));
			entry.windrow1PS = {};
			entry.windrow1PS.ps = {};
			entry.windrow1PS.active = false;
			baseName = key..".PSwindrow1";
			Utils.loadParticleSystem(xmlFile, entry.windrow1PS.ps, baseName, self.components, false, nil, self.baseDirectory);				
			entry.windrow1PS.node = Utils.indexToObject( self.components, getXMLString(xmlFile, key..".PSwindrow1#node"));
			entry.windrow2PS = {};
			entry.windrow2PS.ps = {};
			entry.windrow2PS.active = false;
			baseName = key..".PSwindrow2";
			Utils.loadParticleSystem(xmlFile, entry.windrow2PS.ps, baseName, self.components, false, nil, self.baseDirectory);				
			entry.windrow2PS.node = Utils.indexToObject( self.components, getXMLString(xmlFile, key..".PSwindrow2#node"));
			
			-- "dynamic" plane, aka the flagshader from SRS
			--<dynPlane idx="1>0|5">
			entry.dynPlanes = {};
			local i=0;
			while true do
				i = i + 1;
				local node = Utils.indexToObject( self.components, getXMLString(xmlFile, string.format("%s.dynPlane%d#idx", key, i)));
				if node == nil then break; end;
				local scale = Utils.getNoNil( getXMLBool(xmlFile,  string.format("%s.dynPlane%d#scale", key, i)), false );
				local e = {};
				e.node = node;
				e.scale = scale;
				table.insert(entry.dynPlanes, e);
			end;
			entry.dynPlanesActive = true;				
		end;
		
		entry.name = j;
		entry.setTurnedOn = false;
		entry.setSwath = true;
		
		entry.setLiftUp = false;
		entry.isLiftUp = false;
		entry.isLiftDown = true;
		
		entry.setCllctr = false;
		entry.isCllctrDown = true;
		entry.isCllctrUp = false;
		
		entry.setTransport = false;
		entry.isTransport = false;
		entry.isWorking = true;
		
		table.insert(self.x8.mowers, entry);
	end;

	self.psTime = {300, 300};
	self.psTimeT = {300, 300};

	self.psState = {false, false};
	self.oldPSstate = {false, false};
		
	
	self.accumulatedCuttingAreaValues = {};
	self.accumulatedCuttingAreaValues[1] = 0;
	self.accumulatedCuttingAreaValues[2] = 0;
	
	--# finally a HUD 
	self.hud = {};
	local path = Utils.getFilename("hud/bg.png", self.baseDirectory);
	--self.hud.overlay = Overlay:new("hudOverlay", path, 0.75, 0.2128, 0.248, 0.25);
	self.hud.overlay = Overlay:new("hudOverlay", path, 0.75, 0.2228, 0.248, 0.145);
	self.hud.displayHUD = 1;
	
	
	-- sound
	local mowerStartSound = getXMLString(xmlFile, string.format("vehicle.mowerStartSound#file"));
	mowerStartSound = Utils.getFilename(mowerStartSound, self.baseDirectory); 
	self.mowerStartSound = {};
	self.mowerStartSound = createSample(string.format("mowerStartSound"));
	loadSample(self.mowerStartSound, mowerStartSound, false);
	self.mowerStartSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, string.format("vehicle.mowerStartSound#pitchOffset")), 1);
	self.mowerStartSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, string.format("vehicle.mowerStartSound#volume")), 1);
	self.mowerStartSoundActive = false;	
	self.mowerStartDuration = getSampleDuration(self.mowerStartSound);
	
	-- sound
	local mowerLoopSound = getXMLString(xmlFile, string.format("vehicle.mowerLoopSound#file"));
	mowerLoopSound = Utils.getFilename(mowerLoopSound, self.baseDirectory); 
	self.mowerLoopSound = {};
	self.mowerLoopSound = createSample(string.format("mowerLoopSound"));
	loadSample(self.mowerLoopSound, mowerLoopSound, false);
	self.mowerLoopSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, string.format("vehicle.mowerLoopSound#pitchOffset")), 1);
	self.mowerLoopSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, string.format("vehicle.mowerLoopSound#volume")), 1);
	self.mowerLoopSoundActive = false;
	self.mowerLoopTime = -1;	

	-- sound
	local mowerStopSound = getXMLString(xmlFile, string.format("vehicle.mowerStopSound#file"));
	mowerStopSound = Utils.getFilename(mowerStopSound, self.baseDirectory); 
	self.mowerStopSound = {};
	self.mowerStopSound = createSample(string.format("mowerStopSound"));
	loadSample(self.mowerStopSound, mowerStopSound, false);
	self.mowerStopSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, string.format("vehicle.mowerStopSound#pitchOffset")), 1);
	self.mowerStopSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, string.format("vehicle.mowerStopSound#volume")), 1);
	self.mowerStopSoundActive = false;		
	self.mowerStopDuration = getSampleDuration(self.mowerStopSound);
	self.mowerLoopEndTime = -1;	-- used to syn the rolls' movement
end

function PoettingerX8:delete()
	stopSample(self.mowerStartSound);
	stopSample(self.mowerLoopSound);
	stopSample(self.mowerStopSound);
	delete(self.mowerStartSound);
	delete(self.mowerLoopSound);
	delete(self.mowerStopSound);
	Utils.deleteParticleSystem(self.x8.mowers[1].cutPS.ps);	
	Utils.deleteParticleSystem(self.x8.mowers[1].windrow1PS.ps);	
	Utils.deleteParticleSystem(self.x8.mowers[1].windrow2PS.ps);	
	Utils.deleteParticleSystem(self.x8.mowers[2].cutPS.ps);	
	Utils.deleteParticleSystem(self.x8.mowers[2].windrow1PS.ps);	
	Utils.deleteParticleSystem(self.x8.mowers[2].windrow2PS.ps);	
end;

function PoettingerX8:mouseEvent(posX, posY, isDown, isUp, button)
end;

function PoettingerX8:keyEvent(unicode, sym, modifier, isDown)
end;

function PoettingerX8:readStream(streamId, connection)
	for i,j in pairs(self.x8.mowers) do
		j.setTurnedOn = streamReadBool( streamId );
		j.setSwath = streamReadBool( streamId );
		
		j.setLiftUp = streamReadBool( streamId );
		j.isLiftUp = streamReadBool( streamId );
		j.isLiftDown = streamReadBool( streamId );
		
		j.setCllctr = streamReadBool( streamId );
		j.isCllctrDown = streamReadBool( streamId );
		j.isCllctrUp = streamReadBool( streamId );
		
		j.setTransport = streamReadBool( streamId );
		j.isTransport = streamReadBool( streamId );
		j.isWorking = streamReadBool( streamId );
		
		if j.name == 'all' then
			break;
		end;
					
		local rxS = streamReadFloat32( streamId ); 
		local ryS = streamReadFloat32( streamId ); 
		local rzS = streamReadFloat32( streamId ); 
		local rxV = streamReadFloat32( streamId ); 
		local ryV = streamReadFloat32( streamId ); 
		local rzV = streamReadFloat32( streamId ); 			
			
		for i,plane in pairs(j.dynPlanes) do
			if plane.scale then
				if j.setTransport == true then
					setScale(plane.node, 1, 0.5, 1);
				else
					setScale(plane.node, 1, 1.0, 1);
				end;
			end;
		end;
		
		setRotation(j.springBase.node, rxS, ryS, rzS);
		setRotation(j.valve.node, rxV, ryV, rzV);
		
		local newVal = getRotation(j.clltr.node);
		if self.x8.mowers[i].setTransport == true or j.setCllctr == false then
			newVal = j.clltr.rotMin;
		else
			newVal = j.clltr.rotMax;
		end;
		setRotation(j.clltr.node, newVal[1], newVal[2], newVal[3]);		
	end;

	for i=1,2 do
		self.psState[i] = streamReadBool( streamId );
		self.oldPSstate[i] = streamReadBool( streamId );
	end;
end;


function PoettingerX8:writeStream(streamId, connection)
	for i,j in pairs(self.x8.mowers) do
		streamWriteBool( streamId, j.setTurnedOn );
		streamWriteBool( streamId, j.setSwath );		
		
		streamWriteBool( streamId, j.setLiftUp );
		streamWriteBool( streamId, j.isLiftUp );
		streamWriteBool( streamId, j.isLiftDown );
		
		streamWriteBool( streamId, j.setCllctr );
		streamWriteBool( streamId, j.isCllctrDown );
		streamWriteBool( streamId, j.isCllctrUp );
		
		streamWriteBool( streamId, j.setTransport );
		streamWriteBool( streamId, j.isTransport );
		streamWriteBool( streamId, j.isWorking );
	
		local j = self.x8.mowers[i];
		if j.name == 'all' then
			break;
		end;
		
		local rx, ry, rz = getRotation(j.springBase.node);
		streamWriteFloat32( streamId, rx ); 
		streamWriteFloat32( streamId, ry ); 
		streamWriteFloat32( streamId, rz ); 

		local rx, ry, rz = getRotation(j.valve.node);
		streamWriteFloat32( streamId, rx ); 
		streamWriteFloat32( streamId, ry ); 
		streamWriteFloat32( streamId, rz ); 
	end;

	for i=1,2 do
		streamWriteBool( streamId, self.psState[i] );
		streamWriteBool( streamId, self.oldPSstate[i] );
	end;
end;

function PoettingerX8:readStreamUpdate(streamId, connection)
end;

function PoettingerX8:writeStreamUpdate(streamId, connection)
end;

function PoettingerX8:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	for i=1,3 do
		self.x8.mowers[i].setTurnedOn = Utils.getNoNil( getXMLBool(xmlFile,key..string.format("#mowers%d.setTurnedOn", i)), false);
		self.x8.mowers[i].setTransport = Utils.getNoNil( getXMLBool(xmlFile,key..string.format("#mowers%d.setTransport", i)), false);
		self.x8.mowers[i].isWorking = Utils.getNoNil( getXMLBool(xmlFile,key..string.format("#mowers%d.isWorking", i)), false);
		self.x8.mowers[i].isTransport = Utils.getNoNil( getXMLBool(xmlFile,key..string.format("#mowers%d.isTransport", i)), false);
		self.x8.mowers[i].setLiftUp = Utils.getNoNil( getXMLBool(xmlFile,key..string.format("#mowers%d.setLiftUp", i)), false);
		self.x8.mowers[i].isLiftUp = Utils.getNoNil( getXMLBool(xmlFile,key..string.format("#mowers%d.isLiftUp", i)), false);
		self.x8.mowers[i].isLiftDown = Utils.getNoNil( getXMLBool(xmlFile,key..string.format("#mowers%d.isLiftDown", i)), false);
		self.x8.mowers[i].setCllctr = Utils.getNoNil( getXMLBool(xmlFile,key..string.format("#mowers%d.setCllctr", i)), false);
		self.x8.mowers[i].isCllctrDown = Utils.getNoNil( getXMLBool(xmlFile,key..string.format("#mowers%d.isCllctrDown", i)), false);
		self.x8.mowers[i].isCllctrUp = Utils.getNoNil( getXMLBool(xmlFile,key..string.format("#mowers%d.isCllctrUp", i)), false);

		local j = self.x8.mowers[i];
		if j.name == 'all' then
			break;
		end;
			
		for i,plane in pairs(j.dynPlanes) do
			if plane.scale then
				if j.setTransport == true then
					setScale(plane.node, 1, 0.5, 1);
				else
					setScale(plane.node, 1, 1.0, 1);
				end;
			end;
		end;
		
		local newVal = getRotation(j.springBase.node);
		if self.x8.mowers[i].setTransport then
			newVal = j.springBase.rotMax;
		else
			newVal = j.springBase.rotMin;
		end;
		setRotation(j.springBase.node, newVal[1], newVal[2], newVal[3]);
		
		local newVal = getRotation(j.valve.node);
		if self.x8.mowers[i].setTransport then
			newVal = j.valve.rotMax;
		else
			newVal = j.valve.rotMin;
		end;
		setRotation(j.valve.node, newVal[1], newVal[2], newVal[3]);
		
		local newVal = getRotation(j.clltr.node);
		if self.x8.mowers[i].setTransport == true or j.setCllctr == false then
			newVal = j.clltr.rotMin;
		else
			newVal = j.clltr.rotMax;
		end;
		setRotation(j.clltr.node, newVal[1], newVal[2], newVal[3]);
		
		for k=1,3 do
			local rx, ry, rz = Utils.getVectorFromString(getXMLString(xmlFile, key ..string.format("#mowers%d.jnt%d.rot", i, k)));		
			setRotation(self.componentJoints[j.jnts[k].Idx].jointNode, rx, ry, rz);
			setJointFrame(self.componentJoints[j.jnts[k].Idx].jointIndex, 0, self.componentJoints[j.jnts[k].Idx].jointNode);
			--if self.isServer then
		end;			
		for k=1,2 do
			local rxl, ryl, rzl = Utils.getVectorFromString(getXMLString(xmlFile, key ..string.format("#mowers%d.jnt%d.rotL", i, k)));		
			--if self.isServer then
				setJointRotationLimit(self.componentJoints[j.jnts[k].Idx].jointIndex, 0, true, -rxl, rxl);
				setJointRotationLimit(self.componentJoints[j.jnts[k].Idx].jointIndex, 1, true, -ryl, ryl);
				setJointRotationLimit(self.componentJoints[j.jnts[k].Idx].jointIndex, 2, true, -rzl, rzl);
			--end;		
			j.jnts[k].curLimit = {rxl, ryl, rzl};
		end;

	end;
	
	return BaseMission.VEHICLE_LOAD_OK;
end;

function PoettingerX8:getSaveAttributesAndNodes(nodeIdent)
	local attributes = ' ';
	for i=1,3 do
		local m = self.x8.mowers[i];
		local mystring = 	
			string.format(' mowers%d.setTurnedOn="', i)..tostring(m.setTurnedOn)..'"'..
			string.format(' mowers%d.setTransport="', i)..tostring(m.setTransport)..'"'..
			string.format(' mowers%d.isWorking="', i)..tostring(m.isWorking)..'"'..
			string.format(' mowers%d.isTransport="', i)..tostring(m.isTransport)..'"'..
			string.format(' mowers%d.setLiftUp="', i)..tostring(m.setLiftUp)..'"'..
			string.format(' mowers%d.isLiftUp="', i)..tostring(m.isLiftUp)..'"'..
			string.format(' mowers%d.isLiftDown="', i)..tostring(m.isLiftDown)..'"'..
			string.format(' mowers%d.setCllctr="', i)..tostring(m.setCllctr)..'"'..
			string.format(' mowers%d.isCllctrDown="', i)..tostring(m.isCllctrDown)..'"'..
			string.format(' mowers%d.isCllctrUp="', i)..tostring(m.isCllctrUp)..'"';	
		attributes = attributes .. mystring;
			
		j = self.x8.mowers[i];
		if j.name == 'all' then break; end;
		local jntstr = ' ';
		for k=1,3 do
			local rx, ry, rz = getRotation(self.componentJoints[j.jnts[k].Idx].jointNode);		
			jntstr = jntstr .. string.format(' mowers%d.jnt%d.rot="%f %f %f"', i, k, rx, ry, rz);
			jntstr = jntstr .. string.format(' mowers%d.jnt%d.rotL="%f %f %f"', i, k, j.jnts[k].curLimit[1], j.jnts[k].curLimit[2], j.jnts[k].curLimit[3]);
		end;
		attributes = attributes .. jntstr;
	end;	
	
	local node = nil;
    return attributes, node;
end;


function PoettingerX8:update(dt)
	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.LOWER_IMPLEMENT) then
			if self.x8.mowers[self.x8.selectionIdx].isWorking or self.x8.selectionIdx == 3 then
				local state = not self.x8.mowers[self.x8.selectionIdx].setLiftUp;
				--self:setLiftUp( state );
				if self.attacherVehicle ~= nil and self.x8.selectionIdx == 3 then
					for i, impl in pairs(self.attacherVehicle.attachedImplements) do
						if impl.object ~= nil then
							if impl.object ~= self then 
								if impl.object.attachedImplements ~= nil then	-- fast coupler
									if impl.object.attachedImplements[1] ~= nil then
										if impl.object.attachedImplements[1].object.alpMot ~= nil then 
											self.x8.alphaRef = impl.object.attachedImplements[1].object.alpMot;
											self.x8.alphaRefTime = 0;
											self.x8.alphaRefState = state;
											self.x8.alphaRefTimeThresh = 1400;										
											impl.object.attachedImplements[1].object:setLiftUp(state);
										end;
									end;
								end;
							end;
						end;
					end;
				end;
				if self.x8.alphaRef == nil then
					self:setLiftUp( state );
				end;				
			end;
		end;
		if self.x8.alphaRef ~= nil then
			self.x8.alphaRefTime = self.x8.alphaRefTime + dt;
			if self.x8.alphaRefTime > self.x8.alphaRefTimeThresh then
				self:setLiftUp( self.x8.alphaRefState );
				self.x8.alphaRef = nil;
			end;
		end;
		
		if InputBinding.hasEvent(InputBinding.POETX_TURNONOFF) then
			if self.x8.mowers[self.x8.selectionIdx].isWorking or self.x8.selectionIdx == 3 then
				local state = not self.x8.mowers[self.x8.selectionIdx].setTurnedOn;
				self:setTurnedOn( state );
				if self.attacherVehicle ~= nil and self.x8.selectionIdx == 3 then
					for i, impl in pairs(self.attacherVehicle.attachedImplements) do
						if impl.object ~= nil then
							if impl.object ~= self then 
								if impl.object.attachedImplements ~= nil then	-- fast coupler
									if impl.object.attachedImplements[1] ~= nil then
										if impl.object.attachedImplements[1].object.alpMot ~= nil then
											impl.object.attachedImplements[1].object:setTurnedOn(state);
										end;
									end;
								end;
							end;
						end;
					end;
				end;	

			end;
		end;

		--[[if InputBinding.hasEvent(InputBinding.POETX_SWATHONOFF) then
			local state = not self.x8.mowers[self.x8.selectionIdx].setSwath
			self:setSwath( state );
			if self.attacherVehicle ~= nil and self.x8.selectionIdx == 3 then
				for i, impl in pairs(self.attacherVehicle.attachedImplements) do
					if impl.object ~= nil then
						if impl.object ~= self then 
							if impl.object.attachedImplements ~= nil then	-- fast coupler
								if impl.object.attachedImplements[1] ~= nil then
									if impl.object.attachedImplements[1].object.alpMot ~= nil then 
										impl.object.attachedImplements[1].object:setSwath(state);
									end;
								end;
							end;
						end;
					end;
				end;
			end;				
		end;]]--
		if InputBinding.hasEvent(InputBinding.POETX_COLLECTOR) then
			if self.x8.mowers[self.x8.selectionIdx].isWorking or self.x8.selectionIdx == 3 then
				local state = not self.x8.mowers[self.x8.selectionIdx].setCllctr;
				self:setCollector( state );
		
			end;
		end;
		if InputBinding.hasEvent(InputBinding.POETX_TRANSPORT) then
			if self.x8.mowers[self.x8.selectionIdx].isLiftUp or self.x8.selectionIdx == 3 then
				local state = not self.x8.mowers[self.x8.selectionIdx].setTransport;
				self:setTransport( state );
				if self.attacherVehicle ~= nil and self.x8.selectionIdx == 3 then
					for i, impl in pairs(self.attacherVehicle.attachedImplements) do
						if impl.object ~= nil then
							if impl.object ~= self then 
								if impl.object.attachedImplements ~= nil then	-- fast coupler
									if impl.object.attachedImplements[1] ~= nil then
										if impl.object.attachedImplements[1].object.alpMot ~= nil then 
											impl.object.attachedImplements[1].object:setTransport(state);
										end;
									end;
								end;
							end;
						end;
					end;
				end;				
			end;
		end;
		if InputBinding.hasEvent(InputBinding.POETX_SELECT) then
			self:setSelection( self.x8.selectionIdx + 1 );
		end;
		if InputBinding.hasEvent(InputBinding.POETX_HUD) then
			self.hud.displayHUD = self.hud.displayHUD + 1;
			if self.hud.displayHUD > 1 then
				self.hud.displayHUD = 0;
			end;
		end;		
		
		if InputBinding.hasEvent(InputBinding.POETX_FRONT) then
			if self.attacherVehicle ~= nil then
				for i, impl in pairs(self.attacherVehicle.attachedImplements) do
					if impl.object ~= nil then
						if impl.object ~= self then 
							if impl.object.attachedImplements ~= nil then	-- fast coupler
								if impl.object.attachedImplements[1] ~= nil then
									if impl.object.attachedImplements[1].object.alpMot ~= nil then 
										local state = impl.object.attachedImplements[1].object.alpMot.setLiftUp;
										impl.object.attachedImplements[1].object:setLiftUp(not state);
									end;
								end;
							end;
						end;
					end;
				end;
			end;		
		end;
		if InputBinding.hasEvent(InputBinding.POETX_LEFT) then
			if self.x8.mowers[1].isWorking then
				local idx = self.x8.selectionIdx;
				self:setSelection(1);
				self:setLiftUp( not self.x8.mowers[1].setLiftUp );
				self:setSelection(idx);
			end;
		end;
		if InputBinding.hasEvent(InputBinding.POETX_RIGHT) then
			if self.x8.mowers[2].isWorking then
				local idx = self.x8.selectionIdx;
				self:setSelection(2);
				self:setLiftUp( not self.x8.mowers[2].setLiftUp );
				self:setSelection(idx);
			end;
		end;
	end;

	
end;

function PoettingerX8:updateTick(dt)
	
	for k, part in pairs(self.movingParts) do
		part.isDirty = true;
	end;
	
	if self.mowerIsAttached then
		for i=1, table.getn(self.attacherVehicle.attachedImplements) do
			if self.attacherVehicle.attachedImplements[i].object == self then			
				local index = self.attacherVehicle.attachedImplements[i].jointDescIndex;
				self.attacherVehicleJoint = self.attacherVehicle.attacherJoints[index];	
				--for i,j in pairs(self.attacherVehicleJoint) do
					--print(tostring(i).."  "..tostring(j));
					--if type(j) == 'table' then
					--	for x,y in pairs(j) do
					--		print("."..tostring(x).."  "..tostring(y));
					--	end;
					--end;
				--end;
				
				self.attacherVehicleJointBackUp = {};
				self.attacherVehicleJointBackUp.maxRot = {};
				self.attacherVehicleJointBackUp.maxRot2 = {};
				self.attacherVehicleJointBackUp.minRot = {};
				self.attacherVehicleJointBackUp.minRot2 = {};
				self.attacherVehicleJointBackUp.maxRotLimit = {};
				for i=1,3 do
					self.attacherVehicleJointBackUp.maxRot[i] = self.attacherVehicleJoint.maxRot[i];
					self.attacherVehicleJointBackUp.maxRot2[i] = self.attacherVehicleJoint.maxRot2[i];
					self.attacherVehicleJointBackUp.minRot[i] = self.attacherVehicleJoint.minRot[i];
					self.attacherVehicleJointBackUp.minRot2[i] = self.attacherVehicleJoint.minRot2[i];
					self.attacherVehicleJointBackUp.maxRotLimit[i] = self.attacherVehicleJoint.maxRotLimit[i];
				end; 
				self.attacherVehicleJointBackUp.allowsJointLimitMovement = self.attacherVehicleJoint.allowsJointLimitMovement;
				break;				
			end;
		end;
		self.mowerIsAttached = false;
	end;

	local spd = self.lastSpeed*3600;		
	
	if spd < 5 then
		if self.x8.mowers[1].dynPlanesActive == true then
			self.x8.mowers[1].dynPlanesActive = false;
			for i,plane in pairs(self.x8.mowers[1].dynPlanes) do
				setShaderParameter(plane.node, "displacementSpeedFrequencyAndTexOff", 0.1, 0, 0, 0.15,false);
			end;
		end;
		if self.x8.mowers[2].dynPlanesActive == true then
			self.x8.mowers[2].dynPlanesActive = false;
			for i,plane in pairs(self.x8.mowers[2].dynPlanes) do
				setShaderParameter(plane.node, "displacementSpeedFrequencyAndTexOff", 0.1, 0, 0, 0.15,false);
			end;
		end;
	else
		if self.x8.mowers[1].dynPlanesActive == false and spd > 5 then
			self.x8.mowers[1].dynPlanesActive = true;
			for i,plane in pairs(self.x8.mowers[1].dynPlanes) do
				setShaderParameter(plane.node, "displacementSpeedFrequencyAndTexOff", 0.1, 4, 0.9, 0.15,false);
			end;
		end;
		if self.x8.mowers[2].dynPlanesActive == false and spd > 5 then
			self.x8.mowers[2].dynPlanesActive = true;
			for i,plane in pairs(self.x8.mowers[2].dynPlanes) do
				setShaderParameter(plane.node, "displacementSpeedFrequencyAndTexOff", 0.1, 4, 0.9, 0.15,false);
			end;
		end;
	end;	
	
	
	self.wasToFast = false;

	if self:getIsActive() then
			
		local toFast = self:doCheckSpeedLimit() and self.lastSpeed*3600 > 31;		
		local validCutters = {false, false};

		for i,j in pairs(self.x8.mowers) do
			if j.name == 'all' then
				break;
			end;
		
			-- transport
			if j.isLiftUp then
			
				if (j.setTransport == true and j.isTransport == false) or 
					(j.setTransport == false and j.isWorking == false) then
					
					for i,plane in pairs(j.dynPlanes) do
						if plane.scale then
							local sx, sy, sz = getScale(plane.node);
							local newS = Utils.getMovedLimitedValues({sy}, {1.0}, {0.5}, 1, j.jnts[1].duration/2, dt, j.setTransport);
							setScale(plane.node, 1, newS[1], 1);
						end;
					end;

					local newRots = {};
					for k=1,2 do
						local rx, ry, rz = getRotation(self.componentJoints[j.jnts[k].Idx].jointNode);
						newRots[k] = {};
						newRots[k] = Utils.getMovedLimitedValues({rx, ry, rz}, j.jnts[k].rotMin2, j.jnts[k].rotMax, 3, j.jnts[k].duration, dt, j.setTransport);
						setRotation(self.componentJoints[j.jnts[k].Idx].jointNode, newRots[k][1], newRots[k][2], newRots[k][3]);
						if self.isServer then
							setJointFrame(self.componentJoints[j.jnts[k].Idx].jointIndex, 0, self.componentJoints[j.jnts[k].Idx].jointNode);
						end;
					end;

					local rx, ry, rz = getRotation(j.springBase.node);
					local newVal = Utils.getMovedLimitedValues({rx, ry, rz}, j.springBase.rotMin, j.springBase.rotMax, 3, j.jnts[1].duration, dt, j.setTransport);
					setRotation(j.springBase.node, newVal[1], newVal[2], newVal[3]);
					
					local rx, ry, rz = getRotation(j.valve.node);
					local newVal = Utils.getMovedLimitedValues({rx, ry, rz}, j.valve.rotMin, j.valve.rotMax, 3, j.jnts[1].duration/2, dt, j.setTransport);
					setRotation(j.valve.node, newVal[1], newVal[2], newVal[3]);
					
					local newLimits = {};
					for k=1,2 do
						newLimits[k] = Utils.getMovedLimitedValues(j.jnts[k].curLimit, j.jnts[k].limitMin, j.jnts[k].limitMax, 3, j.jnts[k].duration, dt, j.setTransport);
						if self.isServer then
							setJointRotationLimit(self.componentJoints[j.jnts[k].Idx].jointIndex, 0, true, -newLimits[k][1], newLimits[k][1]);
							setJointRotationLimit(self.componentJoints[j.jnts[k].Idx].jointIndex, 1, true, -newLimits[k][2], newLimits[k][2]);
							setJointRotationLimit(self.componentJoints[j.jnts[k].Idx].jointIndex, 2, true, -newLimits[k][3], newLimits[k][3]);
						end;
						j.jnts[k].curLimit = newLimits[k];
					end;					
				
					j.isWorking = false;
					j.isTransport = false;
					local chk = 0;
					for k=1,2 do
						for i=1,3 do
							if (newRots[k][i] == j.jnts[k].rotMin2[i]) and (newVal[i] == j.valve.rotMin[i]) and (newLimits[k][i] == j.jnts[k].limitMin[i]) then 
								chk = chk + 1;
							end;
						end;
					end;
					if chk == 6 then
						j.isWorking = true;
					end;
					if not j.isWorking then
						chk = 0;
						for k=1,2 do
							for i=1,3 do
								if (newRots[k][i] == j.jnts[k].rotMax[i]) and (newVal[i] == j.valve.rotMax[i]) and (newLimits[k][i] == j.jnts[k].limitMax[i]) then 
									chk = chk + 1;
								end;
							end;
						end;
						if chk == 6 then
							j.isTransport = true;
						end;
					end;
					--print(tostring(self).."tran."..tostring(i)..": "..tostring(j).." "..tostring(j.isWorking).." "..tostring(j.isTransport));
					
				end;
				
				if j.isWorking == false then
					j.setTurnedOn = false;
					j.setCllctr = true;
				end;

			end;
			
			-- lift
			if j.isWorking == true then 

				if (j.setLiftUp == true and j.isLiftUp == false) or 
					(j.setLiftUp == false and j.isLiftDown == false) then
					
					local newRots = {};
					for k=1,2 do
						local rx, ry, rz = getRotation(self.componentJoints[j.jnts[k].Idx].jointNode);
						newRots[k] = {};
						newRots[k] = Utils.getMovedLimitedValues({rx, ry, rz}, j.jnts[k].rotMin1, j.jnts[k].rotMin2, 3, 1500, dt, j.setLiftUp);
						setRotation(self.componentJoints[j.jnts[k].Idx].jointNode, newRots[k][1], newRots[k][2], newRots[k][3]);
						if self.isServer then
							setJointFrame(self.componentJoints[j.jnts[k].Idx].jointIndex, 0, self.componentJoints[j.jnts[k].Idx].jointNode);
						end;
					end;				
					
					j.isLiftDown = false;
					j.isLiftUp = false;
					local chk = 0;
					for k=1,2 do
						for i=1,3 do
							--print(tostring(newRots[k][i]).." "..tostring(j.jnts[k].rotMin2[i]).." "..tostring(j.jnts[k].rotMin1[i]));
							if (newRots[k][i] == j.jnts[k].rotMin2[i]) then 
								chk = chk + 1;
							end;
						end;
					end;
					if chk == 6 then
						j.isLiftUp = true;
					end;
					if not j.isLiftUp then
						chk = 0;
						for k=1,2 do
							for i=1,3 do
								if (newRots[k][i] == j.jnts[k].rotMin1[i]) then 
									chk = chk + 1;
								end;
							end;
						end;
						if chk == 6 then
							j.isLiftDown = true;
						end;
					end;
					--print(tostring(self).."lift."..tostring(i)..": "..tostring(j).." "..tostring(j.isLiftUp).." "..tostring(j.isLiftDown));
					
					
				end;				
				
			end;
			
			-- conditioner
			if j.setTurnedOn then
				if self.mowerStartSoundActive then
					local fac = 1.0;
					if self.mowerLoopTime > self.time then
						fac = 1.0 - (self.mowerLoopTime - self.time) / self.mowerStartDuration;
					end;
					local rx, ry, rz = getRotation(j.roll.node);
					rx = rx - fac*Utils.degToRad(j.roll.speed);
					setRotation(j.roll.node, rx, ry, rz);
				else
					local rx, ry, rz = getRotation(j.roll.node);
					rx = rx - Utils.degToRad(j.roll.speed);
					setRotation(j.roll.node, rx, ry, rz);
				end;
			else
				if self.mowerLoopTime == -1 then
					if self.mowerLoopEndTime > self.time then
						local fac = (self.mowerLoopEndTime - self.time) / self.mowerStopDuration;
						local rx, ry, rz = getRotation(j.roll.node);
						rx = rx - fac*Utils.degToRad(j.roll.speed);
						setRotation(j.roll.node, rx, ry, rz);
					end;
				end;
				
			end;
			
			-- collector
			if not j.isWorking then 
				j.setCllctr = false;
			end;
			if (j.setCllctr == false and j.isCllctrDown == false) or 
				(j.setCllctr == true and j.isCllctrUp == false) then
				local rx, ry, rz = getRotation(j.clltr.node);
				local newVal = Utils.getMovedLimitedValues({rx, ry, rz}, j.clltr.rotMin, j.clltr.rotMax, 3, j.jnts[1].duration/2, dt, j.setCllctr);
				setRotation(j.clltr.node, newVal[1], newVal[2], newVal[3]);			
				
				j.isCllctrDown = false;
				j.isCllctrUp = false;
				local chk = 0;
				for i=1,3 do
					if (newVal[i] == j.clltr.rotMin[i]) then 
						chk = chk + 1;
					end;
				end;
				if chk == 3 then
					j.isCllctrDown = true;
				end;
				if not j.isCllctrDown then
					chk = 0;
					for i=1,3 do
						if (newVal[i] == j.clltr.rotMax[i]) then 
							chk = chk + 1;
						end;
					end;
					if chk == 3 then
						j.isCllctrUp = true;
					end;
				end;
				--print("coll."..tostring(i)..": "..tostring(j).." "..tostring(j.isCllctrDown).." "..tostring(j.isCllctrUp));
			end;
			

				------------------
			-- mower & conditioner
		if self.isServer then		 
			if not toFast and j.isWorking and j.setTurnedOn then		
			
        	local x,y,z = getWorldTranslation(j.groundReferenceNode);
                local terrainHeight = getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, x, 0, z);
                if terrainHeight+j.groundReferenceThreshold >= y then
                    local numDropAreas = table.getn(self.windrowerDropAreas);
                    local numAreas = table.getn(self.cuttingAreas);
                    local sum = 0;
                    local fruitType = FruitUtil.FRUITTYPE_GRASS;
                    local fruitTypeFix = false;
                    for k, cuttingArea in pairs(self.cuttingAreas) do
             
                            local x,y,z = getWorldTranslation(cuttingArea.start);
                            local x1,y1,z1 = getWorldTranslation(cuttingArea.width);
                            local x2,y2,z2 = getWorldTranslation(cuttingArea.height);

                            Utils.updateMeadowArea(x, z, x1, z1, x2, z2);
                    
                    end;
                    for i=1, numAreas do
                        local cuttingArea = self.cuttingAreas[i];
                            local x,y,z = getWorldTranslation(cuttingArea.start);
                            local x1,y1,z1 = getWorldTranslation(cuttingArea.width);
                            local x2,y2,z2 = getWorldTranslation(cuttingArea.height);
                          	local area = Utils.getFruitArea(FruitUtil.FRUITTYPE_GRASS, x, z, x1, z1, x2, z2, 0);
							local area2 = Utils.getFruitCutLongArea(FruitUtil.FRUITTYPE_GRASS, x, z, x1, z1, x2, z2, 0);
							local area3 = Utils.getFruitWindrowArea(FruitUtil.FRUITTYPE_GRASS, x, z, x1, z1, x2, z2, 0);							
							if area > 0 or area2 > 0 or area3 > 0 then
								validCutters[i] = true;
							end;							
                           
                     
                           if not fruitTypeFix then
                              fruitType = FruitUtil.FRUITTYPE_GRASS;
                           end;
                        if j.isCllctrDown == true then
                            local area = Utils.updateFruitCutLongArea(fruitType, x, z, x1, z1, x2, z2, 0);
                            area = area + Utils.updateFruitWindrowArea(fruitType, x, z, x1, z1, x2, z2, 0);
                            if area == 0 and not fruitTypeFix then
                                fruitType = FruitUtil.FRUITTYPE_DRYGRASS;
                                area = Utils.updateFruitCutLongArea(fruitType, x, z, x1, z1, x2, z2, 0);
                                area = area + Utils.updateFruitWindrowArea(fruitType, x, z, x1, z1, x2, z2, 0);
                            end;
                           
                             if area > 0 then
                                fruitTypeFix = true;
                            end;							  
                
                    
                            if numDropAreas >= numAreas then
                                if area > 0 then
                                    local dropArea = self.windrowerDropAreas[i];
                                    local x,y,z = getWorldTranslation(dropArea.start);
                                    local x1,y1,z1 = getWorldTranslation(dropArea.width);
                                    local x2,y2,z2 = getWorldTranslation(dropArea.height);
                                    local old, total = Utils.getFruitWindrowArea(fruitType, x, z, x1, z1, x2, z2);
                                    area = area + old;
                                    local value = area / total;
                                    if value < 1 and value > 0.08 then
                                        value = 1;
                                    else
                                        value = math.floor(value + 0.6);
                                    end;
                                    if value >= 1 then
                                        value = math.min(value, g_currentMission.maxWindrowValue);
                                        Utils.updateFruitWindrowArea(fruitType, x, z, x1, z1, x2, z2, value, true, false);
									end;
                                end;
								else
                                sum = sum + area;
                            end;
						  end; 	
                    end;
					   if sum > 0 and numDropAreas > 0 then
                        local dropArea = self.windrowerDropAreas[1];
                        local x,y,z = getWorldTranslation(dropArea.start);
                        local x1,y1,z1 = getWorldTranslation(dropArea.width);
                        local x2,y2,z2 = getWorldTranslation(dropArea.height);
                        local old, total = Utils.getFruitWindrowArea(fruitType, x, z, x1, z1, x2, z2);
                        sum = sum + old;
                        local value = math.floor(sum / total + 0.7); -- round, biased to the bigger value
                        if value >= 1 then
                            value = math.min(value, g_currentMission.maxWindrowValue);
                            Utils.updateFruitWindrowArea(fruitType, x, z, x1, z1, x2, z2, value, true, false);								
                        end;
                    end;
					
                end;

                end;
				
				
				
				
				
				
				
				
				
		end;
		end;		 

				 
		if self.isServer then
			local changed = false;
			local state = {false, false};
			for i=1,2 do				
				if validCutters[i] == true then 
					self.psTime[i] = 0;
				else
					self.psTime[i] = self.psTime[i] + dt;
				end;
				if self.psTime[i] < self.psTimeT[i] then
					state[i] = true;
				else
					state[i] = false;
				end;
				if state[i] ~= self.oldPSstate[i] then
					--self.oldPSstate[i] = state;
					changed = true;
				end;
			end;
			if changed then
				self:setPSstates(state);
			end;
		end;

		-- attacher
		if self.attacherVehicleJoint ~= nil then
			local newRotMinZ = 3.14;
			for i=1,2 do
				local j = self.x8.mowers[i];
				local rx, ry, rz = getRotation(self.componentJoints[j.jnts[1].Idx].jointNode);
				if math.abs(rz) < newRotMinZ then
					newRotMinZ = rz;
				end;
			end;
			local j = self.x8.mowers[1];
			local prct = 1.0 - math.min(1.0, math.max(0.0, math.abs(newRotMinZ-j.jnts[1].rotMin1[3])/math.abs(j.jnts[1].rotMax[3]-j.jnts[1].rotMin1[3])));
			--print("prct="..prct.." <-"..tostring(newRotMinZ).." "..tostring(math.abs(newRotMinZ-j.jnts[1].rotMin1[3])));
			local newPrct = prct;
			if self.x8.mowers[1].isWorking == true or self.x8.mowers[2].isWorking == true then
				local dir;
				if self.x8.mowers[1].setLiftUp == true and self.x8.mowers[2].setLiftUp == true then
					dir = true;
				else
					dir = false;
				end;
				local newVal = Utils.getMovedLimitedValues({self.attacherVehicleJoint.maxTransLimit[2]}, {0}, {0.3}, 1, 1000, dt, not dir);
				self.attacherVehicleJoint.maxTransLimit[2] = newVal[1];
				if self.isServer then
					setJointTranslationLimit(self.attacherVehicleJoint.jointIndex, 1, true, -newVal[1], newVal[1]);
				end; 
				
				if self.attacherVehicleJoint ~= nil then
					for i=1,3 do
						self.attacherVehicleJoint.maxRot[i] = self.attacherVehicleJointBackUp.maxRot[i]*(1 - newPrct);
						self.attacherVehicleJoint.maxRot2[i] = self.attacherVehicleJointBackUp.maxRot2[i]*(1 - newPrct);
						self.attacherVehicleJoint.minRot[i] = self.attacherVehicleJointBackUp.minRot[i]*(1 - newPrct);
						self.attacherVehicleJoint.minRot2[i] = self.attacherVehicleJointBackUp.minRot2[i]*(1 - newPrct);
						--self.attacherVehicleJoint.maxRotLimit[i] = self.attacherVehicleJointBackUp.maxRotLimit[i]*(1 - prct*0.7);
					end;
				end;				
			elseif self.x8.mowers[1].isWorking == false and self.x8.mowers[2].isWorking == false then
				if self.x8.mowers[1].setTransport == true and self.x8.mowers[2].setTransport == true then
					--newPrct = 1;
					local newVal = Utils.getMovedLimitedValues({self.attacherVehicleJoint.maxRot[1]}, {0}, {self.attacherVehicleJointBackUp.maxRot[1]}, 1, 3000, dt, false);
					newPrct = 1.0 - newVal[1]/self.attacherVehicleJointBackUp.maxRot[1];
					if self.attacherVehicleJoint ~= nil then
						for i=1,3 do
						self.attacherVehicleJoint.maxRot[i] = self.attacherVehicleJointBackUp.maxRot[i]*(1 - newPrct);
						self.attacherVehicleJoint.maxRot2[i] = self.attacherVehicleJointBackUp.maxRot2[i]*(1 - newPrct);
						self.attacherVehicleJoint.minRot[i] = self.attacherVehicleJointBackUp.minRot[i]*(1 - newPrct);
						self.attacherVehicleJoint.minRot2[i] = self.attacherVehicleJointBackUp.minRot2[i]*(1 - newPrct);
							--self.attacherVehicleJoint.maxRotLimit[i] = self.attacherVehicleJointBackUp.maxRotLimit[i]*(1 - prct*0.7);
						end;
					end;
				end;
			end;
				
			self.attacherVehicleJoint.moveDown = false;			-- !!
	
		end;
		
	else
				 
		if self.isServer then
			local changed = false;
			local state = {false, false};
			for i=1,2 do				
				if state[i] ~= self.oldPSstate[i] then
					changed = true;
				end;
			end;
			if changed then
				self:setPSstates(state);
			end;	
		end;
	
	end;
	
	
	for i,j in pairs(self.x8.mowers) do
		if i == 3 then break; end;
		if self.oldPSstate[i] ~= self.psState[i] or
			j.isCllctrDown ~= j.oldIsCllctrDown then 
			if j.setTurnedOn and self.psState[i] then
				Utils.setEmittingState(j.cutPS.ps, j.setTurnedOn);
				if j.isCllctrDown then
					Utils.setEmittingState(j.windrow1PS.ps, j.setSwath);
					Utils.setEmittingState(j.windrow2PS.ps, j.setSwath);
				else
					Utils.setEmittingState(j.windrow1PS.ps, j.setSwath);
					Utils.setEmittingState(j.windrow2PS.ps, false);
				end;
			else
				Utils.setEmittingState(j.cutPS.ps, false);			
				Utils.setEmittingState(j.windrow1PS.ps, false);
				Utils.setEmittingState(j.windrow2PS.ps, false);
			end;
			self.oldPSstate[i] = self.psState[i];
			j.oldIsCllctrDown = j.isCllctrDown;
		end;
	end;
			
	
			
	if self.isClient then		
		if (self.x8.mowers[1].setTurnedOn or self.x8.mowers[2].setTurnedOn) and self:getIsActiveForSound() then
			if self.mowerStartSoundActive == false then
				setSamplePitch(self.mowerStartSound, self.mowerStartSoundPitchOffset);
				playSample(self.mowerStartSound, 1, self.mowerStartSoundVolume, 0);
				self.mowerStartSoundActive = true;
				self.mowerLoopTime = self.time + self.mowerStartDuration;
			end;
		else
			if self.mowerLoopSoundActive == true then
				stopSample(self.mowerLoopSound);
				self.mowerLoopSoundActive = false;
				self.mowerLoopTime = -1;
				self.mowerStartSoundActive = false;
				setSamplePitch(self.mowerStopSound, self.mowerStopSoundPitchOffset);
				playSample(self.mowerStopSound, 1, self.mowerStopSoundVolume, 0);	
				self.mowerLoopEndTime = self.time + self.mowerStopDuration;
			end;		
		end;
		if self:getIsActiveForSound() then
			if self.mowerLoopTime ~= -1 then
				if self.time > self.mowerLoopTime and self.mowerLoopSoundActive == false then
					setSamplePitch(self.mowerLoopSound, self.mowerLoopSoundPitchOffset);
					playSample(self.mowerLoopSound, 0, self.mowerLoopSoundVolume, 0);
					self.mowerLoopSoundActive = true;				
				end;
			end;
		else 
			if self.mowerLoopSoundActive == true then
				stopSample(self.mowerLoopSound);
				self.mowerLoopSoundActive = false;
				self.mowerLoopTime = -1;
				self.mowerStartSoundActive = false;
				setSamplePitch(self.mowerStopSound, self.mowerStopSoundPitchOffset);
				playSample(self.mowerStopSound, 1, self.mowerStopSoundVolume, 0);					
				self.mowerLoopEndTime = self.time + self.mowerStopDuration;
			end;				
		end;
	end;
		
	--

end;

function PoettingerX8:onAttach(attacherVehicle)
	self.mowerIsAttached = true;
	
	
end;

function PoettingerX8:onDetach()
	if self.attacherVehicleJoint ~= nil then
		for i=1,3 do
			self.attacherVehicleJoint.maxRot[i] = self.attacherVehicleJointBackUp.maxRot[i];
			self.attacherVehicleJoint.maxRot2[i] = self.attacherVehicleJointBackUp.maxRot2[i];
			self.attacherVehicleJoint.minRot[i] = self.attacherVehicleJointBackUp.minRot[i];
			self.attacherVehicleJoint.minRot2[i] = self.attacherVehicleJointBackUp.minRot2[i];
			self.attacherVehicleJoint.maxRotLimit[i] = self.attacherVehicleJointBackUp.maxRotLimit[i];
			--self.attacherVehicleJoint.allowsJointLimitMovement = false
		end;
		self.attacherVehicleJoint = nil;
	end;

end;

function PoettingerX8:draw()
	--g_currentMission:addHelpButtonText(string.format(g_i18n:getText("POETX_TurnOnOff"), tostring(self.x8.mowers[self.x8.selectionIdx].setTurnedOn)), InputBinding.POETX_TURNONOFF );
	--g_currentMission:addHelpButtonText(string.format(g_i18n:getText("POETX_SwathOnOff"), tostring(self.x8.mowers[self.x8.selectionIdx].setSwath)), InputBinding.POETX_SWATHONOFF);
	--g_currentMission:addHelpButtonText(string.format(g_i18n:getText("POETX_Collector"), tostring(self.x8.mowers[self.x8.selectionIdx].setCllctr)), InputBinding.POETX_COLLECTOR);
	--g_currentMission:addHelpButtonText(string.format(g_i18n:getText("POETX_Transport"), tostring(self.x8.mowers[self.x8.selectionIdx].setTransport)), InputBinding.POETX_TRANSPORT);
	--g_currentMission:addHelpButtonText(string.format(g_i18n:getText("POETX_Select"), tostring(self.x8.selectionIdx)), InputBinding.POETX_SELECT);
	local xpos = 0.75;
	local ypos = 0.3578; --0.3378; -- + 0.08;
	setTextBold(false);
	setTextColor(0.0, 0.0, 0.0, 1.0);
	if self.hud.displayHUD == 1 then
		self.hud.overlay:render();
		
		renderText(xpos, ypos-0.02, 0.02, string.format(g_i18n:getText("POETX_HUDs"), InputBinding.getKeyNamesOfDigitalAction(InputBinding.POETX_HUD)));
		--renderText(xpos, ypos, 0.02, g_i18n:getText("POETX8_HUDtext1"));
		renderText(xpos, ypos-0.022, 0.02, "__________________________");
		renderText(xpos, ypos-0.04, 0.02, string.format(g_i18n:getText("POETX_SELECTs"), 
			InputBinding.getKeyNamesOfDigitalAction(InputBinding.POETX_SELECT), self.x8.selectionName[self.x8.selectionIdx]));
		renderText(xpos, ypos-0.06, 0.02, string.format(g_i18n:getText("POETX_FOLDs"), InputBinding.getKeyNamesOfDigitalAction(InputBinding.POETX_TRANSPORT)));
		renderText(xpos, ypos-0.08, 0.02, string.format(g_i18n:getText("POETX_UPDOWNs"), InputBinding.getKeyNamesOfDigitalAction(InputBinding.LOWER_IMPLEMENT)));
		renderText(xpos, ypos-0.10, 0.02, string.format(g_i18n:getText("POETX_ONOFFs"), InputBinding.getKeyNamesOfDigitalAction(InputBinding.POETX_TURNONOFF)));
		renderText(xpos, ypos-0.12, 0.02, string.format(g_i18n:getText("POETX_COLLECTORs"), InputBinding.getKeyNamesOfDigitalAction(InputBinding.POETX_COLLECTOR)));
		
	else
		renderText(xpos, ypos-0.12, 0.02, string.format(g_i18n:getText("POETX_HUDs"), InputBinding.getKeyNamesOfDigitalAction(InputBinding.POETX_HUD)));
		renderText(xpos, ypos-0.14, 0.02, string.format(g_i18n:getText("POETX_SELECTs"), 
			InputBinding.getKeyNamesOfDigitalAction(InputBinding.POETX_SELECT), self.x8.selectionName[self.x8.selectionIdx]));
	end;	
	setTextColor(1.0, 1.0, 1.0, 1.0);
	xpos = xpos - 0.0005;
	if self.hud.displayHUD == 1 then
		self.hud.overlay:render();
		
		renderText(xpos, ypos-0.0193, 0.02, string.format(g_i18n:getText("POETX_HUDs"), InputBinding.getKeyNamesOfDigitalAction(InputBinding.POETX_HUD)));
		--renderText(xpos, ypos, 0.02, g_i18n:getText("POETX8_HUDtext1"));
		renderText(xpos, ypos-0.0213, 0.02, "__________________________");
		renderText(xpos, ypos-0.0393, 0.02, string.format(g_i18n:getText("POETX_SELECTs"), 
			InputBinding.getKeyNamesOfDigitalAction(InputBinding.POETX_SELECT), self.x8.selectionName[self.x8.selectionIdx]));
		renderText(xpos, ypos-0.0593, 0.02, string.format(g_i18n:getText("POETX_FOLDs"), InputBinding.getKeyNamesOfDigitalAction(InputBinding.POETX_TRANSPORT)));
		renderText(xpos, ypos-0.0793, 0.02, string.format(g_i18n:getText("POETX_UPDOWNs"), InputBinding.getKeyNamesOfDigitalAction(InputBinding.LOWER_IMPLEMENT)));
		renderText(xpos, ypos-0.0993, 0.02, string.format(g_i18n:getText("POETX_ONOFFs"), InputBinding.getKeyNamesOfDigitalAction(InputBinding.POETX_TURNONOFF)));
		renderText(xpos, ypos-0.1193, 0.02, string.format(g_i18n:getText("POETX_COLLECTORs"), InputBinding.getKeyNamesOfDigitalAction(InputBinding.POETX_COLLECTOR)));
		
	else
		renderText(xpos, ypos-0.1193, 0.02, string.format(g_i18n:getText("POETX_HUDs"), InputBinding.getKeyNamesOfDigitalAction(InputBinding.POETX_HUD)));
		renderText(xpos, ypos-0.1393, 0.02, string.format(g_i18n:getText("POETX_SELECTs"), 
			InputBinding.getKeyNamesOfDigitalAction(InputBinding.POETX_SELECT), self.x8.selectionName[self.x8.selectionIdx]));
	end;	
	setTextColor(1.0, 1.0, 1.0, 1.0);
end;



function PoettingerX8:setLiftUp(value, noEventSend)
	SetLiftUpEvent.sendEvent(self, value, noEventSend);
	self.x8.mowers[self.x8.selectionIdx].setLiftUp = value;
	if( self.x8.selectionIdx == 3 ) then
		self.x8.mowers[1].setLiftUp = value;
		self.x8.mowers[2].setLiftUp = value;
	end;
	self.x8.mowers[3].setLiftUp = self.x8.mowers[1].setLiftUp and self.x8.mowers[2].setLiftUp;	
end;

function PoettingerX8:setTurnedOn(value, noEventSend)
	SetTurnedOnEvent.sendEvent(self, value, noEventSend);
	self.x8.mowers[self.x8.selectionIdx].setTurnedOn = value;
	if( self.x8.selectionIdx == 3 ) then
		self.x8.mowers[1].setTurnedOn = value;
		self.x8.mowers[2].setTurnedOn = value;
	end;
	self.x8.mowers[3].setTurnedOn = self.x8.mowers[1].setTurnedOn and self.x8.mowers[2].setTurnedOn;	
end;
 
--[[function PoettingerX8:setSwath(value, noEventSend)
	SetSwathEvent.sendEvent(self, value, noEventSend);
	self.x8.mowers[self.x8.selectionIdx].setSwath = value;
	if( self.x8.selectionIdx == 3 ) then
		self.x8.mowers[1].setSwath = value;
		self.x8.mowers[2].setSwath = value;
	end;
end;]]--
 
function PoettingerX8:setCollector(value, noEventSend)
	SetCollectorEvent.sendEvent(self, value, noEventSend);
	self.x8.mowers[self.x8.selectionIdx].setCllctr = value;
	if( self.x8.selectionIdx == 3 ) then
		self.x8.mowers[1].setCllctr = value;
		self.x8.mowers[2].setCllctr = value;
	end;
	self.x8.mowers[3].setCllctr = self.x8.mowers[1].setCllctr and self.x8.mowers[2].setCllctr;
end;
 
function PoettingerX8:setTransport(value, noEventSend)
	SetTransportEvent.sendEvent(self, value, noEventSend);
	self.x8.mowers[self.x8.selectionIdx].setTransport = value;
	if( self.x8.selectionIdx == 3 ) then
		self.x8.mowers[1].setTransport = value;
		self.x8.mowers[2].setTransport = value;
	end;
	self.x8.mowers[3].setTransport = self.x8.mowers[1].setTransport and self.x8.mowers[2].setTransport;
end;
 
function PoettingerX8:setSelection(value, noEventSend)
	SetSelectionEvent.sendEvent(self, value, noEventSend);
	if value > table.getn(self.x8.mowers) then
		value = 1;
	end;
	self.x8.selectionIdx = value; 
end;

function PoettingerX8:setPSstates(values, noEventSend)
	SetPSstatesEvent.sendEvent(self, values, noEventSend);
	for i=1,2 do
		self.psState[i] = values[i];
	end;	
end;
 