atvbonus2Event = {};
atvbonus2Event_mt = Class(atvbonus2Event, Event);
InitEventClass(atvbonus2Event, "atvbonus2Event");
function atvbonus2Event:emptyNew()
    local self = Event:new(atvbonus2Event_mt);
    self.className="atvbonus2Event";
    return self;
end;

function atvbonus2Event:new(object, vehicle, toFast, price)
    local self = atvbonus2Event:emptyNew(); 
    self.object = object; 
	self.vehicle = vehicle;
	self.toFast = toFast;
	self.price = price;
    return self;
end;

function atvbonus2Event:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteInt8(streamId, self.toFast);
	streamWriteInt16(streamId, self.price);
end;

function atvbonus2Event:readStream(streamId, connection)
    self.object = networkGetObject(streamReadInt32(streamId));
    self.vehicle = networkGetObject(streamReadInt32(streamId));
    self.toFast = streamReadInt8(streamId);
    self.price = streamReadInt16(streamId);
    self:run(connection);
end;

function atvbonus2Event:run(connection)
	self.object:setWarning(self.vehicle, self.toFast, self.price);
end;

function atvbonus2Event.sendEvent(object, vehicle, toFast, price)
	if g_server ~= nil then   
		g_server:broadcastEvent(atvbonus2Event:new(object, vehicle, toFast, price), nil, nil, object); 
	else  
		g_client:getServerConnection():sendEvent(atvbonus2Event:new(object, vehicle, toFast, price)); 
	end;
end;