--@Author: Alex2009, Sven777b
--@Web: www.ls-landtechnik.de, www.alex2009.de

-- Basis fr Placeable by Alex2009 & Sven777b, Spezifikation "atvbonus" by rafftnix. (February 2013) Erlaubnis dafr von Sven777b erhalten.

Placeableatvbonus2 = {};
Placeableatvbonus2_mt = Class(Placeableatvbonus2, Placeable);
InitObjectClass(Placeableatvbonus2, "Placeableatvbonus2");

function Placeableatvbonus2:new(isServer, isClient, customMt)
    local self = Placeable:new(isServer, isClient, Placeableatvbonus2_mt);
    registerObjectClassName(self, "Placeableatvbonus2");
    return self;
end;

function Placeableatvbonus2:delete()
    removeTrigger(self.triggerNodeId);
    unregisterObjectClassName(self);
    Placeableatvbonus2:superClass().delete(self);
end;

function Placeableatvbonus2:deleteFinal()
    Placeableatvbonus2:superClass().deleteFinal(self);
end;

function Placeableatvbonus2:load(xmlFilename, x,y,z, rx,ry,rz, moveMode, initRandom)
    if not Placeableatvbonus2:superClass().load(self, xmlFilename, x,y,z, rx,ry,rz, moveMode, initRandom) then
        return false;
    end;
	if not moveMode then
		local xmlFile = loadXMLFile("TempXML", xmlFilename);
		self:loadatvbonus(id, xmlFile);
		delete(xmlFile);
	end;
    return true;
end;

function Placeableatvbonus2:loadatvbonus(id, xmlFile)
	self.triggerNodeId = Utils.indexToObject(self.nodeId, getXMLString(xmlFile, "placeable.atvbonus#triggerIndex"));
	
	local arrow = Utils.indexToObject(self.nodeId, getXMLString(xmlFile, "placeable.atvbonus#arrowIndex"));
	setVisibility(arrow, false);
	
	self.maxAllowedkmh = Utils.getNoNil(getUserAttribute(self.triggerNodeId, "maxAllowedkmh"), 30);
	self.pricePerKmh = Utils.getNoNil(getUserAttribute(self.triggerNodeId, "prizePerkmhToFast"), 2000);
	self.triggerId = self.triggerNodeId;
	addTrigger(self.triggerId, "triggerCallback", self);
	self.lastPrice = 0;
	self.myTimer = 0;
	self.myTimerBackup = 5000;
	self.toFast = 0;
	self.lastDist = 0;
	self.vehicles = {}
	self.posX, self.posY, self.posZ = getWorldTranslation(getParent(self.triggerId));
	self.lastatvbonusCaughtDriver = nil;
end;


function Placeableatvbonus2:triggerCallback(triggerId, otherId, onEnter, onLeave, onStay, otherShapeId)
	if onEnter and g_server ~= nil then
		local vehicle = g_currentMission.nodeToVehicle[otherShapeId];
		if vehicle ~= nil then
			if vehicle:getIsActive() and vehicle.motor ~= nil then
				table.insert(self.vehicles, vehicle);
			end;
		end;
	end;
end;

function Placeableatvbonus2:update(dt)
	if self.myTimer > 0 then
		if self.lastatvbonusCaughtDriver == nil then
			local text = string.gsub(g_i18n:getText("youWereToFast"), "toFast", tostring(self.toFast));
			text = string.gsub(text, "monetary", tostring(math.floor(self.lastPrice)));
			g_currentMission:addExtraPrintText(text);
		else
			local text = g_i18n:getText("someoneElseWasToFast");
			text = string.gsub(text, "user", tostring(self.lastatvbonusCaughtDriver));
			text = string.gsub(text, "toFast", tostring(self.toFast));
			text = string.gsub(text, "monetary", tostring(math.floor(self.lastPrice)));
			g_currentMission:addExtraPrintText(text);
		end;
		self.myTimer = self.myTimer - dt; 
	end;
end;

function Placeableatvbonus2:updateTick(dt)
	if g_server ~= nil then
		if self.vehicles[1] ~= nil then
			local x, y, z = getWorldTranslation(self.vehicles[1].rootNode);
			local dist = Utils.vector3Length(self.posX-x, self.posY-y, self.posZ-z);
			if self.lastDist == 0 then
				self.lastDist = dist;
			else
				if dist < self.lastDist then
					self:calculateMonetary(self.vehicles[1]);
				end;
				self.lastDist = 0;
				table.remove(self.vehicles, 1);
			end;
		end;
	end;
end;

function Placeableatvbonus2:calculateMonetary(vehicle)
	local kmh = math.min(100, math.max(0, vehicle.lastSpeed*vehicle.speedDisplayScale*3600));
	if kmh > self.maxAllowedkmh then
		local toFast = kmh - self.maxAllowedkmh;
		toFast = math.floor(toFast);
		local price = toFast * self.pricePerKmh;
		g_currentMission:addSharedMoney(price);
		self:setWarning(vehicle, toFast, price);
	end;
end;

function Placeableatvbonus2:setWarning(vehicle, toFast, price)
	self.lastPrice = price;
	self.toFast = toFast
	self.myTimer = self.myTimerBackup;
	if vehicle:getIsActiveForInput(false) then
		self.lastatvbonusCaughtDriver = nil;
	else
		self.lastatvbonus2CaughtDriver = vehicle.controllerName;
	end;
	if g_server ~= nil then
		atvbonus2Event.sendEvent(self, vehicle, toFast, price);
	end;
end;

registerPlaceableType("Placeableatvbonus2", Placeableatvbonus2);