atvbonusEvent = {};
atvbonusEvent_mt = Class(atvbonusEvent, Event);
InitEventClass(atvbonusEvent, "atvbonusEvent");
function atvbonusEvent:emptyNew()
    local self = Event:new(atvbonusEvent_mt);
    self.className="atvbonusEvent";
    return self;
end;

function atvbonusEvent:new(object, vehicle, toFast, price)
    local self = atvbonusEvent:emptyNew(); 
    self.object = object; 
	self.vehicle = vehicle;
	self.toFast = toFast;
	self.price = price;
    return self;
end;

function atvbonusEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteInt8(streamId, self.toFast);
	streamWriteInt16(streamId, self.price);
end;

function atvbonusEvent:readStream(streamId, connection)
    self.object = networkGetObject(streamReadInt32(streamId));
    self.vehicle = networkGetObject(streamReadInt32(streamId));
    self.toFast = streamReadInt8(streamId);
    self.price = streamReadInt16(streamId);
    self:run(connection);
end;

function atvbonusEvent:run(connection)
	self.object:setWarning(self.vehicle, self.toFast, self.price);
end;

function atvbonusEvent.sendEvent(object, vehicle, toFast, price)
	if g_server ~= nil then   
		g_server:broadcastEvent(atvbonusEvent:new(object, vehicle, toFast, price), nil, nil, object); 
	else  
		g_client:getServerConnection():sendEvent(atvbonusEvent:new(object, vehicle, toFast, price)); 
	end;
end;