
-- by "Marhu" 
-- v 1.0
-- Date: 01.02.2013
-- Zum Transport von Ballen fr "Ballen Frderband"

local BaleNameToDatei = {}
BaleNameToDatei["strawbaleBaler"] 	= "data/maps/models/objects/strawbale/strawbaleBaler.i3d"
BaleNameToDatei["haybaleBaler"] 	= "data/maps/models/objects/strawbale/haybaleBaler.i3d"
BaleNameToDatei["roundbaleHay"]		= "data/maps/models/objects/roundbales/roundbaleHay.i3d"
BaleNameToDatei["roundbaleStraw"] 	= "data/maps/models/objects/roundbales/roundbaleStraw.i3d"
local BaleDateiToName = {}
BaleDateiToName["data/maps/models/objects/strawbale/strawbaleBaler.i3d"]	= "strawbaleBaler"
BaleDateiToName["data/maps/models/objects/strawbale/haybaleBaler.i3d"]		= "haybaleBaler"
BaleDateiToName["data/maps/models/objects/roundbales/roundbaleHay.i3d"]		= "roundbaleHay"
BaleDateiToName["data/maps/models/objects/roundbales/roundbaleStraw.i3d"]	= "roundbaleStraw"
					
BallenTransport = {};

function BallenTransport.prerequisitesPresent(specializations)
    return true
end;

function BallenTransport:load(xmlFile)
	
	self.Belt = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Belt#index"));
	
	local SoundRefNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.workSound#node"));
	local workSound  = getXMLString(xmlFile, "vehicle.workSound#file");
	if workSound  ~= nil and workSound  ~= "" then
		workSound  = Utils.getFilename(workSound, self.baseDirectory);
		self.workSoundRadius = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.workSound#radius"), 50);
		self.workSoundInnerRadius = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.workSound#innerRadius"), 10);
		self.workSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.workSound#volume"), .8);
		self.workSound = createAudioSource("workSound", workSound, self.workSoundRadius, self.workSoundInnerRadius, self.workSoundVolume, 0);
		link(SoundRefNode, self.workSound);
		setVisibility(self.workSound, false);
	end;
	
	local BandATs = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.BandATs#index"))
	self.BaleAT = {}
	for i = 1,6 do
		self.BaleAT[i] = {}
		self.BaleAT[i].node = getChildAt(BandATs,i-1);
		self.BaleAT[i].nodeR = getChildAt(self.BaleAT[i].node,0);
	end
	self.transTime = 10 * 1000
	
	local Stuetze0 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Stuetze#index"));
	if Stuetze0 then
		self.Stuetze = {};
		self.Stuetze.node =  Stuetze0;
		self.Stuetze.maxRot = {math.rad(-77),math.rad(0),math.rad(0)};
		self.Stuetze.minRot = {math.rad(0),math.rad(0),math.rad(0)};
	end

	local farmer0 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.characterNode#index"));
	if farmer0 then
		self.Farmer = {}
		self.Farmer.node0 = farmer0
		self.Farmer.node1 = getChildAt(farmer0,0);
		self.Farmer.node2 = getChildAt(farmer0,1);
		self.Farmer.ani = {}
		self.Farmer.ani.updown = {[2]={}}
		self.Farmer.ani.updown[2].maxRot = {math.rad(0),math.rad(32),math.rad(0)};
		self.Farmer.ani.updown[2].minRot = {math.rad(0),math.rad(130),math.rad(0)};
		self.Farmer.ani.updown[2].t = .5
		self.Farmer.ani.move = {[1]={},[2]={}}
		self.Farmer.ani.move[1].maxRot = {math.rad(0),math.rad(-15),math.rad(0)};
		self.Farmer.ani.move[1].minRot = {math.rad(0),math.rad(15),math.rad(0)};
		self.Farmer.ani.move[1].loop = true
		self.Farmer.ani.move[1].dir = true
		self.Farmer.ani.move[1].t = .5
		self.Farmer.ani.move[2].maxRot = {math.rad(0),math.rad(-15),math.rad(0)};
		self.Farmer.ani.move[2].minRot = {math.rad(0),math.rad(15),math.rad(0)};
		self.Farmer.ani.move[2].loop = true
		self.Farmer.ani.move[2].dir = false
		self.Farmer.ani.move[2].t = .49
		self.Farmer.ani.Grab = {[1]={},[2]={}}
		self.Farmer.ani.Grab[1].maxRot = {math.rad(0),math.rad(15),math.rad(0)};
		self.Farmer.ani.Grab[1].minRot = {math.rad(0),math.rad(-90),math.rad(0)};
		self.Farmer.ani.Grab[1].t = .5
		self.Farmer.ani.Grab[2].maxRot = {math.rad(0),math.rad(-15),math.rad(0)};
		self.Farmer.ani.Grab[2].minRot = {math.rad(0),math.rad(90),math.rad(0)};
		self.Farmer.ani.Grab[2].t = .5
	end
		
	self.searchBale = BallenTransport.searchBale;
	self.isBaleInRange = BallenTransport.isBaleInRange;
	self.UnloadBale = BallenTransport.UnloadBale;
	self.UpDown = BallenTransport.UpDown;
	self.FarmerAni = BallenTransport.FarmerAni;
	self.FarmerAniReset = BallenTransport.FarmerAniReset;
	
	self.GrabBale = g_currentMission.time - 1
	
end;

function BallenTransport:delete()
	for i = 1,table.getn(self.BaleAT) do
		if self.BaleAT[i].bale then
			if self.BaleAT[i].bale.OnBand then
				self:UnloadBale(self.BaleAT[i].bale)
			end
			self.BaleAT[i].bale = nil
		end
	end
end;

function BallenTransport:mouseEvent(posX, posY, isDown, isUp, button)
end;

function BallenTransport:keyEvent(unicode, sym, modifier, isDown)
end;

function BallenTransport:update(dt)
	
	if self.LoadBales then
		local i = 1
		for BallenTyp, num in pairs(self.LoadBales) do
			for j = 1,num do
				if BaleNameToDatei[BallenTyp] then
					local baleObject = Bale:new(self.isServer, self.isClient);
					local x,y,z = getWorldTranslation(self.BaleAT[i].node);
					local rx,ry,rz = getWorldRotation(self.BaleAT[i].node);
					baleObject:load(BaleNameToDatei[BallenTyp], x,y,z,rx,ry,rz);
					baleObject:register();
					self.BaleAT[i].bale = baleObject
					setRigidBodyType(self.BaleAT[i].bale.nodeId,"NoRigidBody");
					setTranslation(self.BaleAT[i].bale.nodeId, 0,0,0);
					setRotation(self.BaleAT[i].bale.nodeId, 0,0,0);
					if getUserAttribute(self.BaleAT[i].bale.nodeId, "isRoundbale") then
						link(self.BaleAT[i].nodeR,self.BaleAT[i].bale.nodeId);
					else
						link(self.BaleAT[i].node,self.BaleAT[i].bale.nodeId);
					end
					self.BaleAT[i].bale.OnBand = true
					setTranslation(self.BaleAT[i].node, 0,0,3 * (i-1));
					i = i + 1
				end
			 end;
		end;
		self.LoadBales = nil
	end
	
	if self.Stuetze.rotx then
		local rot = {getRotation(self.Stuetze.node)}
		if rot[1] < self.Stuetze.rotx then
			self:UpDown(true,dt*4)
		else
			self.Stuetze.rotx = nil
		end
	end
	
	
	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.BALLENBAND_ONOFF) then
			self.IsOn = not self.IsOn
			if self.IsOn then
				setShaderParameter(self.Belt, "scollSpeed", 0,-0.7,0,0,false);
				playSample(self.workSound, 0, 1, 0);
				setVisibility(self.workSound, true);
			else
				setShaderParameter(self.Belt, "scollSpeed", 0,0,0,0,false);
				setVisibility(self.workSound, false);
			end
		end
	end
	if InputBinding.isPressed(InputBinding.BALLENBAND_RAUF) and self:getIsActiveForInput() then
		self:UpDown(true,dt)
		self:FarmerAni("updown",true,dt)
	elseif InputBinding.isPressed(InputBinding.BALLENBAND_RUNTER) and self:getIsActiveForInput() then
		self:UpDown(false,dt)
		self:FarmerAni("updown",true,dt)
	elseif self.lastSpeed * 3600 >= 1 then
		if self.lastAni == nil or self.lastAni ~= "move" then
			self:FarmerAniReset(dt,0)
			if not self.Farmer.Reset then
				self:FarmerAni("move",true,dt)
			end
		else
			self:FarmerAni("move",true,dt)
		end
	elseif self.GrabBale >= g_currentMission.time then
		self:FarmerAni("Grab",true,dt)
	elseif self.lastAni then
		self:FarmerAniReset(dt)
	end
	
end;

function BallenTransport:updateTick(dt)
	
	if self.IsOn then
		local freePlace = true
		for i = 1,table.getn(self.BaleAT) do
			if self.BaleAT[i].bale then
				local trans = {getTranslation(self.BaleAT[i].node)}
				local newtrans = Utils.getMovedLimitedValues(trans, {0,0,16.1}, {0,0,0}, 3, self.transTime, dt, false);
				setTranslation(self.BaleAT[i].node, unpack(newtrans));
				
				if newtrans[3] >= 16 then
					if self.BaleAT[i].bale and self.BaleAT[i].bale.nodeId ~= 0 then
						if getRigidBodyType(self.BaleAT[i].bale.nodeId) ~= "Dynamic" then
							setRigidBodyType(self.BaleAT[i].bale.nodeId,"Dynamic");
						end
					end
					self.BaleAT[i].bale = nil
					setTranslation(self.BaleAT[i].node, {0,0,0});
				elseif self.BaleAT[i].bale.OnBand and newtrans[3] >= 14.5 then
					self:UnloadBale(self.BaleAT[i].bale)
				elseif newtrans[3] < 3 then
					freePlace = false
				end
			end
		end
		
		if freePlace then
			for i = 1,table.getn(self.BaleAT) do
				if not self.BaleAT[i].bale then
					self:searchBale(self.BaleAT[i])
					break
				end
			end
		end
		
		if not self.attacherVehicle and not getVisibility(self.Farmer.node0) then
			setVisibility(self.Farmer.node0,true)
		end
	end

end

function BallenTransport:draw()
	if self:getIsActiveForInput() then
		g_currentMission:addHelpButtonText(g_i18n:getText("BallenBandRauf"), InputBinding.BALLENBAND_RAUF);
		g_currentMission:addHelpButtonText(g_i18n:getText("BallenBandRunter"), InputBinding.BALLENBAND_RUNTER);
		if self.IsOn then
			g_currentMission:addHelpButtonText(g_i18n:getText("BallenBandAus"), InputBinding.BALLENBAND_ONOFF);
		else
			g_currentMission:addHelpButtonText(g_i18n:getText("BallenBandAn"), InputBinding.BALLENBAND_ONOFF);
		end
	end
end;

function BallenTransport:onAttach()
	if self.IsOn and getVisibility(self.Farmer.node0) then
		setVisibility(self.Farmer.node0,false)
	end
end; 

function BallenTransport:onDetach()
	AIVehicleUtil.driveInDirection(self, 0, 30, 0.1, 0.1, 30, false, true, 0, 1);
end;

function BallenTransport:getSaveAttributesAndNodes(nodeIdent)

				
	local NumBallen = {}
	for i = 1,table.getn(self.BaleAT) do
		if self.BaleAT[i].bale then
			if self.BaleAT[i].bale.OnBand then
				NumBallen[self.BaleAT[i].bale.i3dFilename] = (NumBallen[self.BaleAT[i].bale.i3dFilename] or 0) + 1
			end
		end
	end
	local attributes = ""
	local i = 1
	for i3dFilename, num in pairs(NumBallen) do
		if BaleDateiToName[i3dFilename] then
			attributes = attributes ..' '..BaleDateiToName[i3dFilename]..'="'.. tostring(num)  .. '"'
		end	
	end
	local rot = {getRotation(self.Stuetze.node)}
	attributes = attributes ..' Stuetze="'.. tostring(rot[1])  .. '"'
	
	return attributes, nil;
end

function BallenTransport:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	if not resetVehicles and g_server ~= nil then
		self.LoadBales = {}
		self.LoadBales["haybaleBaler"] = Utils.getNoNil(getXMLInt(xmlFile, key .. string.format("#haybaleBaler")), 0);
		self.LoadBales["strawbaleBaler"] = Utils.getNoNil(getXMLInt(xmlFile, key .. string.format("#strawbaleBaler")), 0);
		self.LoadBales["roundbaleHay"] = Utils.getNoNil(getXMLInt(xmlFile, key .. string.format("#roundbaleHay")), 0);
		self.LoadBales["roundbaleStraw"] = Utils.getNoNil(getXMLInt(xmlFile, key .. string.format("#roundbaleStraw")), 0);
		if self.Stuetze then
			self.Stuetze.rotx = Utils.getNoNil(getXMLFloat(xmlFile, key .. string.format("#Stuetze")), math.rad(-77));
		end
	end
	return BaseMission.VEHICLE_LOAD_OK;
end

function BallenTransport:isBaleInRange(place,object)
	local nearestDistance = 5;
	local x, y, z = getWorldTranslation(place);
	local bx, by, bz = getWorldTranslation(object);
	local distance = Utils.vector3Length(x-bx, y-by, z-bz);
	if distance < nearestDistance then
		return true
	else
		return false
	end
end;

function BallenTransport:searchBale(at)
	
	for index,item in pairs(g_currentMission.itemsToSave) do
		if item.item:isa(Bale) and not item.item.OnBand then 
			local isInRange = self:isBaleInRange(at.node,item.item.nodeId);			
			if isInRange then
				at.bale = item.item
				setRigidBodyType(at.bale.nodeId,"NoRigidBody");
				setTranslation(at.bale.nodeId, 0,0,0);
				setRotation(at.bale.nodeId, 0,0,0);
				if getUserAttribute(at.bale.nodeId, "isRoundbale") then
					link(at.nodeR,at.bale.nodeId);
				else
					link(at.node,at.bale.nodeId);
				end
				at.bale.OnBand = true
				self.GrabBale = g_currentMission.time + 1000
				break
			end
		end;
	end;
	
end;

function BallenTransport:UnloadBale(ballen)
	
	local x,y,z = getWorldTranslation(ballen.nodeId);
	local rx,ry,rz = getWorldRotation(ballen.nodeId);
	local root = getRootNode();
	link(root,ballen.nodeId);
	setRigidBodyType(ballen.nodeId,"Dynamic");
	setTranslation(ballen.nodeId,x,y,z);
	setRotation(ballen.nodeId,rx,ry,rz);
	ballen.OnBand = nil
	
end

function BallenTransport:UpDown(dir,dt)
	
	if self.Stuetze then
		local rotTime = 10 * 1000
		local rot = {getRotation(self.Stuetze.node)}
		local newRot = Utils.getMovedLimitedValues(rot, self.Stuetze.maxRot, self.Stuetze.minRot, 3, rotTime, dt, dir);
		setRotation(self.Stuetze.node, unpack(newRot));
		for i=1, table.getn(self.movingTools) do
			local tool = self.movingTools[i]
			Cylindered.setDirty(self, tool);
			self:raiseDirtyFlags(self.cylinderedDirtyFlag);
		end
	end
	
end

function BallenTransport:FarmerAni(ani,dir,dt)
	if self.Farmer then
		if self.Farmer.ani[ani] then
			self.lastAni = ani
			if self.Farmer.ani[ani][1] then
				local rotTime = self.Farmer.ani[ani][1].t * 1000
				local rot = {getRotation(self.Farmer.node1)}
				if self.Farmer.ani[ani][1].loop then
					self.Farmer.ani[ani][1].t2 = (self.Farmer.ani[ani][1].t2 or 0) + dt
					if self.Farmer.ani[ani][1].t2 >= rotTime then
						self.Farmer.ani[ani][1].t2 = 0
						self.Farmer.ani[ani][1].dir = not self.Farmer.ani[ani][1].dir
					end
					dir = self.Farmer.ani[ani][1].dir
				end
				local newRot = Utils.getMovedLimitedValues(rot, self.Farmer.ani[ani][1].maxRot, self.Farmer.ani[ani][1].minRot, 3, rotTime, dt, dir);
				setRotation(self.Farmer.node1, unpack(newRot));
			end
			if self.Farmer.ani[ani][2] then
				local rotTime = self.Farmer.ani[ani][2].t * 1000
				local rot = {getRotation(self.Farmer.node2)}
				if self.Farmer.ani[ani][2].loop then
					self.Farmer.ani[ani][2].t2 = (self.Farmer.ani[ani][2].t2 or 0) + dt
					if self.Farmer.ani[ani][2].t2 >= rotTime then
						self.Farmer.ani[ani][2].t2 = 0
						self.Farmer.ani[ani][2].dir = not self.Farmer.ani[ani][2].dir
					end
					dir = self.Farmer.ani[ani][2].dir
				end
				local newRot = Utils.getMovedLimitedValues(rot, self.Farmer.ani[ani][2].maxRot, self.Farmer.ani[ani][2].minRot, 3, rotTime, dt, dir);
				setRotation(self.Farmer.node2, unpack(newRot));
			end
		end
	end
end

function BallenTransport:FarmerAniReset(dt,winkel)
	if self.Farmer then
		local rotTime = 0.5 * 1000
		local rot1 = {getRotation(self.Farmer.node1)}
		local rot2 = {getRotation(self.Farmer.node2)}
		
		if not self.Farmer.Reset then
			self.Farmer.Reset = {} 
			self.Farmer.Reset[1] = {}
			self.Farmer.Reset[1].rot = rot1
			self.Farmer.Reset[2] = {}
			self.Farmer.Reset[2].rot = rot2
			self.Farmer.Reset.t = 0
		end;
		if not winkel then winkel = 32 end;
		local newRot = Utils.getMovedLimitedValues(rot1, {0,math.rad(-winkel),0}, self.Farmer.Reset[1].rot, 3, rotTime, dt, false);
		setRotation(self.Farmer.node1, unpack(newRot));
		local newRot = Utils.getMovedLimitedValues(rot2, {0,math.rad(winkel),0}, self.Farmer.Reset[2].rot, 3, rotTime, dt, false);
		setRotation(self.Farmer.node2, unpack(newRot));
		
		if self.Farmer.Reset.t >= rotTime then
			self.lastAni = nil
			self.Farmer.Reset = nil
		else
			self.Farmer.Reset.t = self.Farmer.Reset.t + dt
		end
	end
end
