-- Planticenter PCA 15
-- Script Para Farming Simulator
-- Henrique Bianchini
-- @Data  30/04/2014

PCA15 = {};

source("dataS/scripts/vehicles/specializations/SetTurnedOnEvent.lua");

function PCA15.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Attachable, specializations);
end;

function PCA15:load(xmlFile)
	self.updateSafeArea = SpecializationUtil.callSpecializationsFunction("updateSafeArea");
	
	local airSeederPneumaticsound = getXMLString(xmlFile, "vehicle.airSeederPneumaticsound#file");
    if airSeederPneumaticsound ~= nil and airSeederPneumaticsound ~= "" then
		airSeederPneumaticsound = Utils.getFilename(airSeederPneumaticsound, self.baseDirectory);
        self.airSeederPneumaticsound = createSample("airSeederPneumaticsound");
        loadSample(self.airSeederPneumaticsound, airSeederPneumaticsound, false);
		self.airSeederPneumaticsoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.airSeederPneumaticsound#pitchOffset"), 1);
    end;
	

	local solitairRubbersound = getXMLString(xmlFile, "vehicle.solitairRubbersound#file");
    if solitairRubbersound ~= nil and solitairRubbersound ~= "" then
		solitairRubbersound = Utils.getFilename(solitairRubbersound, self.baseDirectory);
        self.solitairRubbersound = createSample("solitairRubbersound");
        loadSample(self.solitairRubbersound, solitairRubbersound, false);
		self.solitairRubbersoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.solitairRubbersound#pitchOffset"), 1);
    end;

self.aiTerrainDetailChannel1 = g_currentMission.cultivatorChannel;
    self.aiTerrainDetailChannel2 = g_currentMission.ploughChannel;

        self.RotatingParts = {};
        local i=0;
    while true do
        local baseName = string.format("vehicle.RotatingParts.RotatingPart(%d)", i);
        local index = getXMLString(xmlFile, baseName.. "#index");
        if index == nil then
            break;
        end;
        local node = Utils.indexToObject(self.components, index);
        if node ~= nil then
			local entry = {};
			entry.node = node;
			entry.rotationSpeedScale = getXMLFloat(xmlFile, baseName.."#rotationSpeedScale");
			if entry.rotationSpeedScale == nil then
				entry.rotationSpeedScale = 1.0/Utils.getNoNil(getXMLFloat(xmlFile, baseName.."#radius"), 1);
			end;
			entry.foldMinLimit = Utils.getNoNil(getXMLFloat(xmlFile, baseName .. "#foldMinLimit"), 0);
			entry.foldMaxLimit = Utils.getNoNil(getXMLFloat(xmlFile, baseName .. "#foldMaxLimit"), 1);
			table.insert(self.RotatingParts, entry);
        end;
    i = i+1;
    end;
	
        self.LeftMarkerDiscs = {};
        local i=0;
    while true do
        local baseName = string.format("vehicle.LeftMarkerDiscs.LeftMarkerDisc(%d)", i);
        local index = getXMLString(xmlFile, baseName.. "#index");
        if index == nil then
            break;
        end;
        local node = Utils.indexToObject(self.components, index);
        if node ~= nil then
			local entry = {};
			entry.node = node;
			entry.rotationSpeedScale = getXMLFloat(xmlFile, baseName.."#rotationSpeedScale");
			if entry.rotationSpeedScale == nil then
				entry.rotationSpeedScale = 1.0/Utils.getNoNil(getXMLFloat(xmlFile, baseName.."#radius"), 1);
			end;
			entry.foldMinLimit = Utils.getNoNil(getXMLFloat(xmlFile, baseName .. "#foldMinLimit"), 0);
			entry.foldMaxLimit = Utils.getNoNil(getXMLFloat(xmlFile, baseName .. "#foldMaxLimit"), 1);
			table.insert(self.LeftMarkerDiscs, entry);
        end;
    i = i+1;
    end;
	
        self.RightMarkerDiscs = {};
        local i=0;
    while true do
        local baseName = string.format("vehicle.RightMarkerDiscs.RightMarkerDisc(%d)", i);
        local index = getXMLString(xmlFile, baseName.. "#index");
        if index == nil then
            break;
        end;
        local node = Utils.indexToObject(self.components, index);
        if node ~= nil then
			local entry = {};
			entry.node = node;
			entry.rotationSpeedScale = getXMLFloat(xmlFile, baseName.."#rotationSpeedScale");
			if entry.rotationSpeedScale == nil then
				entry.rotationSpeedScale = 1.0/Utils.getNoNil(getXMLFloat(xmlFile, baseName.."#radius"), 1);
			end;
			entry.foldMinLimit = Utils.getNoNil(getXMLFloat(xmlFile, baseName .. "#foldMinLimit"), 0);
			entry.foldMaxLimit = Utils.getNoNil(getXMLFloat(xmlFile, baseName .. "#foldMaxLimit"), 1);
			table.insert(self.RightMarkerDiscs, entry);
        end;
    i = i+1;
    end;
	

    self.plDireto = true;
    self.rocaSegura = false;
	self.isActive = false;
	self.downPosition = false;
	self.sowingBit = 0;
end;

function PCA15:delete()
end;

function PCA15:mouseEvent(posX, posY, isDown, isUp, button)
end;

function PCA15:keyEvent(unicode, sym, modifier, isDown)	
end;

function PCA15:update(dt)
		self.time = self.time + dt;
		if self.attacherVehicle then	
			if self.isTurnedOn then
				if self.baixar then
						if self.attacherVehicle.isEntered then
							playSample(self.airSeederPneumaticsound, 1, 1, 0);
						end;
						self.baixar = false;
				end;
			else
				if not self.baixar then
					if self.attacherVehicle.isEntered then
						playSample(self.airSeederPneumaticsound, 1, 1, 0);
					end;
					self.baixar = true;
				end;
			end;
		end;
		
	
--baixa a plantadeira
end;

function PCA15:updateTick(dt)
      if self:getIsActive() then
           if self.isClient then
               if self.isTurnedOn then
                   for k,v in pairs(self.RotatingParts) do
                       if foldAnimTime == nil or (foldAnimTime <= v.foldMaxLimit and foldAnimTime >= v.foldMinLimit) then
                           rotate( v.node, v.rotationSpeedScale * self.lastSpeedReal * self.movingDirection * dt, 0, 0);
                       end
                   end
               end
				if self.ridgeMarkerState == 1 and self.isTurnedOn then
                   for k,v in pairs(self.LeftMarkerDiscs) do
                       if foldAnimTime == nil or (foldAnimTime <= v.foldMaxLimit and foldAnimTime >= v.foldMinLimit) then
                           rotate( v.node, v.rotationSpeedScale * self.lastSpeedReal * self.movingDirection * dt, 0, 0);
						end
					end
				end
				if self.ridgeMarkerState == 2 and self.isTurnedOn then
                   for k,v in pairs(self.RightMarkerDiscs) do
                       if foldAnimTime == nil or (foldAnimTime <= v.foldMaxLimit and foldAnimTime >= v.foldMinLimit) then
                           rotate( v.node, - v.rotationSpeedScale * self.lastSpeedReal * self.movingDirection * dt, 0, 0);
                       end
                   end
				end
			end;
        end
   end;

 
function PCA15:draw()
end;