--
-- AnimatedHydraulic
--
-- @author  Manuel Leithner
-- @date  12/04/10
--

AnimatedHydraulic = {};

function AnimatedHydraulic.prerequisitesPresent(specializations)
    return true;
end;

function AnimatedHydraulic:load(xmlFile)
	self.setTransRot = SpecializationUtil.callSpecializationsFunction("setTransRot");
	  self.TransRotAnimation = getXMLString(xmlFile, "vehicle.TransRot#animationName");
	  self.TransRot = false;	
end;

function AnimatedHydraulic:delete()
end;

function AnimatedHydraulic:readStream(streamId, connection)
      self:setTransRot(streamReadBool(streamId), true);
end;
  
function AnimatedHydraulic:writeStream(streamId, connection)
      streamWriteBool(streamId, self.TransRot);
end;

function AnimatedHydraulic:mouseEvent(posX, posY, isDown, isUp, button)
end;

function AnimatedHydraulic:keyEvent(unicode, sym, modifier, isDown)
end;

function AnimatedHydraulic:update(dt)
	if self.isTurnedOn then
        self:setTransRot(not self.isTransRotOn);
	else
	    self:setTransRot(self.isTransRotOn);
    end;
end;

function AnimatedHydraulic:updateTick(dt)
    if self:getIsActive() then
	for i, jointDesc in pairs(self.componentJoints) do
		setJointFrame(self.componentJoints[i].jointIndex, 0, self.componentJoints[i].jointNode);
	end;
	end;
end;

function AnimatedHydraulic:draw()	
end;

function AnimatedHydraulic:setTransRot(isTransRot,noEventSend)
	SetTransRotEvent.sendEvent(self, isTransRot, noEventSend);
	-- Play TransRot animation --
	self.isTurnedOn = isTransRot;
	if self.isTurnedOn then
		if self.TransRotAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.TransRotAnimation, 1, nil, true);
			self.TransRot = true;
		end;
	else
		if self.TransRotAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.TransRotAnimation, -1, nil, true);
			self.TransRot = false;
		end;
	end;	
end;