--
-- 
--
-- @author:    	Xentro (www.fs-uk.com)(Marcus@Xentro.se)
-- @version:    v0.9
-- @date:       2013-05-19
-- 
--
placeableMachineShed = {};
placeableMachineShed.currentModDirectory = g_currentModDirectory;

placeableMachineShed_mt = Class(placeableMachineShed, Placeable);
InitObjectClass(placeableMachineShed, "placeableMachineShed");

function placeableMachineShed:new(isServer, isClient, customMt)
    local self = Placeable:new(isServer, isClient, placeableMachineShed_mt);
    registerObjectClassName(self, "placeableMachineShed");
	
	self.numObjectClasses = 0;
	self.objectClasses = {};
	
    return self;
end;

function placeableMachineShed:delete()
    placeableMachineShed:superClass().delete(self);
	
    unregisterObjectClassName(self);
	
	for _, class in pairs(self.objectClasses) do
		class:delete();
	end;
end;

function placeableMachineShed:deleteFinal()
    placeableMachineShed:superClass().deleteFinal(self);
end;

function placeableMachineShed:readStream(streamId, connection)
    placeableMachineShed:superClass().readStream(self, streamId, connection);
	
	for _, class in pairs(self.objectClasses) do
		class:readStream(streamId, connection);
	end;
end;

function placeableMachineShed:writeStream(streamId, connection)
    placeableMachineShed:superClass().writeStream(self, streamId, connection);
	
	for _, class in pairs(self.objectClasses) do
		class:writeStream(streamId, connection);
	end;
end;

function placeableMachineShed:load(xmlFilename, x,y,z, rx,ry,rz, moveMode, initRandom)
	if not placeableMachineShed:superClass().load(self, xmlFilename, x, y, z, rx, ry, rz, moveMode, initRandom) then
		return false;
	end;
	
    local xmlFile = loadXMLFile("TempXML", xmlFilename);
	
	local i = 0;
	while true do
		local key = string.format("placeable.types.animation(%d)", i);
		if not hasXMLProperty(xmlFile, key) then break; end;
		
		local triggerIndex = Utils.indexToObject(self.nodeId, getXMLString(xmlFile, key .. "#triggerIndex"));
		if triggerIndex ~= nil then
			local node = Utils.indexToObject(self.nodeId, getXMLString(xmlFile, key .. "#index"));
			
			if node ~= nil then
				local animCharSet = getAnimCharacterSet(node);
				
				if animCharSet ~= nil then
					local name = Utils.getNoNil(getXMLString(xmlFile, key .. "#name"), "");
					local clip = getAnimClipIndex(animCharSet, getXMLString(xmlFile, key .. "#clip"));
					
					if clip ~= nil then
						assignAnimTrackClip(animCharSet, 0, clip);
						
						if getAnimTrackAssignedClip(animCharSet, 0) then
							local loop = Utils.getNoNil(getXMLBool(xmlFile, key .. "#loop"), false);
							local fa = Utils.getNoNil(getXMLBool(xmlFile, key .. "#loopFinish"), false);
							local speedScale = Utils.getNoNil(getXMLFloat(xmlFile, key .. "#speedScale"), 15);
							local duration = getAnimClipDuration(animCharSet, clip);
							local cas;
							setAnimTrackLoopState(animCharSet, 0, loop);
							
							if g_client then
								local animSound = getXMLString(xmlFile, key .. ".sound#file");
								if animSound ~= nil and animSound ~= "" then
									animSound = Utils.getFilename(animSound, placeableMachineShed.currentModDirectory);
									local soundVolume = Utils.getNoNil(getXMLFloat(xmlFile, key .. ".sound#volume"), 3);
									local soundRadius = Utils.getNoNil(getXMLFloat(xmlFile, key .. ".sound#outerRadius"), 50000);
									local soundInnerRadius = Utils.getNoNil(getXMLFloat(xmlFile, key .. ".sound#innerRadius"), 100000);
									cas = createAudioSource("clientAnimationSound" .. i, animSound, soundRadius, soundInnerRadius, soundVolume, 0);
									
									link(node, cas);
									setVisibility(cas, false);
								end;
							end;
							
							self.numObjectClasses = self.numObjectClasses + 1;
							self.objectClasses[self.numObjectClasses] = AdditionalMapFeaturesClass:new(name, triggerIndex, node, animCharSet, clip, loop, fa, speedScale, duration, cas);
						end;
					end;
					
					i = i + 1;
				end;
			else	
				break;
			end;
		else
			break;
		end;
	end;
	
	local i = 0;
	while true do
		local key = string.format("placeable.types.light(%d)", i);
		if not hasXMLProperty(xmlFile, key) then break; end;
		
		local triggerIndex = Utils.indexToObject(self.nodeId, getXMLString(xmlFile, key .. "#triggerIndex"));
		if triggerIndex ~= nil then
			local node = Utils.indexToObject(self.nodeId, getXMLString(xmlFile, key .. "#index"));
			if node ~= nil then
				local name = Utils.getNoNil(getXMLString(xmlFile, key .. "#name"), "");
				setVisibility(node, false);
				
				self.numObjectClasses = self.numObjectClasses + 1;
				self.objectClasses[self.numObjectClasses] = AdditionalMapFeaturesClass:new(name, triggerIndex, node);
				
				i = i + 1;
			else
				break;
			end;
		else
			break;
		end;
	end;
	
    delete(xmlFile);
    return true;
end;

function placeableMachineShed:loadFromAttributesAndNodes(xmlFile, tag, resetVehicles)
	if not placeableMachineShed:superClass().loadFromAttributesAndNodes(self, xmlFile, tag, resetVehicles) then
		return false;
	end;
	
	for i, class in pairs(self.objectClasses) do
		local key = tag .. string.format(".AdditionalMapFeaturesClass(%d)", i - 1);
		local state = getXMLBool(xmlFile, key .. "#activated");
		local animTime = getXMLFloat(xmlFile, key .. "#animTime");
		
		class:loadFromAttributes(state, animTime, resetVehicles);
	end;
	
	return true;
end;

function placeableMachineShed:getSaveAttributesAndNodes(nodeIdent)
	local attributes, nodes = placeableMachineShed:superClass().getSaveAttributesAndNodes(self, nodeIdent);
	
	for i, class in pairs(self.objectClasses) do
		if i > 1 then
			nodes = nodes .. "\n";
		end;
		nodes = nodes .. nodeIdent .. '<AdditionalMapFeaturesClass ' .. class:getSaveAttributes() .. ' />';
	end;
	
	return attributes, nodes;
end;

function placeableMachineShed:update(dt)
	for _, class in pairs(self.objectClasses) do
		if class.update ~= nil then
			class:update(dt);
		end;
	end;
end;

registerPlaceableType("placeableMachineShed", placeableMachineShed);


