-- by mor2000

--------------------
-- HeapDisplayTrigger (shows sth in the top left hud)

UPK_HeapDisplayTrigger={}
local UPK_HeapDisplayTrigger_mt = ClassUPK(UPK_HeapDisplayTrigger,UPK_DisplayTrigger)
InitObjectClass(UPK_HeapDisplayTrigger, "UPK_HeapDisplayTrigger")
UniversalProcessKit.addModule("heapdisplaytrigger",UPK_HeapDisplayTrigger)

function UPK_HeapDisplayTrigger:new(isServer, isClient, customMt)
	local self = UPK_HeapDisplayTrigger.superClass():new(isServer, isClient, customMt or UPK_HeapDisplayTrigger_mt)
	registerObjectClassName(self, "UPK_HeapDisplayTrigger")
	
	self.sellHeapDirtyFlag = self:getNextDirtyFlag()
	self.nameHeapDirtyFlag = self:getNextDirtyFlag()

	return self
end

function UPK_HeapDisplayTrigger:load(id, parent)
	if not UPK_HeapDisplayTrigger:superClass().load(self, id, parent) then
		self:print('Error: loading HeapDisplayTrigger failed',true)
		return false
	end
	
	self.timediff=0
	
	self.paneId = getChildAt(self.nodeId, 0)
	self.hasPane=false
	if self.paneId~=nil and self.paneId~=0 then
		self.hasPane=true
	end
	self.showPane=false

	self:print('loaded HeapDisplayTrigger successfully')
	return true
end

function UPK_HeapDisplayTrigger:delete()
	if g_activePlaceableHeap==self then
		g_activePlaceableHeap=nil
	end
	
	for k,v in pairs(g_namedPlaceableHeaps) do
		if(v==self)then
			table.remove(g_namedPlaceableHeaps,k)
			self:showMapHotspot(false,true)
			break
		end
	end
	
	
	UPK_HeapDisplayTrigger:superClass().delete(self)
	
end

function UPK_HeapDisplayTrigger:readStream(streamId, connection)
	UPK_HeapDisplayTrigger:superClass().readStream(self, streamId, connection)
	if connection:getIsServer() then
		local heapName=streamReadString(streamId)
		self:setHeapName(heapName,true)
	end
end;

function UPK_HeapDisplayTrigger:writeStream(streamId, connection)
	UPK_HeapDisplayTrigger:superClass().writeStream(self, streamId, connection)
	if not connection:getIsServer() then
		streamWriteString(streamId,self.heapName)
	end
end;

function UPK_HeapDisplayTrigger:readUpdateStream(streamId, timestamp, connection)
	UPK_HeapDisplayTrigger:superClass().readUpdateStream(self, streamId, timestamp, connection)
	
	if not connection:getIsServer() then
		if bitAND(dirtyMask,self.sellHeapDirtyFlag)~=0 then
			self.placeable:unregister()
			self.placeable:delete()
		end
		
		if bitAND(dirtyMask,self.nameHeapDirtyFlag)~=0 then
			local heapName=streamReadString(streamId)
			self:setHeapName(heapName,true)
		end
	end
end;

function UPK_HeapDisplayTrigger:writeUpdateStream(streamId, connection, dirtyMask)
	UPK_HeapDisplayTrigger:superClass().writeUpdateStream(self, streamId, connection, dirtyMask)
	
	if connection:getIsServer() then
		if bitAND(dirtyMask,self.nameHeapDirtyFlag)~=0 or syncall then
			streamWriteString(streamId,self.heapName)
		end
	end
end;

function UPK_HeapDisplayTrigger:setHeapName(name,alreadySent)
	self:print("UPK_HeapDisplayTrigger:setHeapName: "..tostring(name)..' id '..tostring(self.id))
	if type(name)=="string" then
		name,_=string.gsub(name,"[%c]","");
		name=string.sub(name,1,27);
		
		if(self.heapName~=name)then
			for k,v in pairs(g_namedPlaceableHeaps) do
				if(v==self)then
					table.remove(g_namedPlaceableHeaps,k)
					self:showMapHotspot(false,true)
					break
				end
			end
			self.heapName=tostring(name)
			if(self.heapName~="")then
				table.insert(g_namedPlaceableHeaps,self)
				table.sort(g_namedPlaceableHeaps, function (a, b) return string.lower(a:getHeapName()) < string.lower(b:getHeapName()) end)
				self:showMapHotspot(true,true)
			end
		end
		
		if not alreadySent then
			self:raiseDirtyFlags(self.nameHeapDirtyFlag)
		end
	end
end;

function UPK_HeapDisplayTrigger:getHeapName()
	return self.heapName
end;
	
function UPK_HeapDisplayTrigger:update(dt)
	if self.isClient then
		if self:getShowInfo() then
			local fluid_unit_short=g_i18n:getText("fluid_unit_short")
			local isEmpty=true
			for _,v in pairs(self:getAcceptedFillTypes()) do
				local fillLevel=self.fillLevels[v]
				if fillLevel>0 then
					isEmpty=false
				end
				if fillLevel>0 or not self.onlyFilled then
					local i18n_key=UniversalProcessKit.fillTypeIntToName[v]
					local text=""
					if g_i18n:hasText(i18n_key) then
						text=g_i18n:getText(i18n_key)
					end
					if text~="" then
						text=text..": "
					end
					if self.showFillLevel then
						text=text..math.max(0,math.floor(fillLevel+0.5)) .. "[" .. fluid_unit_short .. "]"
					end
					if self.showPercentage then
						text=text.." "..math.max(0,math.ceil(fillLevel/self.capacity*100)) .. "%"
					end
	    			g_currentMission:addExtraPrintText(text)
				end
			end

			if self.isClient and g_activePlaceableHeap==self then
				if self.timediff<1000 then
					self.timediff=self.timediff+dt;
				else
					if isEmpty and self.placeable~=nil then
				    	g_currentMission:addHelpButtonText(g_i18n:getText("PlaceableHeapSell"), InputBinding.PLACEABLEHEAP_SELL)
						if InputBinding.isPressed(InputBinding.PLACEABLEHEAP_SELL) then
							if self.isServer then
								self.placeable:unregister()
								self.placeable:delete()
								self.placeable=nil
							else
								self:raiseDirtyFlags(self.sellHeapDirtyFlag)
							end
						end
					end
				end
			end
			
			if g_activePlaceableHeap==self then
				if self.heapName~=nil and self.heapName~="" then
					g_currentMission:addExtraPrintText(g_i18n:getText("name")..': '..tostring(self.heapName))
					g_currentMission:addHelpButtonText(g_i18n:getText("PlaceableHeapRename"), InputBinding.PLACEABLEHEAP_NAME)
				else
					g_currentMission:addHelpButtonText(g_i18n:getText("PlaceableHeapName"), InputBinding.PLACEABLEHEAP_NAME)
				end
				if InputBinding.isPressed(InputBinding.PLACEABLEHEAP_NAME) then
					g_gui:showGui("NameHeapDialog")
				end
			end
			
		end
		
		if self.hasPane then
			if self.placeable~=nil and g_gui.currentGuiName=="PlacementScreen" then
				local diffx,diffy,diffz = unpack(self.wpos - {getWorldTranslation(g_placementScreen.camera)})
				if diffx<200 and diffy<200 and diffz<200 then
					local _,wy,_=getRotation(self.placeable.nodeId)
					local tmpy=Utils.getYRotationFromDirection(diffx, diffz)
					local rx=Utils.getYRotationFromDirection(math.sqrt(diffx*diffx+diffz*diffz), diffy)
					setRotation(self.paneId,rx,-(wy-tmpy),0)
					self.showPane=true
				end
			elseif self.showPane then
				setRotation(self.paneId,0,0,0)
				self.showPane=false
			end
		end
	end
end

function UPK_HeapDisplayTrigger:loadExtraNodes(xmlFile, key)
	local heapName=getXMLString(xmlFile, key .. "#name")
	if heapName~=nil and heapName~="" then
		self:setHeapName(heapName,true)
	end
	return true
end;

function UPK_HeapDisplayTrigger:getSaveExtraNodes(nodeIdent)
	local nodes=""
	if self.heapName~=nil and self.heapName~="" then
		nodes=nodes.." name=\""..tostring(self.heapName).."\""
	end
	return nodes
end;

function UPK_HeapDisplayTrigger:triggerCallback(triggerId, otherId, onEnter, onLeave, onStay, otherShapeId)
	if self.isEnabled and (onEnter or onLeave) then
		if g_currentMission.player ~= nil and otherId == g_currentMission.player.rootNode then
			if onEnter then
				g_activePlaceableHeap=self
			end
			self.playerInRange = onEnter==true		
		else
			local vehicle = g_currentMission.nodeToVehicle[otherId]
			if vehicle ~= nil then
				if onEnter then
					self.vehiclesInRange[vehicle] = true
				else
					self.vehiclesInRange[vehicle] = nil
				end
			end
		end
	end
end
