-- by mor2000

PlaceableHeap={}
PlaceableHeap_mt = Class(PlaceableHeap, PlaceableUPK)
InitObjectClass(PlaceableHeap, "PlaceableHeap")

function PlaceableHeap:new(isServer, isClient, customMt)
	local self = PlaceableUPK:new(isServer, isClient, customMt or PlaceableHeap_mt)
	registerObjectClassName(self, "PlaceableHeap")
	self.isServer=isServer
	self.isClient=isClient
	return self
end

function PlaceableHeap:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	if not PlaceableUPK.loadFromAttributesAndNodes(self, xmlFile, key, resetVehicles) then
		return false
	end
	
	if self.base~=nil then
		local fillTypeString=getXMLString(xmlFile, key .. "#fillType")
		local fillType=tonumber(fillTypeString) -- even older compatibility
		if(fillType==nil)then
			fillType=UniversalProcessKit.fillTypeNameToInt[fillTypeString]
		end
		local fillLevel=getXMLFloat(xmlFile, key .. "#fillLevel")
		if fillType~=nil and fillLevel~=nil then
			self.base:setFillLevel(fillLevel,fillType)
		end
	end
	
	return true
end

function PlaceableHeap:delete()
	unregisterObjectClassName(self)
	PlaceableHeap:superClass().delete(self)
end