-- by mor2000
-- v0.2
-- PlacePlaceableHeapListener

--source(g_currentModDirectory.."BuyPlaceableHeapEvent.lua")
--source(g_currentModDirectory.."NameHeapDialog.lua")

PlacePlaceableHeapListener = {}

g_activePlaceableHeap = nil
g_namedPlaceableHeaps = {}

function PlacePlaceableHeapListener:loadMap(name)
	self.xmlFilename=g_modsDirectory.."/PlaceableHeaps/PlaceableHeap.xml"
	self.xmlFilename_lower=self.xmlFilename:lower()
	self.x=0
	self.y=0
	self.z=0
	self.timediff=1000
	self.placeable=nil
	self.isBuyable=false
	self.tempHasObjectOverlap=true
	self.isServer=Utils.getNoNil(g_currentMission:getIsServer(),false)
	self.nameHeap=false
	
	self.addedStatsPage1=false
	self.addedStatsPage2=false
	self.addedStatsPage3=false
	self.typeName="PlaceableHeaps"
end

function PlacePlaceableHeapListener:delete()
end

function PlacePlaceableHeapListener:mouseEvent(posX, posY, isDown, isUp, button)
end

function PlacePlaceableHeapListener:keyEvent(unicode, sym, modifier, isDown)
end

function PlacePlaceableHeapListener:update(dt)
	self.timediff=self.timediff+dt
	if(self.timediff>1000)then
		self.timediff=0
		if(g_currentMission.player~=nil and g_currentMission.player.rootNode~=nil)then
			if g_currentMission.controlPlayer then
				self.x,_,self.z=getWorldTranslation(g_currentMission.player.rootNode)
				self.y=getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, self.x, 0, self.z)
				local placeable={}
				placeable.placementTestSizeX=10
				placeable.placementTestSizeZ=10
				local a=PlacementScreen.isInsidePlacementPlaces(g_currentMission.storeSpawnPlaces, placeable,self.x,self.y,self.z)
				local b=PlacementScreen.isInsidePlacementPlaces(g_currentMission.loadSpawnPlaces, placeable,self.x,self.y,self.z)
				--local c=self:hasObjectOverlap(placeable,self.x,self.y,self.z,self.ry)
				local c=g_activePlaceableHeap==true
				local d=g_currentMission:getIsFieldOwnedAtWorldPos(self.x, self.z)
				--print(tostring(a)..", "..tostring(b)..", "..tostring(c)..", "..tostring(d))
				
				local e=false
				if(self.xmlFilename~=nil)then
					local list=g_currentMission.placeables[self.xmlFilename_lower]
					if list ~= nil then
						for k in pairs(list) do
							local x=self.x-k.base.pos[1]
							if x<10 then
								local z=self.z-k.base.pos[3]
								if z<10 then
									if(Utils.vector2Length(x, z)<10)then
										e=true
										break
									end
								end
							end
						end
					end
				end
				
				--[[
				print('a '..tostring(a==false))
				print('b '..tostring(b==false))
				print('c '..tostring(c==false))
				print('d '..tostring(d==true))
				print('e '..tostring(e==false))
				--]]
				
				self.isBuyable = a==false and b==false and c==false and d==true and e==false
			end
		end
	end
	
	if self.isServer and g_currentMission.player~=nil and g_currentMission.player.rootNode~=nil then
		if g_currentMission.controlPlayer then
			if(self.isBuyable and self.xmlFilename~=nil)then
				g_currentMission:addHelpButtonText(g_i18n:getText("PlaceableHeapBuy"), InputBinding.PLACEABLEHEAP_BUY)
				if InputBinding.isPressed(InputBinding.PLACEABLEHEAP_BUY) then
					--print("Try to buy Heap")
					
					self.isBuyable=false
		
					local buyPlaceable= PlacePlaceableHeapEvent:new(self.x, self.y, self.z, 0, math.random()*(2*math.pi), 0)
					g_client:getServerConnection():sendEvent(buyPlaceable)
				end
			end
		end
	end
	
	if(#g_namedPlaceableHeaps>0 and not self.addedStatsPage1)then
		g_currentMission.missionPDA:addStatsPage(self.drawStatsPage1, self, self.typeName)
		self.addedStatsPage1=true
	elseif(#g_namedPlaceableHeaps==0 and self.addedStatsPage1)then
		g_currentMission.missionPDA:removeStatsPage(self.drawStatsPage1, self, self.typeName)
		self.addedStatsPage1=false
	end
	
	if(#g_namedPlaceableHeaps>11 and not self.addedStatsPage2)then
		g_currentMission.missionPDA:addStatsPage(self.drawStatsPage2, self, self.typeName)
		self.addedStatsPage2=true
	elseif(#g_namedPlaceableHeaps<=11 and self.addedStatsPage2)then
		g_currentMission.missionPDA:removeStatsPage(self.drawStatsPage2, self, self.typeName)
		self.addedStatsPage2=false
	end
	
	if(#g_namedPlaceableHeaps>22 and not self.addedStatsPage3)then
		g_currentMission.missionPDA:addStatsPage(self.drawStatsPage3, self, self.typeName)
		self.addedStatsPage3=true
	elseif(#g_namedPlaceableHeaps<=22 and self.addedStatsPage3)then
		g_currentMission.missionPDA:removeStatsPage(self.drawStatsPage3, self, self.typeName)
		self.addedStatsPage3=false
	end

end;

function PlacePlaceableHeapListener:drawStatsPage(page)
    setTextBold(true)
    setTextColor(1, 1, 1, 1)
    setTextBold(false)
 
    local yOffset = 0.025
    local fluid_unit_short=g_i18n:getText("fluid_unit_short")
    local pda = g_currentMission.missionPDA

	local first=1
	if(page~=nil)then
		first=(page-1)*11+1
	end
    local last=math.min(first+10,#g_namedPlaceableHeaps)
	
	local nrOfPages=1
	if self.addedStatsPage3 then
		nrOfPages=3
	elseif self.addedStatsPage2 then
		nrOfPages=2
	end
	
	j=1
	
	setTextBold(true)
	renderText(pda.pdaCol1, pda.pdaHeadRow - pda.financeRowSpacing * j + yOffset, pda.pdaFontSize, g_i18n:getText('PlaceableHeaps')..' ('..tostring(page)..'/'..tostring(nrOfPages)..')')
	setTextBold(false)
	
	for i=first,last do
		j=j+1
		v=g_namedPlaceableHeaps[i]
		local fillType=v:getFillType()
		local fillTypeName=Fillable.fillTypeIntToName[fillType]
		if fillTypeName=="unknown" then
			fillTypeName=""
		else
			fillTypeName=g_i18n:getText(fillTypeName)
		end
		renderText(pda.pdaCol1, pda.pdaHeadRow - pda.financeRowSpacing * j + yOffset, pda.pdaFontSize, v:getHeapName())
		if(fillType~="unknown")then
			renderText(pda.pdaCol2, pda.pdaHeadRow - pda.financeRowSpacing * j + yOffset, pda.pdaFontSize,
	  	  			math.floor(v:getFillLevel(fillType)) .. "[" .. fluid_unit_short .. "] " .. fillTypeName)
		else
			renderText(pda.pdaCol2, pda.pdaHeadRow - pda.financeRowSpacing * j + yOffset, pda.pdaFontSize,
  	  				"0 [" .. fluid_unit_short .. "]")
		end
  	end		
		
	setTextColor(1, 1, 1, 1)
end

function PlacePlaceableHeapListener:drawStatsPage1()
	self:drawStatsPage(1)
end

function PlacePlaceableHeapListener:drawStatsPage2()
	self:drawStatsPage(2)
end

function PlacePlaceableHeapListener:drawStatsPage3()
	self:drawStatsPage(3)
end
	
function PlacePlaceableHeapListener:draw()
end

function PlacePlaceableHeapListener:deleteMap()
	self.xmlFilename=nil
	self.xmlFilename_lower=nil
	if(self.addedStatsPage1)then
		g_currentMission.missionPDA:removeStatsPage(self.drawStatsPage1, self, self.typeName)
		self.addedStatsPage1=false
	end
	if(self.addedStatsPage2)then
		g_currentMission.missionPDA:removeStatsPage(self.drawStatsPage2, self, self.typeName)
		self.addedStatsPage2=false
	end
	if(self.addedStatsPage3)then
		g_currentMission.missionPDA:removeStatsPage(self.drawStatsPage3, self, self.typeName)
		self.addedStatsPage3=false
	end
end

addModEventListener(PlacePlaceableHeapListener)
