PlacePlaceableHeapEvent = {}
PlacePlaceableHeapEvent_mt = Class(PlacePlaceableHeapEvent, Event)

function PlacePlaceableHeapEvent:emptyNew()
	local self = Event:new(PlacePlaceableHeapEvent_mt)
	return self
end;

function PlacePlaceableHeapEvent:new(x, y, z, rx, ry, rz)
    local self = PlacePlaceableHeapEvent:emptyNew()
    self.x = x
    self.y = y
    self.z = z
    self.rx = rx
    self.ry = ry
    self.rz = rz
    return self
end
 
 function PlacePlaceableHeapEvent:readStream(streamId, connection)
 	if not connection:getIsServer() then
 		self.x = streamReadFloat32(streamId)
 		self.y = streamReadFloat32(streamId)
 		self.z = streamReadFloat32(streamId)
 		self.rx = streamReadFloat32(streamId)
 		self.ry = streamReadFloat32(streamId)
 		self.rz = streamReadFloat32(streamId)
 	else
		-- necessary?
 		self.successful = streamReadBool(streamId)
 	end
 	self:run(connection)
 end;
 
 function PlacePlaceableHeapEvent:writeStream(streamId, connection)
 	if connection:getIsServer() then
 		streamWriteFloat32(streamId, self.x)
 		streamWriteFloat32(streamId, self.y)
 		streamWriteFloat32(streamId, self.z)
 		streamWriteFloat32(streamId, self.rx)
 		streamWriteFloat32(streamId, self.ry)
 		streamWriteFloat32(streamId, self.rz)
 	else
		-- necessary?
 		streamWriteBool(streamId, self.successful)
 	end
 end;

function PlacePlaceableHeapEvent:run(connection)
	if not connection:getIsServer() then
		local successful=false
		local placeable=PlaceableHeap:new(g_currentMission:getIsServer(), g_currentMission:getIsClient())
		filename=g_modsDirectory.."/PlaceableHeaps/PlaceableHeap.xml"
		if placeable:load(filename, self.x, self.y, self.z, self.rx, self.ry, self.rz, false)then
			placeable:register()
		else
			placeable:delete()
			placeable = nil
		end
	end
end;

UniversalProcessKit.InitEventClass(PlacePlaceableHeapEvent,"PlacePlaceableHeapEvent")

