-- by mor2000
-- greatly inspired by ChatDialog
NameHeapDialog = {}
local NameHeapDialog_mt = Class(NameHeapDialog)
function NameHeapDialog:new()
  local self = {}
  self = setmetatable(self, NameHeapDialog_mt)
  return self
end
function NameHeapDialog:onCreateTextInput(element)
  self.textElement = element
end
function NameHeapDialog:onOpen(element)
	g_currentMission.isPlayerFrozen = true
	self.textElement:setForcePressed(true)
	self.textElement:setText((g_activePlaceableHeap or {}):getHeapName() or "")
	local title=""
	if self.textElement.text=="" then
		title=g_i18n:getText("PlaceableHeapName")
	else
		title=g_i18n:getText("PlaceableHeapRename")
	end
	self.titleElement:setText(title)
	InputBinding.setShowMouseCursor(true)
end
function NameHeapDialog:onClose(element)
  g_currentMission.isPlayerFrozen = false
  self.textElement:setForcePressed(false)
  InputBinding.setShowMouseCursor(false)
end
function NameHeapDialog:onSendClick()
	if(g_activePlaceableHeap~=nil)then
		g_activePlaceableHeap:setHeapName(self.textElement.text);
	end;
	self.textElement:setText("")
	g_gui:showGui("")
end
function NameHeapDialog:onCancelClick()
	self.textElement:setText("")
	g_gui:showGui("")
end
function NameHeapDialog:onEnterPressed()
  self:onSendClick()
end
function NameHeapDialog:update(dt)
  if InputBinding.hasEvent(InputBinding.MENU_CANCEL, true) then
    InputBinding.hasEvent(InputBinding.MENU, true)
    self:onCancelClick()
  end
end

--[[
g_gui.showNameHeapDialog=function(self)
	local guiName="NameHeapDialog"

	local gui = self.guis[guiName]
	
	self.__oldCurrentGui = self.currentGui
	self.__oldCurrentGuiName = self.currentGuiName
	self.__oldCurrentListener = self.currentListener
	
	self.currentGui = gui
	self.currentGuiName = guiName
	self.currentListener = gui
	
	self.currentGui.target = self.__oldCurrentGui
	
	FocusManager:setGui(guiName)
	if gui ~= nil then
		gui:onOpen()
	end
	return gui
end

g_gui.closeNameHeapDialog=function(self)
	self.currentGui = self.__oldCurrentGui
	self.currentGuiName = self.__oldCurrentGuiName
	self.currentListener = self.__oldCurrentListener
	FocusManager:setGui(self.__oldCurrentGuiName)
end
]]--
	

g_nameHeapDialog = NameHeapDialog:new()
gui = g_gui:loadGui(g_currentModDirectory.."gui/NameHeapDialog.xml", "NameHeapDialog", g_nameHeapDialog)
