--
-- @modified Mev01
-- @date  13/04/09

Pflug = {};

function Pflug.prerequisitesPresent(specializations)
    return true;
end;

function Pflug:load(xmlFile)



    local rotationPartNodeRight = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartRight#index"));
    if rotationPartNodeRight ~= nil then
        self.rotationPartRight = {};
        self.rotationPartRight.node = rotationPartNodeRight;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartRight#minRot"));
        self.rotationPartRight.minRot = {};
        self.rotationPartRight.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartRight.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartRight.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartRight#maxRot"));
        self.rotationPartRight.maxRot = {};
        self.rotationPartRight.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartRight.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartRight.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartRight.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartRight#rotTime"), 2)*1000;
        self.rotationPartRight.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartRight#touchRotLimit"), 10));
    end;

    local rotationPartNodeLeft = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartLeft#index"));
    if rotationPartNodeLeft ~= nil then
        self.rotationPartLeft = {};
        self.rotationPartLeft.node = rotationPartNodeLeft;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLeft#minRot"));
        self.rotationPartLeft.minRot = {};
        self.rotationPartLeft.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartLeft.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartLeft.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLeft#maxRot"));
        self.rotationPartLeft.maxRot = {};
        self.rotationPartLeft.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartLeft.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartLeft.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartLeft.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLeft#rotTime"), 2)*1000;
        self.rotationPartLeft.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLeft#touchRotLimit"), 10));
    end;

    self.setFoldDirection = SpecializationUtil.callSpecializationsFunction("setFoldDirection");

    self.posDirectionText = Utils.getNoNil(getXMLString(xmlFile, "vehicle.foldingParts#posDirectionText"), "fold_OBJECT");
    self.negDirectionText = Utils.getNoNil(getXMLString(xmlFile, "vehicle.foldingParts#negDirectionText"), "unfold_OBJECT");
    local startMoveDirection = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.foldingParts#startMoveDirection"), 0);
    self.startAnimTime = 0;
    if startMoveDirection > 0.1 then
        self.startAnimTime = 1;
    end;
    
    self.foldAnimTime = 0;
    self.maxFoldAnimDuration = 0.0001;

    self.foldingParts = {};
    local i=0;
    while true do
        local baseName = string.format("vehicle.foldingParts.foldingPart(%d)", i);
        local index = getXMLInt(xmlFile, baseName.. "#componentJointIndex");
        if index == nil then
            break;
        end;
        local componentJoint = self.componentJoints[index+1];
        if componentJoint ~= nil then
            local entry = {};

            entry.componentJoint = componentJoint;
            entry.anchorActor = Utils.getNoNil(getXMLInt(xmlFile,  baseName.."#anchorActor"), 0);

            local rootNode = Utils.indexToObject(self.components, getXMLString(xmlFile, baseName.."#rootNode"));
            entry.animCharSet = 0;
            if rootNode ~= nil then
                entry.animCharSet = getAnimCharacterSet(rootNode);
                if entry.animCharSet ~= 0 then
                    local clip = getAnimClipIndex(entry.animCharSet, getXMLString(xmlFile, baseName.."#animationClip"));
                    if clip >= 0 then
                        assignAnimTrackClip(entry.animCharSet, 0, clip);
                        setAnimTrackLoopState(entry.animCharSet, 0, false);
                        entry.speedScale = Utils.getNoNil(getXMLFloat(xmlFile, baseName.."#speedScale"), 1);
                        entry.animDuration = getAnimClipDuration(entry.animCharSet, clip);
                        self.maxFoldAnimDuration = math.max(self.maxFoldAnimDuration, entry.animDuration);

                        local node = self.components[componentJoint.componentIndices[((entry.anchorActor+1)%2)+1] ].node;
                        entry.x,entry.y,entry.z = worldToLocal(componentJoint.jointNode, getWorldTranslation(node));
                        entry.upX,entry.upY,entry.upZ = worldDirectionToLocal(componentJoint.jointNode, localDirectionToWorld(node, 0, 1, 0));
                        entry.dirX,entry.dirY,entry.dirZ = worldDirectionToLocal(componentJoint.jointNode, localDirectionToWorld(node, 0, 0, 1));

                        table.insert(self.foldingParts, entry);
                    end;
                end;
            end;

        end;
        i = i+1;
    end;
    self.rotateLeftToMax = Utils.getNoNil(getXMLBool(xmlFile, "vehicle.rotateLeftToMax#value"), true);
    self.foldMoveDirection = startMoveDirection;

    Pflug.setAnimTime(self, self.startAnimTime)
end;

function Pflug:delete()
end;

function Pflug:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)

    Pflug.setAnimTime(self, self.startAnimTime)
    return BaseMission.VEHICLE_LOAD_OK;
end;

function Pflug:setRelativePosition(positionX, offsetY, positionZ, yRot)
    Pflug.setAnimTime(self, self.startAnimTime);
end;


function Pflug:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Pflug:keyEvent(unicode, sym, modifier, isDown)

   if sym == Input.KEY_m then
		self.rotationMaxRight = isDown;
                self.rotationMaxLeft = isDown;
	end;

         if sym == Input.KEY_n then
		self.rotationMinRight = isDown;
                self.rotationMinLeft = isDown;
	end;




        if isDown and sym == Input.KEY_0 then
		self.helpPanel = not self.helpPanel;
	end;
end;

function Pflug:update(dt)

    
     if self:getIsActive() then
        for k,foldingPart in pairs(self.foldingParts) do
            local isInvalid = false;
            local charSet = foldingPart.animCharSet;
            if self.foldMoveDirection > 0.1 then
                local trackTime = getAnimTrackTime(charSet, 0);
                if trackTime < foldingPart.animDuration then
                    isInvalid = true;
                end;
                self.foldAnimTime = trackTime / self.maxFoldAnimDuration;
            elseif self.foldMoveDirection < -0.1 then
                local trackTime = getAnimTrackTime(charSet, 0);
                if trackTime > 0 then
                    isInvalid = true;
                end;
                self.foldAnimTime = trackTime / self.maxFoldAnimDuration;
            end;
            if isInvalid then
                setJointFrame(foldingPart.componentJoint.jointIndex, foldingPart.anchorActor, foldingPart.componentJoint.jointNode);
            end;
        end;
        self.foldAnimTime = Utils.clamp(self.foldAnimTime, 0, 1);
    end;

    if self:getIsActiveForInput() then
        if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA2) then
            
			 if self.foldMoveDirection > 0.1 or (self.foldMoveDirection == 0 and self.foldAnimTime > 0.5) then
                self:setFoldDirection(-1)
            else
                self:setFoldDirection(1)
            end;
        end;
    end;

  

    if self.rotationPartRight ~= nil and (self.rotationMaxRight or self.rotationMinRight) then
        local x, y, z = getRotation(self.rotationPartRight.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartRight.maxRot, self.rotationPartRight.minRot, 3, self.rotationPartRight.rotTime, dt, not self.rotationMaxRight);
        setRotation(self.rotationPartRight.node, unpack(newRot));
    end;

    

    if self.rotationPartLeft ~= nil and (self.rotationMaxLeft or self.rotationMinLeft) then
        local x, y, z = getRotation(self.rotationPartLeft.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartLeft.maxRot, self.rotationPartLeft.minRot, 3, self.rotationPartLeft.rotTime, dt, not self.rotationMaxLeft);
        setRotation(self.rotationPartLeft.node, unpack(newRot));
    end;


end;

function Pflug:draw()

     if table.getn(self.foldingParts) > 0 then
        if self.foldMoveDirection > 0.1 or (self.foldMoveDirection == 0 and self.foldAnimTime > 0.5) then
            g_currentMission:addHelpButtonText(string.format(g_i18n:getText(self.negDirectionText), self.typeDesc), InputBinding.IMPLEMENT_EXTRA2);
        else
            g_currentMission:addHelpButtonText(string.format(g_i18n:getText(self.posDirectionText), self.typeDesc), InputBinding.IMPLEMENT_EXTRA2);
        end;
    end;
	 
	 if self.attacherVehicle then
		if not self.helpPanel then
			renderText(0.8335, 0.17, 0.02, "Taste 0: Info");

		else
			renderText(0.8335, 0.17, 0.02, "Taste 0: Info Abschalten");

		end;
		if self.helpPanel then
			renderText(0.7635, 0.33, 0.025, "- Pflug Info -");
			renderText(0.7635, 0.305, 0.02, "Tasten N Pflug nach Rechts drehen");
                                          renderText(0.7635, 0.29, 0.02, "Taste M Pflug nach Links drehen");
                                          renderText(0.7635, 0.275, 0.02, "Taste X Pflug ein/aus klappen");
		end;
	end;

end;

function Pflug:onAttach()
end;

function Pflug:onDetach()
    if self.deactivateOnDetach then
        Foldable.onDeactivate(self);
    end;
end;

function Pflug:onLeave()
    if self.deactivateOnLeave then
        Foldable.onDeactivate(self);
    end;
end;

function Pflug:onDeactivate()
    self:setFoldDirection(0);
end;

function Pflug:setFoldDirection(direction)
    self.foldMoveDirection = direction;
    for k,foldingPart in pairs(self.foldingParts) do
        local charSet = foldingPart.animCharSet;
        local speedScale = nil;
        if self.foldMoveDirection > 0.1 then
            speedScale = foldingPart.speedScale;
        elseif self.foldMoveDirection < -0.1 then
            speedScale = -foldingPart.speedScale;
        end;
        if speedScale ~= nil then
            if speedScale > 0 then
                if getAnimTrackTime(charSet, 0) < 0.0 then
                    setAnimTrackTime(charSet, 0, 0.0);
                end;
            else
                if getAnimTrackTime(charSet, 0) > foldingPart.animDuration then
                    setAnimTrackTime(charSet, 0, foldingPart.animDuration);
                end;
            end;
            setAnimTrackSpeedScale(charSet, 0, speedScale);
            enableAnimTrack(charSet, 0);
        else
            disableAnimTrack(charSet, 0);
        end;
    end;
end;

function Pflug.setAnimTime(self, animTime)
    self.foldAnimTime = animTime;
    for k,foldingPart in pairs(self.foldingParts) do
        enableAnimTrack(foldingPart.animCharSet, 0);
        setAnimTrackTime(foldingPart.animCharSet, 0, animTime*foldingPart.animDuration, true);
        disableAnimTrack(foldingPart.animCharSet, 0);
    end;

    for k,foldingPart in pairs(self.foldingParts) do
        local componentJoint = foldingPart.componentJoint;

        local node = self.components[componentJoint.componentIndices[((foldingPart.anchorActor+1)%2)+1] ].node;
        local x,y,z = localToWorld(componentJoint.jointNode, foldingPart.x, foldingPart.y, foldingPart.z);
        local upX,upY,upZ = localDirectionToWorld(componentJoint.jointNode, foldingPart.upX,foldingPart.upY,foldingPart.upZ);
        local dirX,dirY,dirZ = localDirectionToWorld(componentJoint.jointNode, foldingPart.dirX,foldingPart.dirY,foldingPart.dirZ);
        Utils.setWorldTranslation(node, x,y,z);
        Utils.setWorldDirection(node, dirX,dirY,dirZ, upX,upY,upZ);

        setJointFrame(componentJoint.jointIndex, foldingPart.anchorActor, componentJoint.jointNode);
    end;
end;

function Pflug:aiRotateLeft()
    self.rotationMaxRight = self.rotateLeftToMax;
    self.rotationMinRight = self.rotateLeftToMin;
end;

function Pflug:aiRotateRight()
    self.rotationMaxRight = not self.rotateLeftToMax;
    self.rotationMinRight = not self.rotateLeftToMin;
end;

function Pflug:aiInvertsMarkerOnTurn(turnLeft)
    if turnLeft then
        return self.rotationMaxRight ~= self.rotateLeftToMax;
        
	else
        return self.rotationMaxRight == self.rotateLeftToMax;
        
	end;
end;