--[[
----- moddesc.xml anfang -----
    <l10n>
		<text name="overflow">
			<en>Pickup Verstopfung lsen</en>  
		</text>
		<text name="mh_OVERFLOW">
			<en>Pickup Verstopft!</en> 
		</text>
	</l10n>
	
    <specializations>
		<specialization name="mh" className="mh" filename="scripts/mh.lua" />
    </specializations>
	
	<specialization name="mh" /> 
	
	<inputBindings>
		<input name="mh_OVERFLOW" category="ONFOOT" key1="KEY_z" key2="" button="" device="0" mouse="" />
    </inputBindings>

----- moddesc.xml ende -----

----- mod.xml anfang -----
	<OverflowModel index="1>4" />
----- mod.xml -----

]]--
mh = {};

function mh.prerequisitesPresent(specializations)
	return true;
end;

function mh:load(xmlFile)
	self.setOverFlow = SpecializationUtil.callSpecializationsFunction("setOverFlow");
	self.OverFlow = false;
	self.OverflowModel = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.OverflowModel#index"));
	self.speedViolationMaxTime = 3500;
	self.speedViolationTimer1 = self.speedViolationMaxTime;
	
end;

function mh:delete()
end;

function mh:readStream(streamId, connection)
	self.OverFlow = streamReadBool(streamId);
end;

function mh:writeStream(streamId, connection)
	streamWriteBool(streamId, self.OverFlow);
end;

function mh:readUpdateStream(streamId, timestamp, connection)
end;

function mh:writeUpdateStream(streamId, connection, dirtyMask)
end;
 
function mh:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	self.OverFlow = Utils.getNoNil(getXMLBool(xmlFile, key.."#OverFlow"), false);
	return BaseMission.VEHICLE_LOAD_OK;
end

function mh:getSaveAttributesAndNodes(nodeIdent)
	local attributes = 'OverFlow="'..tostring(self.OverFlow)..'"';
	return attributes,nodes;
end;

function mh:mouseEvent(posX, posY, isDown, isUp, button)
end;

function mh:keyEvent(unicode, sym, modifier, isDown)
end;

function mh:update(dt)
	if self.isClient then
		if self.OverFlow then
			setVisibility(self.OverflowModel, true);
			if self.attacherVehicle~=nil then 
				self.attacherVehicle:setIsThreshing(false, true);
			end
			if self.inrange then
				g_currentMission:addHelpButtonText(g_i18n:getText("overflow"), InputBinding.mh_OVERFLOW);
				if InputBinding.hasEvent(InputBinding.mh_OVERFLOW) then
					self:setOverFlow(false);
				end;
			end;
		else
			setVisibility(self.OverflowModel, false);
		end;
		if self.reelStarted then
			if self.attacherVehicle~=nil and self:doCheckSpeedLimit() and self.attacherVehicle.lastSpeed * 3850 > 11 then
				self.speedViolationTimer1 = self.speedViolationTimer1 - dt;
				if self.speedViolationTimer1 < 0 and self.attacherVehicle~=nil then
					self:setOverFlow(true);
				end;
			else
				self.speedViolationTimer1 = self.speedViolationMaxTime;
			end;
		end;
	end;
end;

function mh:updateTick(dt)
	if self.attacherVehicle and g_currentMission.player ~= nil then
		-- Getting the distance between the player and the implement 
		local nearestDistance = 4.0; --max distance allowed
		local px, py, pz = getWorldTranslation(self.rootNode); 
		local vx, vy, vz = getWorldTranslation(g_currentMission.player.rootNode);
		local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);	
		if distance < nearestDistance then
			self.inrange = true; 
		else
			self.inrange = false; 
		end;
	end;
end;

function mh:draw()
	if self.isClient then
		if self.OverFlow then
			g_currentMission:addWarning(g_i18n:getText("mh_OVERFLOW"));
		end;		
	end;
end;
function mh:setOverFlow(OverFlow, noEventSend)
	if OverFlow ~= self.OverFlow then
		self.OverFlow = OverFlow;
		if noEventSend == nil or noEventSend == false then
			if g_server ~= nil then
				g_server:broadcastEvent(setOverFlowEvent:new(self, OverFlow), nil, nil, self);
			else
				g_client:getServerConnection():sendEvent(setOverFlowEvent:new(self, OverFlow));
			end;
		end;
	end;
end;


setOverFlowEvent = {};
setOverFlowEvent_mt = Class(setOverFlowEvent, Event);

InitEventClass(setOverFlowEvent, "setOverFlowEvent");

function setOverFlowEvent:emptyNew()
    local self = Event:new(setOverFlowEvent_mt);
    self.className="setOverFlowEvent";
    return self;
end;

function setOverFlowEvent:new(object, OverFlow)
    local self = setOverFlowEvent:emptyNew()
    self.object = object;
    self.OverFlow = OverFlow;
    return self;
end;

function setOverFlowEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
    self.OverFlow = streamReadBool(streamId);
    self.object = networkGetObject(id);
    self:run(connection);
end;

function setOverFlowEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
    streamWriteBool(streamId, self.OverFlow);
end;

function setOverFlowEvent:run(connection)
    self.object:setOverFlow(self.OverFlow, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(setOverFlowEvent:new(self.object, self.OverFlow), nil, connection, self.object);
    end;
end;