--
-- mooringblocks
--
-- @author  Geri-G
-- @date  31/07/10
--
-- Copyright (C) Geri-G

mooringblocks = {};

function mooringblocks.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Attachable, specializations);
end;

function mooringblocks:load(xmlFile)
	self.disabledBlocks = {};
	self.enabledBlocks = {};
	
	local i = 0;
	while true do
		local baseString = string.format("vehicle.mooringblocks.enabled.mooringblock(%d)",i);
		local nodeStrg = getXMLString(xmlFile,baseString.."#node");
		if nodeStrg == nil then
			break;
		end;
		local entry = {};
		
		entry.node = Utils.indexToObject(self.components, nodeStrg);
		entry.trans = {getTranslation(entry.node)};
		entry.rot = {getRotation(entry.node)};
		entry.oldParent = getParent(entry.node);
		table.insert(self.enabledBlocks,entry);
		setRigidBodyType(entry.node,"None");
		i = i+1;
	end;	
	local i = 0;
	while true do
		local baseString = string.format("vehicle.mooringblocks.disabled.mooringblock(%d)",i);
		local nodeStrg = getXMLString(xmlFile,baseString.."#node");
		if nodeStrg == nil then
			break;
		end;
		node = Utils.indexToObject(self.components, nodeStrg);
		table.insert(self.disabledBlocks,node);
		i = i+1;
	end;
	local joint = getXMLInt(xmlFile,"vehicle.fixedJoint#CompJointIndex");
	if joint ~= nil then
		if self.componentJoints[joint] ~= nil then
			self.joint = self.componentJoints[joint];
			local x,y,z = Utils.getVectorFromString(getXMLString(xmlFile,string.format("vehicle.components.joint(%d)#rotLimit",joint-1)));
				x = Utils.getNoNil(Utils.degToRad(x), 0);
				y = Utils.getNoNil(Utils.degToRad(y), 0);
				z = Utils.getNoNil(Utils.degToRad(z), 0);			
				
			local x1,y1,z1 = Utils.getVectorFromString(getXMLString(xmlFile,"vehicle.fixedJoint#jointDir"));
				x1 = Utils.getNoNil(x1, 1);
				y1 = Utils.getNoNil(y1, 0);
				z1 = Utils.getNoNil(z1, 0);
			
			self.JointRotLimit = {x,y,z};
			self.JointDir = {x1,y1,z1};
			self.jointRot = {getRotation(self.joint.jointNode)};
		end;
	end;
	self.doJointSearch = false;
	self.changeBlocks = mooringblocks.changeBlocks;
	
	--self:changeBlocks(false);
end;

function mooringblocks:delete()

end;

function mooringblocks:mouseEvent(posX, posY, isDown, isUp, button)
end;

function mooringblocks:keyEvent(unicode, sym, modifier, isDown)
end;

function mooringblocks:update(dt)
	if self:getIsActive() then
		if self.doJointSearch then	
			for i,v in pairs(self.attacherVehicle.attachedImplements) do
				if v.object == self then
					local joint = self.attacherVehicle.attacherJoints[v.jointDescIndex];
					self.vehicleJointSelf = joint;	
					break;
				end;
			end;
			self.doJointSearch = false;
		end;
	end;
end;
function mooringblocks:draw()

end;

function mooringblocks:onAttach(attacherVehicle)
	self:changeBlocks(true);
	self.doJointSearch = true;
	if self.joint ~= nil then
		local joint = self.joint;
		for i=1,3 do
			setJointRotationLimit(joint.jointIndex,i-1,true,-self.JointRotLimit[i],self.JointRotLimit[i]);
		end;
		setRotation(joint.jointNode,unpack(self.jointRot));
		setJointFrame(joint.jointIndex, 0, joint.jointNode);
	end;
end;

function mooringblocks:onDetach()
	self:changeBlocks(false);
	if self.joint ~= nil then	
		local joint = self.joint;
		
		local ax, ay, az = getWorldTranslation(joint.jointNode);
		local bx, by, bz = getWorldTranslation(self.vehicleJointSelf.jointTransform);
		local x, y, z = worldDirectionToLocal(getParent(joint.jointNode), bx-ax, by-ay, bz-az);

		setDirection(joint.jointNode, x, y, z,unpack(self.JointDir));	-- -1
		self.vehicleJointSelf = nil;
		
		for i=1,3 do
			setJointRotationLimit(joint.jointIndex,i-1,true,0,0);
		end;
		setJointFrame(joint.jointIndex, 0, joint.jointNode);
		
		if self.setHydraulicDirection ~= nil then
			self:setHydraulicDirection();
		end;
	end;
end;
function mooringblocks:changeBlocks(enabled)

	if enabled == false then
		for k,v in pairs(self.disabledBlocks) do
			setVisibility(v, false);
		end;	
		for k,v in pairs(self.enabledBlocks) do
			setVisibility(v.node, true);
			local x,y,z = getWorldTranslation(v.node);
			local x1,y1,z1 = getWorldRotation(v.node);
			link(getRootNode(),v.node);
			setTranslation(v.node,x,y,z);
			setRotation(v.node,x1,y1,z1);
			setRigidBodyType(v.node,"Dynamic");
		end;
	elseif enabled == true then
		for k,v in pairs(self.disabledBlocks) do
			setVisibility(v, true);
		end;	
		for k,v in pairs(self.enabledBlocks) do
			setVisibility(v.node, false);
			setRigidBodyType(v.node,"None");
			link(v.oldParent,v.node);
			setTranslation(v.node,unpack(v.trans));
			setRotation(v.node,unpack(v.rot));
		end;
	end;
end;
function mooringblocks:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	if not resetVehicles and self.joint ~= nil then
		local joint = self.joint;
		local string = getXMLString(xmlFile,key.."#drawbarRot");
		if string ~= nil then
			local x,y,z = Utils.getVectorFromString(string);	
				x = Utils.getNoNil(x, self.jointRot[1]);
				y = Utils.getNoNil(y, self.jointRot[2]);
				z = Utils.getNoNil(z, self.jointRot[3]);
			setRotation(joint.jointNode,x,y,z);
			for i=1,3 do
				setJointRotationLimit(joint.jointIndex,i-1,true,0,0);
			end;
			setJointFrame(joint.jointIndex, 0, joint.jointNode);
		end;
	end;
    return BaseMission.VEHICLE_LOAD_OK;
end;

function mooringblocks:getSaveAttributesAndNodes(nodeIdent)
    local node = nil;
    local attributes = nil;
	if self.joint ~= nil then
		local x,y,z = getRotation(self.joint.jointNode);
		attributes = ' drawbarRot="'..string.format("%0.3f %0.3f %0.3f",x,y,z)..'"';
	end;
    return attributes, node;
end;