--
-- Play Animation 
-- Northern_Strike
-- 

playanim = {};

function playanim.prerequisitesPresent(specializations)
	Vehicle.registerJointType("trailerLow");
    return SpecializationUtil.hasSpecialization(Trailer, specializations);
end;

function playanim:load(xmlFile)

	self.myReelNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.myReel#index"));

	self.myReelSpeed = 0;

	self.SetDoorPanel = SpecializationUtil.callSpecializationsFunction("SetDoorPanel");
	self.DoorPanel = true;	

self.rroll = true

	self.SetPodbPanel = SpecializationUtil.callSpecializationsFunction("SetPodbPanel");
	self.PodbPanel = true;	

self.controlpath = Utils.getFilename("menu.png", self.baseDirectory);

self.hudfurazhirWidth = 0.700;
    self.hudfurazhirHeight = 0.320;
    self.hudfurazhirPoxX = 0;
    self.hudfurazhirPoxY = 0;
    self.hudfurazhirOverlay = Overlay:new("hudfurazhir", self.controlpath, self.hudfurazhirPoxX, self.hudfurazhirPoxY, self.hudfurazhirWidth, self.hudfurazhirHeight);

end;

function playanim:delete()
end;

function playanim:readStream(streamId, connection)
    self:SetDoorPanel(streamReadBool(streamId), true);
    self:SetPodbPanel(streamReadBool(streamId), true);
end;

function playanim:writeStream(streamId, connection)
    streamWriteBool(streamId, self.DoorPanel);
    streamWriteBool(streamId, self.DoorPodb);
end;

function playanim:mouseEvent(posX, posY, isDown, isUp, button)
end;

function playanim:keyEvent(unicode, sym, modifier, isDown)
end;

function playanim:update(dt)

if self.myReelNode ~= nil then
					rotate(self.myReelNode, 0, 0, self.myReelSpeed);
				end;


		if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA) then
		   	if self.rroll == false then
		   	   self.rroll = true
		   	else
		   		self.rroll = false
		   	end;
		end;

		if self.rroll == false then
	self.myReelSpeed = -0.1;
		end;
		
		if self.rroll == true then
	self.myReelSpeed = 0;
		end;

		if InputBinding.hasEvent(InputBinding.ENTER) then
		   	   self.rroll = true
		end;

if self.inrange then
		if InputBinding.hasEvent(InputBinding.prp_trns) then
			self:SetDoorPanel(not self.DoorPanel);
		end;		
end;

		if InputBinding.hasEvent(InputBinding.opusks) then
			self:SetPodbPanel(not self.PodbPanel);
		end;		

if self.inrange then
		if self.DoorPanel then
			self:setAnimationTime(1, self.animationParts[1].offSet);
			g_currentMission:addHelpButtonText(g_i18n:getText("furazhir_4"), InputBinding.prp_trns);
		else
			self:setAnimationTime(1, self.animationParts[1].animDuration);
			g_currentMission:addHelpButtonText(g_i18n:getText("furazhir_5"), InputBinding.prp_trns);
		end;
	end;

		if self.PodbPanel then
			self:setAnimationTime(2, self.animationParts[2].offSet);
		else
			self:setAnimationTime(2, self.animationParts[2].animDuration);
		end;

			if InputBinding.hasEvent (InputBinding.INFOHUD) then
				self.bcActive = not self.bcActive;
			end;

end;

function playanim:updateTick(dt)
if g_currentMission.player ~= nil then
		-- Getting the distance between the player and the implement 
		local nearestDistance = 4.0; --max distance allowed
		local px, py, pz = getWorldTranslation(self.rootNode); 
		local vx, vy, vz = getWorldTranslation(g_currentMission.player.rootNode);
		local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);	
		if distance < nearestDistance then
			self.inrange = true; 
		else
			self.inrange = false; 
		end;
	end;
end;

function playanim:draw()
if self.attacherVehicle then
 	 if self.hudfurazhirOverlay ~= nil then
  if self.bcActive then
    self.hudfurazhirOverlay:render();
  end;
end;
		if self.bcActive then	
			g_currentMission:addExtraPrintText("NumPad 0: INFO ON");
		else
			g_currentMission:addExtraPrintText("NumPad 0: INFO Off");
		end;  
end;
end;

function playanim:onLeave()
if self.attacherVehicle then
self.rroll = true
	end;
self.myReelSpeed = 0;
end;

function playanim:onAttach()
self.rroll = true
end;

function playanim:onDetach()
self.rroll = true
 end;
function playanim:SetDoorPanel(isDoorPanel,noEventSend)
	SetDoorPanelEvent.sendEvent(self, isDoorPanel, noEventSend);
	if isDoorPanel then
		self.DoorPanel = true;
	else
		self.DoorPanel = false;
	end;
end;

function playanim:SetPodbPanel(isPodbPanel,noEventSend)
	SetPodbPanelEvent.sendEvent(self, isPodbPanel, noEventSend);
	if isPodbPanel then
		self.PodbPanel = true;
	else
		self.PodbPanel = false;
	end;
end;


function playanim:validateAttacherJoint(trailerLow, jointDesc, dt)
    return true;
end;