--
-- class for opusk
--
-- Author Sebastian B. (Blancker, www.landwirtschaftssimulator-2009.de)
--
-- Date  08.08.2009
--
-- Copyright (C) Blancker
-- Edit by Mario


opusk = {}

function opusk.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Attachable, specializations);
end;

function opusk:load(xmlFile)        
	
	-- Anfang Left
	
	local rotationPartNodeleft = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.left#index"));
    if rotationPartNodeleft ~= nil then
        self.rotationPartleft = {};
        self.rotationPartleft.node = rotationPartNodeleft;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartleft#minRot"));
        self.rotationPartleft.minRot = {};
        self.rotationPartleft.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartleft.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartleft.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.left#maxRot"));
        self.rotationPartleft.maxRot = {};
        self.rotationPartleft.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartleft.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartleft.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartleft.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.left#rotTime"), 2)*1000;
        self.rotationPartleft.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.left#touchRotLimit"), 10));
    end;
	
	-- Ende Left
	
	-- Anfang Right
	
	local rotationPartNoderight = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.right#index"));
    if rotationPartNoderight ~= nil then
        self.rotationPartright = {};
        self.rotationPartright.node = rotationPartNoderight;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartright#minRot"));
        self.rotationPartright.minRot = {};
        self.rotationPartright.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartright.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartright.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.right#maxRot"));
        self.rotationPartright.maxRot = {};
        self.rotationPartright.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartright.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartright.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartright.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.right#rotTime"), 2)*1000;
        self.rotationPartright.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.right#touchRotLimit"), 10));
    end;

	-- Ende Right
	
	-- Anfang Animation Left
	
	local rotationPartNodealeft = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.aleft#index"));
    if rotationPartNodealeft ~= nil then
        self.rotationPartaleft = {};
        self.rotationPartaleft.node = rotationPartNodealeft;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartaleft#minRot"));
        self.rotationPartaleft.minRot = {};
        self.rotationPartaleft.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartaleft.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartaleft.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.aleft#maxRot"));
        self.rotationPartaleft.maxRot = {};
        self.rotationPartaleft.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartaleft.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartaleft.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartaleft.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.aleft#rotTime"), 2)*1000;
        self.rotationPartaleft.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.aleft#touchRotLimit"), 10));
    end;
	
	-- Ende Animation Left
	
	-- Anfang Animation Right
	
	local rotationPartNodearight = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.aright#index"));
    if rotationPartNodearight ~= nil then
        self.rotationPartaright = {};
        self.rotationPartaright.node = rotationPartNodearight;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartaright#minRot"));
        self.rotationPartaright.minRot = {};
        self.rotationPartaright.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartaright.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartaright.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.aright#maxRot"));
        self.rotationPartaright.maxRot = {};
        self.rotationPartaright.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartaright.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartaright.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartaright.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.aright#rotTime"), 2)*1000;
        self.rotationPartaright.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.aright#touchRotLimit"), 10));
    end;

	-- Ende Animation Right
end;
      
function opusk:delete()    
end;

function opusk:mouseEvent(posX, posY, isDown, isUp, button)
end;
	  
function opusk:keyEvent(unicode, sym, modifier, isDown)
	
	-- Anfang Left
	
	if isDown and sym == Input.KEY_x then 
		self.rotationMaxleft = not self.rotationMaxleft;
		self.rotationMaxaleft = not self.rotationMaxaleft;
	end;
	
	-- Ende Left
	
	-- Anfang Right
	
	if isDown and sym == Input.KEY_m then 
		self.rotationMaxright = not self.rotationMaxright;
		self.rotationMaxaright = not self.rotationMaxaright;
	end;
	
	-- Ende Right
	
	-- Anfang Info
	
	-- Ende Info
	
end;

function opusk:update(dt)
	
	-- Anfang Left
	
	if self.rotationPartleft ~= nil then
		local x, y, z = getRotation(self.rotationPartleft.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartleft.maxRot, self.rotationPartleft.minRot, 3, self.rotationPartleft.rotTime, dt, not self.rotationMaxleft);
		setRotation(self.rotationPartleft.node, unpack(newRot));
	end;
	
	-- Ende Left
	
	-- Anfang Right
	
	if self.rotationPartright ~= nil then
		local x, y, z = getRotation(self.rotationPartright.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartright.maxRot, self.rotationPartright.minRot, 3, self.rotationPartright.rotTime, dt, not self.rotationMaxright);
		setRotation(self.rotationPartright.node, unpack(newRot));
   end;

	-- Ende Right
	
	-- Anfang Animation Left
	
	if self.rotationPartaleft ~= nil then
		local x, y, z = getRotation(self.rotationPartaleft.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartaleft.maxRot, self.rotationPartaleft.minRot, 3, self.rotationPartaleft.rotTime, dt, not self.rotationMaxaleft);
		setRotation(self.rotationPartaleft.node, unpack(newRot));
	end;
	
	-- Ende Animation Left
	
	-- Anfang Animation Right
	
	if self.rotationPartaright ~= nil then
		local x, y, z = getRotation(self.rotationPartaright.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartaright.maxRot, self.rotationPartaright.minRot, 3, self.rotationPartaright.rotTime, dt, not self.rotationMaxaright);
		setRotation(self.rotationPartaright.node, unpack(newRot));
	end;

	-- Ende Animation Right
	
end;

function opusk:onLeave()
	
	-- Anfang Left
	
    self.rotationMaxleft = false;
	
	-- Ende Left
	
	-- Anfang Right
	
	self.rotationMaxright = false;
	
	-- Ende Right
	
	-- Anfang Animation Left
	
    self.rotationMaxaleft = false;
	
	-- Ende Animation Left
	
	-- Anfang Animation Right
	
	self.rotationMaxaright = false;
	
	-- Ende Animation Right
end;
function opusk:draw()
	
end;

