worklightEvent = {};
worklightEvent_mt = Class(worklightEvent, Event);

InitEventClass(worklightEvent, "worklightEvent");

worklightEventType = {
	worklights_v = 1,
	worklights_h = 2,
}

function worklightEvent:emptyNew()
    local self = Event:new(worklightEvent_mt);
    self.className="worklightEvent";
    return self;
end;

function worklightEvent:new(object, eventType, data)
    local self = worklightEvent:emptyNew()
    self.object = object;
	self.eventType = eventType;
	self.data = data;
    return self;
end;

function worklightEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.object = networkGetObject(id);
	self.eventType = streamReadUInt8(streamId);
	if self.eventType == worklightEventType.worklights_v then
		 self.data = streamReadBool(streamId);
		 self.object:setWorklightsActive_v(self.data, true);
	-- elseif self.eventType == worklightEventType.worklights_h then
	--	 self.data = streamReadBool(streamId);
	--	 self.object:setWorklightsActive_h(self.data, true);
	end;
	
    if not connection:getIsServer() then
        g_server:broadcastEvent(worklightEvent:new(self.object, self.eventType, self.data), nil, connection, self.object);
    end;
end;

function worklightEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteUInt8(streamId, self.eventType);
	streamWriteBool(streamId, self.data);
end;

function worklightEvent.sendEvent(vehicle, eventType, data)
	if g_server ~= nil then
		g_server:broadcastEvent(worklightEvent:new(vehicle, eventType, data), nil, nil, vehicle);
	else
		g_client:getServerConnection():sendEvent(worklightEvent:new(vehicle, eventType, data));
	end;
end;

