--
-- PFM Z343
-- author: Burner
-- 

Z343 = {};

function Z343.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Cutter, specializations);
end;

function Z343:load(xmlFile)
	self.av = {};
	self.threshingParticleSystems = {};
    local i = 0;
    while true do
        local namei = string.format("vehicle.threshingParticleSystems.threshingParticleSystem(%d)", i);
		local nodei = Utils.indexToObject(self.components, getXMLString(xmlFile, namei .. "#index"));
		if nodei == nil then
			break;
		end;
		local isStatic = Utils.getNoNil(getXMLBool(xmlFile, namei.."#static"), false);
		if isStatic then
			StaticParticleSystem.loadParticleSystem(xmlFile, self.threshingParticleSystems, namei, nodei, false, nil, self.baseDirectory);
		else
			Utils.loadParticleSystem(xmlFile, self.threshingParticleSystems, namei, nodei, false, nil, self.baseDirectory);
		end;
		Utils.setEmittingState(self.threshingParticleSystems,false);
		i = i +1;		
    end;
	
	self.customAttacher = {};
	local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.attacherJoint#minRot"));
	self.customAttacher.minRot = {};
	self.customAttacher.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
	self.customAttacher.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
	self.customAttacher.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
	local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.attacherJoint#maxRot"));
	self.customAttacher.maxRot = {};
	self.customAttacher.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
	self.customAttacher.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
	self.customAttacher.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
	
	self.attacherBackup = {};
end;

function Z343:delete()
end;

function Z343:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Z343:keyEvent(unicode, sym, modifier, isDown)
end;

function Z343:update(dt)
end;

function Z343:updateTick(dt)
end;

function Z343:draw()
end;

function Z343:onAttach(attacherVehicle)
	self.av = attacherVehicle;
	for k, jointDesc in pairs(attacherVehicle.attacherJoints) do
		if jointDesc.jointType == Vehicle.JOINTTYPE_CUTTER then
			self.attacherBackup.minRot = jointDesc.minRot;
			self.attacherBackup.maxRot = jointDesc.maxRot;
			jointDesc.minRot = self.customAttacher.minRot;
			jointDesc.maxRot = self.customAttacher.maxRot;
		end;
	end;
end;

function Z343:onDetach()
	for k, jointDesc in pairs(self.av.attacherJoints) do
		if jointDesc.jointType == Vehicle.JOINTTYPE_CUTTER then
			jointDesc.minRot = self.attacherBackup.minRot;
			jointDesc.maxRot = self.attacherBackup.maxRot;
		end;
	end;
end;

function Z343:onLeave()
end;

function Z343:onDeactivate()
end;