LockCutterAttacherEvent = {};
LockCutterAttacherEvent_mt = Class(LockCutterAttacherEvent, Event);

InitEventClass(LockCutterAttacherEvent, "LockCutterAttacherEvent");

function LockCutterAttacherEvent:emptyNew()
    local self = Event:new(LockCutterAttacherEvent_mt);
    self.className="LockCutterAttacherEvent";
    return self;
end;

function LockCutterAttacherEvent:new(vehicle, attachCutterUpState)
    local self = LockCutterAttacherEvent:emptyNew()
    self.vehicle = vehicle;
	self.attachCutterUpState = attachCutterUpState;
    return self;
end;

function LockCutterAttacherEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.attachCutterUpState = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function LockCutterAttacherEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.attachCutterUpState);
end;

function LockCutterAttacherEvent:run(connection)   
	self.vehicle:lockCutterAttacher(self.attachCutterUpState, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(LockCutterAttacherEvent:new(self.vehicle, self.attachCutterUpState), nil, connection, self.vehicle);
    end;
end;

function LockCutterAttacherEvent.sendEvent(vehicle, attachCutterUpState, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(LockCutterAttacherEvent:new(vehicle, attachCutterUpState), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(LockCutterAttacherEvent:new(vehicle, attachCutterUpState));
		end;
	end;
end;