﻿--
-- Peterbilt 281 Duel Animation
-- @Date: 21-04-2014	v1.0
--
-- Kamerabewegung "sich aus dem Fenster lehnen"
-- animierter Bremshebel
-- animierte Gangschaltung
--
-- @Author  Bayrisch-Michl
-- 
-- Copyright (C) Bayrisch-Michl, All Rights Reserved.
-- Do not edit without my permission
--
peterbilt281duelAnimations = {};

function peterbilt281duelAnimations.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;
function peterbilt281duelAnimations:load(xmlFile)
	-- Moveable Indoor-Camera --
	self.movableCamera = {};
	self.movableCamera = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.PeterbiltAnimations.movableCamera#index"));
	self.CameraPosX = 0;
	self.indoorCamera = {};
	self.indoorCamera = 	Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.PeterbiltAnimations.indoorCamera#index"));
	self.CamRotBeginToMove =  math.rad(Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.PeterbiltAnimations.indoorCamera#RotBeginToMove")));
	self.CamTransMoveMax = 	Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.PeterbiltAnimations.indoorCamera#TransMoveMax"));
	self.RotMaxLookBehind = math.rad(Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.PeterbiltAnimations.indoorCamera#RotMaxLookBehind")));
	
	-- Handbrake-Lever / Handbremshebel
	self.Handbremshebel = {};
	self.Handbremshebel = 	Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.PeterbiltAnimations.Handbremshebel#index"));
	self.rotStart = 		Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.PeterbiltAnimations.Handbremshebel#rotStart"));
	self.rotStop = 			Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.PeterbiltAnimations.Handbremshebel#rotStop"));
	self.moveSpeed = 		Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.PeterbiltAnimations.Handbremshebel#moveSpeed"));
	self.currentRot = self.rotStart;
	self.HandbrakeEnd = false; 
	self.activeProcess = false;
	
	-- Gangschaltung / Gearlever
	self.Ganghebel = {};
	self.Ganghebel = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.PeterbiltAnimations.Ganghebel#index"));
	if self.Ganghebel ~= nil then
		self.ForwRot =  math.rad(Utils.getNoNil(getXMLFloat(xmlFile,  "vehicle.PeterbiltAnimations.Ganghebel#ForwRot")));
		self.BackwRot = math.rad(Utils.getNoNil(getXMLFloat(xmlFile,  "vehicle.PeterbiltAnimations.Ganghebel#BackwRot")));
		self.RightRot = math.rad(Utils.getNoNil(getXMLFloat(xmlFile,  "vehicle.PeterbiltAnimations.Ganghebel#RightRot")));
		self.LeftRot =  math.rad(Utils.getNoNil(getXMLFloat(xmlFile,  "vehicle.PeterbiltAnimations.Ganghebel#LeftRot")));
		self.GangMoveSpeed = 	 Utils.getNoNil(getXMLFloat(xmlFile,  "vehicle.PeterbiltAnimations.Ganghebel#moveSpeed"))/10000;
		self.NEUTRALSTELLUNG = false; self.Forwards = false; self.Gang1 = false; self.Gang2 = false; self.Gang3 = false; self.Gang4 = false; self.Gang3Mitte = false; self.Gang3RMitte = false; self.Gang3Rechts = false; self.GangLinks = false; self.GangRechts = false; self.Gang3RLinks = false; self.Backwards = false;	self.LEVEL1 = false; self.LEVEL2 = false; self.LEVEL3 = false; self.LEVEL1R = false; self.LEVEL2R = false;	
	end;
end;

function peterbilt281duelAnimations:delete()
end;
function peterbilt281duelAnimations:readStream(streamId, connection)
end;
function peterbilt281duelAnimations:writeStream(streamId, connection)
end;
function peterbilt281duelAnimations:mouseEvent(posX, posY, isDown, isUp, button)
end;
function peterbilt281duelAnimations:keyEvent(unicode, sym, modifier, isDown)
end;

function peterbilt281duelAnimations:update(dt)
     if self:getIsActive() then
	 
-- GANGSCHALTUNG ---------------------------------------------------------------
	 local Gx, Gy, Gz = getRotation(self.Ganghebel);
	
	---------- HOCHSCHALTEN -------------------------------------------
			if self.lastAcceleration > 0 and self.motor.speedLevel < 4 and self.Backwards == false and self.Gang4 == false then
			self.Forwards = true;
			local TasteW = self.lastAcceleration > 0 and self.motor.speedLevel == 0;
			local kmh = self.lastSpeed*self.speedDisplayScale*3600;
			
				-- GANG 1 --------------------
				if (self.LEVEL1 or self.motor.speedLevel == 1 or self.motor.speedLevel == 2 or self.motor.speedLevel == 3 or TasteW) and self.Gang1 == false then
					self.LEVEL1 = true;
					Gx = Gx + (dt * self.GangMoveSpeed); 	-- Gang nach vorne
						if Gx >= self.ForwRot then
							Gx = self.ForwRot;
							self.Gang1 = true;
							self.LEVEL1 = false;
							if self.motor.speedLevel == 2 or self.motor.speedLevel == 3 then self.LEVEL2 = true; end;
						end;		
				-- GANG 2 --------------------
				elseif kmh > 30 and (self.LEVEL2 or self.motor.speedLevel == 2 or self.motor.speedLevel == 3 or TasteW) and self.Gang1 == true and self.Gang2 == false then
					self.LEVEL2 = true;
					Gx = Gx - (dt * self.GangMoveSpeed);	-- Gang nach hinten
						if Gx <= self.BackwRot then
							Gx = self.BackwRot;
							self.Gang2 = true;
							self.LEVEL2 = false;
							if self.motor.speedLevel == 3 then self.LEVEL3 = true; end;
						end;
				-- GANG 3 --------------------
				elseif kmh > 60 and (self.LEVEL3 or self.motor.speedLevel == 3 or TasteW) and self.Gang2 == true and self.Gang3 == false then
					self.LEVEL3 = true;
					if self.Gang3Mitte == false then
							Gx = Gx + (dt * self.GangMoveSpeed);	-- Gang in Neutralstellung
								if Gx >= 0 then
									Gx = 0;
									self.Gang3Mitte = true;
								end;
					elseif  self.Gang3Mitte == true and self.Gang3Rechts == false then
							Gz = Gz + (dt * self.GangMoveSpeed);	-- Gang nach rechts
								if Gz >= self.RightRot then
									Gz = self.RightRot;
									self.Gang3Rechts = true;
								end;
					elseif  self.Gang3Rechts == true then	
							Gx = Gx + (dt * self.GangMoveSpeed);	-- Gang nach vorne
								if Gx >= self.ForwRot then
									Gx = self.ForwRot;
									self.Gang3 = true;
									self.Gang3Mitte = false;
									self.Gang3Rechts = false;
									self.LEVEL3 = false;
									if self.motor.speedLevel == 2 or self.motor.speedLevel == 1 then self.LEVEL2R = true; end;
								end;
					end;
						
	---------- RUNTERSCHALTEN -------------------------------------------
				-- GANG 2 --------------------	
				elseif (self.LEVEL2R or self.motor.speedLevel == 2 or self.motor.speedLevel == 1) and self.Gang3 == true then
				self.LEVEL2R = true;
					if self.Gang3RMitte == false then
						Gx = Gx - (dt * self.GangMoveSpeed);	-- Gang nach hinten
							if Gx <= 0 then
								Gx = 0;
								self.Gang3RMitte = true;
							end;
					elseif self.Gang3RMitte == true and self.Gang3RLinks == false then
						Gz = Gz - (dt * self.GangMoveSpeed);	-- Gang nach links
							if Gz <= 0 then
								Gz = 0;
								self.Gang3RLinks = true;
							end;
					elseif self.Gang3RLinks == true then
						Gx = Gx - (dt * self.GangMoveSpeed);	-- Gang nach hinten
							if Gx <= self.BackwRot then
								Gx = self.BackwRot;
								self.Gang3 = false;
								self.Gang3RMitte = false;
								self.Gang3RLinks = false;
								self.LEVEL2R = false;
								if self.motor.speedLevel == 1 then self.LEVEL1R = true; end;
							end;
					end;
				-- GANG 1 --------------------
				elseif (self.LEVEL1R or self.motor.speedLevel == 1) and self.Gang2 == true then
					self.LEVEL1R = true;
					Gx = Gx + (dt * self.GangMoveSpeed);	-- Gang nach vorne
						if Gx >= self.ForwRot then
							Gx = self.ForwRot;
							self.Gang2 = false;
							self.LEVEL1R = false;
						end;
				end;
			
	---------- GANG 4 - KRIECHGANG -----------------------------------	
			elseif self.lastAcceleration > 0 and self.motor.speedLevel == 4 and self.Backwards == false and self.Forwards == false then
				self.Gang4 = true;
				if self.NEUTRALSTELLUNG == true then
						if self.GangRechts == false then
							Gz = Gz + (dt * self.GangMoveSpeed);	-- Gang nach links
								if Gz >= self.RightRot then
									Gz = self.RightRot;
									self.GangRechts = true;
								end;
						elseif self.GangRechts == true then
							Gx = Gx - (dt * self.GangMoveSpeed);	-- Gang nach hinten
								if Gx <= self.BackwRot then
									Gx = self.BackwRot;
								end;
						end;
				else self.NEUTRALSTELLUNG = false;
				end;
			
	---------- RÜCKWÄRTSGANG -------------------------------------------	
			elseif self.lastAcceleration < 0 and self.Forwards == false and self.Gang4 == false then
				self.Backwards = true;
				if self.NEUTRALSTELLUNG == true then
						if self.GangLinks == false then
							Gz = Gz - (dt * self.GangMoveSpeed);	-- Gang nach links
								if Gz <= self.LeftRot then
									Gz = self.LeftRot;
									self.GangLinks = true;
								end;
						elseif self.GangLinks == true then
							Gx = Gx + (dt * self.GangMoveSpeed);	-- Gang nach vorne
								if Gx >= self.ForwRot then
									Gx = self.ForwRot;
								end;
						end;
				else self.NEUTRALSTELLUNG = false;
				end;
					
	---------- NEUTRALSTELLUNG -------------------------------------------
			else
					if Gx > 0 then
						Gx = Gx - (dt * self.GangMoveSpeed);	-- Gang nach hinten
								if Gx <= 0 then
									Gx = 0;
								end;
					elseif Gx < 0 then
						Gx = Gx + (dt * self.GangMoveSpeed);	-- Gang nach hinten
								if Gx >= 0 then
									Gx = 0;
								end;
					elseif Gx == 0 and Gz > 0 then
						Gz = Gz - (dt * self.GangMoveSpeed);	-- Gang nach links
								if Gz <= 0 then
									Gz = 0;
								end;
					elseif Gx == 0 and Gz < 0 then
						Gz = Gz + (dt * self.GangMoveSpeed);	-- Gang nach rechts
								if Gz >= 0 then
									Gz = 0;
								end;
					elseif Gx == 0 and Gz == 0 then
						self.NEUTRALSTELLUNG = true; self.Forwards = false; self.Gang1 = false; self.Gang2 = false; self.Gang3 = false; self.Gang4 = false; self.Gang3Mitte = false; self.Gang3RMitte = false; self.Gang3Rechts = false; self.GangLinks = false; self.GangRechts = false; self.Gang3RLinks = false; self.Backwards = false; self.LEVEL1 = false; self.LEVEL2 = false; self.LEVEL3 = false; self.LEVEL1R = false; self.LEVEL2R = false;
					end;
			end;

		setRotation(self.Ganghebel, Gx, Gy, Gz);
	 
-- MOVEABLE INDOORCAMERA---------------------------------------------------------
		if self.indoorCamera ~= nil then
			local rotX, rotY, rotZ = getRotation(self.indoorCamera);
			if rotY > self.CamRotBeginToMove then
				if rotY >= self.RotMaxLookBehind then
					rotY = self.RotMaxLookBehind;
				end;	
				self.CameraPosX = self.CameraPosX + 0.04;
					if self.CameraPosX >= self.CamTransMoveMax then
						self.CameraPosX = self.CamTransMoveMax;
					end;
			else
				self.CameraPosX = self.CameraPosX - 0.04;
					if self.CameraPosX <= 0 then
						self.CameraPosX = 0;
					end;
					if rotY < 0 then	-- Blickwinkel Indoor begrenzen
						rotY = 0;
					end;
			end;
			setRotation(self.indoorCamera, rotX, rotY, rotZ);
						
			if self.movableCamera ~= nil then
				setTranslation(self.movableCamera, self.CameraPosX, 0, 0);
			end;
		end;	
		
-- HANDBREMSHEBEL-------------------------------------------------------------------
		if self.Handbremshebel ~= nil then
			local x, y, z = getRotation(self.Handbremshebel);
			
			if InputBinding.hasEvent(InputBinding.handbrake) or self.activeProcess == true then
				if self.HandbrakeEnd == false then
					self.activeProcess = true;
		
					self.currentRot = self.currentRot + (dt * self.moveSpeed);
						if self.currentRot >= self.rotStop then
							self.currentRot = self.rotStop;
							if not InputBinding.hasEvent(InputBinding.handbrake) then
								self.HandbrakeEnd = true;
								self.activeProcess = false;
							end;
						end;
				end;
			end;	
				
			if InputBinding.hasEvent(InputBinding.handbrake) or self.activeProcess == true then
				if self.HandbrakeEnd == true then
					self.activeProcess = true;
					
					self.currentRot = self.currentRot - (dt * self.moveSpeed);
						if self.currentRot <= self.rotStart then
						self.currentRot = self.rotStart;
							if not InputBinding.hasEvent(InputBinding.handbrake) then
								self.HandbrakeEnd = false;
								self.activeProcess = false;
							end;	
						end;		
				end;
			end;
			
			setRotation(self.Handbremshebel, x, Utils.degToRad(self.currentRot), z);
		end;
	end;
	
end;

function peterbilt281duelAnimations:updateTick(dt)
end;
function peterbilt281duelAnimations:draw()
end;
function peterbilt281duelAnimations:onEnter()
end;
function peterbilt281duelAnimations:onLeave()
end;