--
-- PdaPlugin_Silos
--
-- @author  Decker_MMIV - fs-uk.com, forum.farming-simulator.com, modhoster.com
-- @date    2013-04-04
--
-- @history
--  2013-April
--      v0.01   - Initial experiment
--      v0.04   - Included with PdaMod.
--  2013-June
--      v0.07   - Farm silo amounts in two columns.
--  2014-May
--      v0.10   - Changed to use modPDAMOD.registerPlugin(...)
--  2014-June
--      v0.11   - Due to the NON-deterministic way that mods are loaded in multiplayer, the modPDAMOD.registerPlugin(...)
--                is replaced in favor of a hopefully more robust "create object modPDAMODplugins, and add yourself to it" method.
--      v0.12   - Reduced the number of different "farm silos", by excluding those that does not have a farm tip-trigger.
--      v0.14   - Minor tweaks.
--      2.0.1   - Using http://semver.org/
--

--[[
Voidheartd - http://fs-uk.com/forum/index.php?topic=134790.msg1017335#msg1017335
I've noticed it doesn't display the slurry at the cows or the BGA nor the manure at the cows. It does have a listing of slurry and manure at 0 on the 3rd silo page. This is on Westbridge Hills so maybe that it why.

It is working with the forage storage mod for Westbridge though.

Also wondering if it's possible to somehow hide the unnecessary listings, like grass (which is not the one for the forage mod), hay, chaff, milk, fuel, etc.

--]]

PdaPlugin_Silos = {}
--
local modItem = ModsUtil.findModItemByModName(g_currentModName);
PdaPlugin_Silos.version = (modItem and modItem.version) and modItem.version or "?.?.?";
--
PdaPlugin_Silos.isInitialized = false;
PdaPlugin_Silos.maxLines = 10;
PdaPlugin_Silos.bunkerSilos = {};

-- Register this PDAMod plugin
getfenv(0)["modPDAMODplugins"] = getfenv(0)["modPDAMODplugins"] or {}
table.insert(getfenv(0)["modPDAMODplugins"], PdaPlugin_Silos)
--


function PdaPlugin_Silos:deleteMap()
    PdaPlugin_Silos.isInitialized = false;
    PdaPlugin_Silos.bunkerSilos = {};
end;

function PdaPlugin_Silos.initialize(self, initStep)
    if initStep == 2 then
        local numWidth = getTextWidth(g_currentMission.missionPDA.pdaFontSize, "88888888 ");
        
        local pda = g_currentMission.missionPDA;
        
        PdaPlugin_Silos.pdaCols = {}
        PdaPlugin_Silos.pdaCols[1] = pda.pdaX + numWidth;
        PdaPlugin_Silos.pdaCols[2] = (pda.pdaX + pda.pdaWidth) / 2 + numWidth;
        --PdaPlugin_Silos.pdaCol = pda.pdaX + numWidth;
        PdaPlugin_Silos.pdaSpacing = getTextWidth(pda.pdaFontSize, " ")/2;
        
        PdaPlugin_Silos.locateFarmSilosByTipTriggers(self);
        for idx=1, table.getn(self.siloFillTypes), (PdaPlugin_Silos.maxLines*2)+1 do
            modPDAMOD.registerPage("silosFarmBunker", nil, PdaPlugin_Silos.subPageDraw_FarmSilos, g_currentMission.missionPDA, idx, nil, nil, nil, 0);
        end;
        
        --
        for k,v in ipairs(g_currentMission.onCreateLoadedObjects) do
            if v.bunkerSiloDirtyFlag ~= nil then
                table.insert(PdaPlugin_Silos.bunkerSilos, v);
            end;
        end;
        for idx=1,table.getn(PdaPlugin_Silos.bunkerSilos),PdaPlugin_Silos.maxLines+1 do
            modPDAMOD.registerPage("silosFarmBunker", nil, PdaPlugin_Silos.subPageDraw_BunkerSilos, g_currentMission.missionPDA, idx, nil, nil, nil, 0);
        end;
    end
end;

--
function PdaPlugin_Silos.locateFarmSilosByTipTriggers(self)
    local siloFillTypes = {}
    for _,tipTrigger in pairs(g_currentMission.tipTriggers) do
        if tipTrigger.isEnabled and tipTrigger.isFarmTrigger
        and (tipTrigger.isExtendedTrigger == nil) -- AlternativeTipTrigger is excluded.
        then
            for fillType,accepted in pairs(tipTrigger.acceptedFillTypes) do
                siloFillTypes[fillType] = siloFillTypes[fillType] or accepted
            end
        end
    end
    --
    self.siloFillTypes = {}
    for fillType,accepted in pairs(siloFillTypes) do
        if accepted then
            table.insert(self.siloFillTypes, fillType)
        end
    end
    table.sort(self.siloFillTypes, function(a,b)
        local aName = Fillable.fillTypeIndexToDesc[a].nameI18N or Fillable.fillTypeIndexToDesc[a].name
        local bName = Fillable.fillTypeIndexToDesc[b].nameI18N or Fillable.fillTypeIndexToDesc[b].name
        return (aName):upper() < (bName):upper();
    end);
end

--
function PdaPlugin_Silos.subPageDraw_FarmSilos(self, parm, origMissionPdaDrawFunc)
    -- Note: 'self' is in context of the g_currentMission.missionPDA object.

    --
    self.hudPDABackgroundOverlay:render()
    --
    setTextBold(false);
    setTextColor(1,1,1,1);
    
    local row = 0;
    local col = 1;
    for idx=parm,table.getn(PdaPlugin_Silos.siloFillTypes) do
        local fillType = PdaPlugin_Silos.siloFillTypes[idx];
        local fillDesc = Fillable.fillTypeIndexToDesc[fillType];
        local farmSiloAmount = g_currentMission:getSiloAmount(fillType);
    
        setTextAlignment(RenderText.ALIGN_RIGHT);
        renderText(PdaPlugin_Silos.pdaCols[col] - PdaPlugin_Silos.pdaSpacing, self.pdaHeadRow - self.pdaRowSpacing * row, self.pdaFontSize, string.format("%d", g_i18n:getFluid(farmSiloAmount)));
    
        setTextAlignment(RenderText.ALIGN_LEFT);
        renderText(PdaPlugin_Silos.pdaCols[col] + PdaPlugin_Silos.pdaSpacing, self.pdaHeadRow - self.pdaRowSpacing * row, self.pdaFontSize, fillDesc.nameI18N);
        
        row = row + 1;
        if row == PdaPlugin_Silos.maxLines then
          col = col + 1
          row = 0
        end
        if col > 2 then
            break;
        end;
    end;
    --
    self.hudPDAFrameOverlay:render()
    --
    modPDAMOD.drawTitle(g_i18n:getText("FarmSilos"));
end

--
function PdaPlugin_Silos.subPageDraw_BunkerSilos(self, parm, origMissionPdaDrawFunc)
    -- Note: 'self' is in context of the g_currentMission.missionPDA object.

    --
    self.hudPDABackgroundOverlay:render()
    --
    setTextAlignment(RenderText.ALIGN_LEFT);
    setTextBold(false);
    setTextColor(1,1,1,1);
    
    local row = 0;
    for idx=parm,table.getn(PdaPlugin_Silos.bunkerSilos) do
        local bSilo = PdaPlugin_Silos.bunkerSilos[idx];

        local txt = string.format("%2d: ", idx);
        
        if bSilo.state == BunkerSilo.STATE_FILL then
            txt = txt .. g_i18n:getText("fill_level").." "..math.floor(bSilo.fillLevel).." ("..math.floor(100*bSilo.fillLevel/bSilo.capacity).."%)";
            if bSilo.fillLevel > 0 then
                local compactedPercentage = math.min(bSilo.compactedFillLevel/bSilo.fillLevel, 1);
                txt = txt ..", ".. g_i18n:getText("compacting").." "..math.floor(100*compactedPercentage).."%";
            end;
        elseif bSilo.state == BunkerSilo.STATE_CLOSED then
            txt = txt .. g_i18n:getText("fermenting").." "..math.floor(100*bSilo.fermentingTime/bSilo.fermentingDuration).."%";
        elseif bSilo.state == BunkerSilo.STATE_DRAIN then
            txt = txt .. g_i18n:getText("BunkerSilageLevel").." "..math.floor(bSilo.fillLevel).." ("..math.floor(100*bSilo.fillLevel/bSilo.capacity).."%)";
        else
            txt = txt .. "n/a";
        end;
    
        renderText(self.pdaX, self.pdaHeadRow - self.pdaRowSpacing * row, self.pdaFontSize, txt);
        
        row = row + 1;
        if row >= PdaPlugin_Silos.maxLines then
            break;
        end;
    end;
    --
    self.hudPDAFrameOverlay:render()
    --
    modPDAMOD.drawTitle(g_i18n:getText("BunkerSilos"));
end


print(string.format("Script loaded: PdaPlugin_SilosFarmBunker.LUA (v%s)", PdaPlugin_Silos.version));
