 SetIsFillingEvent = {};
  SetIsFillingEvent_mt = Class(SetIsFillingEvent, Event);
  
  InitEventClass(SetIsFillingEvent, "SetIsFillingEvent");
  
  function SetIsFillingEvent:emptyNew()
     local self = Event:new(SetIsFillingEvent_mt);
      self.className="SetIsFillingEvent";
      return self;
  end;
  
  function SetIsFillingEvent:new(object, isTankFilling)
      local self = SetIsFillingEvent:emptyNew()
      self.object = object;
      self.isTankFilling = isTankFilling;
      return self;
  end;
  
  function SetIsFillingEvent:readStream(streamId, connection)
      local id = streamReadInt32(streamId);
      self.isTankFilling = streamReadBool(streamId);
      self.object = networkGetObject(id);
      self:run(connection);
  end;
  
  function SetIsFillingEvent:writeStream(streamId, connection)
      streamWriteInt32(streamId, networkGetObjectId(self.object));
      streamWriteBool(streamId, self.isTankFilling);
  end;
  
  function SetIsFillingEvent:run(connection)
      if not connection:getIsServer() then
         g_server:broadcastEvent(self, false, connection, self.object);
      end;
      self.object:setIsTankFilling(self.isTankFilling, true);
  end;
  
  function SetIsFillingEvent.sendEvent(vehicle, isTankFilling, noEventSend)
      if isTankFilling ~= vehicle.isFilling then
          if noEventSend == nil or noEventSend == false then
              if g_server ~= nil then
                  g_server:broadcastEvent(SetIsFillingEvent:new(vehicle, isTankFilling), nil, nil, vehicle);
              else
                  g_client:getServerConnection():sendEvent(SetIsFillingEvent:new(vehicle, isTankFilling));
              end;
          end;
      end;
  end;
  
   SetIsUnloadingEvent = {};
  SetIsUnloadingEvent_mt = Class(SetIsUnloadingEvent, Event);
  
  InitEventClass(SetIsUnloadingEvent, "SetIsUnloadingEvent");
  
  function SetIsUnloadingEvent:emptyNew()
     local self = Event:new(SetIsUnloadingEvent_mt);
      self.className="SetIsUnloadingEvent";
      return self;
  end;
  
  function SetIsUnloadingEvent:new(object, isTankUnloading)
      local self = SetIsUnloadingEvent:emptyNew()
      self.object = object;
      self.isTankUnloading = isTankUnloading;
      return self;
  end;
  
  function SetIsUnloadingEvent:readStream(streamId, connection)
      local id = streamReadInt32(streamId);
      self.isTankUnloading = streamReadBool(streamId);
      self.object = networkGetObject(id);
      self:run(connection);
  end;
  
  function SetIsUnloadingEvent:writeStream(streamId, connection)
      streamWriteInt32(streamId, networkGetObjectId(self.object));
      streamWriteBool(streamId, self.isTankUnloading);
  end;
  
  function SetIsUnloadingEvent:run(connection)
      if not connection:getIsServer() then
         g_server:broadcastEvent(self, false, connection, self.object);
      end;
      self.object:setIsTankUnloading(self.isTankUnloading, true);
  end;
  
  function SetIsUnloadingEvent.sendEvent(vehicle, isTankUnloading, noEventSend)
      if isTankUnloading ~= vehicle.isFilling then
          if noEventSend == nil or noEventSend == false then
              if g_server ~= nil then
                  g_server:broadcastEvent(SetIsUnloadingEvent:new(vehicle, isTankUnloading), nil, nil, vehicle);
              else
                  g_client:getServerConnection():sendEvent(SetIsUnloadingEvent:new(vehicle, isTankUnloading));
              end;
          end;
      end;
  end;