-- by "Marhu" 
-- v 1.1
-- Date: 16.05.2013
-- "Alle Felder Bei Einem Trigger Kaufen"

-- Trigger --
FieldBuyHud = {};

local FieldBuyHud_mt = Class(FieldBuyHud);

function FieldBuyHud.onCreate(id)
	g_currentMission:addUpdateable(FieldBuyHud:new(id));
	--print("created FieldBuyHud, id: ", id);
end;

function FieldBuyHud:new(nodeId)
  
	local instance = {};
    setmetatable(instance, FieldBuyHud_mt);
  
	instance.triggerId = nodeId;
	
	addTrigger(nodeId, "BuyTriggerCallback", instance);
	
	instance.Symbol = getChildAt(nodeId, 0);
	
	FieldBuyHudUI.CanSell = getUserAttribute(nodeId, "canSell");
	FieldBuyHudUI.SellFac = Utils.getNoNil(getUserAttribute(nodeId, "SellFactor"),0.5);
	
	instance.isEnabled = true;
	
	return instance;
end;

function FieldBuyHud:delete()
	
	removeTrigger(self.triggerId);
	
end;

function FieldBuyHud:update(dt)
	
	rotate(self.Symbol, 0, 0.005 * dt, 0);
	
	if not g_currentMission.controlPlayer then
		self.changeAllowed = nil;
	end
	
	if self.changeAllowed then
		FieldBuyHudUI.DrawUI = true;
	else
		FieldBuyHudUI.DrawUI = false;
	end;
		
end;

function FieldBuyHud:BuyTriggerCallback(triggerId, otherId, onEnter, onLeave, onStay)
	
	if (g_currentMission.controlPlayer and g_currentMission.player and otherId == g_currentMission.player.rootNode) then
		if (onEnter) then 
            self.changeAllowed = true;
        elseif (onLeave) then
            self.changeAllowed = false;
        end;
	end;
	
 end;
   
g_onCreateUtil.addOnCreateFunction("FieldBuyHud", FieldBuyHud.onCreate);
 
-- UI -- 
FieldBuyHudUI = {};

function FieldBuyHudUI:loadMap(name)
	
	self.SellFac = self.SellFac or 0.5;
	
	self.Frame = {};
	self.Frame.w = 1;--0.3
	self.Frame.h = 0.5;--0.2	
	self.Frame.x = 0.5 - (self.Frame.w/2);
	self.Frame.y = 0.5 - (self.Frame.h/2);
	self.Frame.a = 1;
	self.Frame.rl = 0.07;
	self.Frame.rt = 0.05;
	
	self.Line = 0;
	self.maxLine = g_currentMission.fieldDefinitionBase.numberOfFields;

	self.Frame.overlay = createImageOverlay("dataS2/menu/background02.png");
	
	self.Btns = {};
	local width, height = .09, .04;
	local x, y = self.Frame.x + self.Frame.w - (width * 2) , self.Frame.y + self.Frame.h - self.Frame.rt - height;
	local numBtns = math.floor((self.Frame.h - (self.Frame.rt*2)) / height);
	self.maxLine = self.maxLine - numBtns;
	for i = 1, numBtns do
		local overlay = Overlay:new("btn"..i, "dataS2/menu/button_normal.png", x, y, width, height);
		local highlight = Overlay:new("btn"..i.."_highlight", "dataS2/menu/button_focused.png", x, y, width, height);
		local pressed = Overlay:new("btn"..i.."_pressed", "dataS2/menu/button_pressed.png", x, y, width, height);
		table.insert(self.Btns, {overlay = overlay, highlight = highlight, pressed = pressed, function_to_call = FieldBuyHudUI.ButtonOnClick, x = x, x2 = (x + width), y = y, y2 = (y + height), cw = width/2, ch = height/2});
		y = y - height;
	end;
	
	self.Scroll = {};
	width, height = .03, .03;
	x, y = self.Frame.x + (self.Frame.w/2) - (width / 2), self.Frame.y + self.Frame.h - self.Frame.rt - height;
	local rw2 = y;
	local overlay = Overlay:new("scrollUp", "dataS2/menu/list_button_up_n.png", x, y, width, height);
	local highlight = Overlay:new("scrollUp_highlight", "dataS2/menu/list_button_up_f.png", x, y, width, height);
	local pressed = Overlay:new("scrollUp_pressed", "dataS2/menu/list_button_up_n.png", x, y, width, height);
	table.insert(self.Scroll, {overlay = overlay, highlight = highlight, pressed = pressed, x = x, x2 = (x + width), y = y, y2 = (y + height), cw = width/2, ch = height/2});
	
	y = self.Frame.y + self.Frame.rt;
	local overlay = Overlay:new("scrolldown", "dataS2/menu/list_button_down_n.png", x, y, width, height);
	local highlight = Overlay:new("scrolldown_highlight", "dataS2/menu/list_button_down_f.png", x, y, width, height);
	local pressed = Overlay:new("scrolldown_pressed", "dataS2/menu/list_button_down_n.png", x, y, width, height);
	table.insert(self.Scroll, {overlay = overlay, highlight = highlight, pressed = pressed, x = x, x2 = (x + width), y = y, y2 = (y + height), cw = width/2, ch = height/2});
	
	width, height = .02, .04;
	x, y = self.Frame.x + (self.Frame.w/2) - (width / 2), self.Frame.y + self.Frame.rt + .03;
	local overlay = createImageOverlay("dataS2/menu/list_slider_n.png"); 
	table.insert(self.Scroll, {overlay = overlay, highlight = overlay, pressed = overlay, x = x, x2 = (x + width), y = rw2-height, y2 = (y + height), w = width, h = height, rw1 = y, rw2 = rw2});
	
	self.MapOl = {};
	self.MapOl.mapWidth = (self.Frame.w/2) - (self.Frame.rl*2);
	self.MapOl.mapHeight = self.Frame.h - (self.Frame.rt*2);
	self.MapOl.mapPosX = self.Frame.x + (self.Frame.w/4);
	self.MapOl.mapPosY = self.Frame.y + (self.Frame.h/2);
	self.MapOl.mapTransp = 1;
	self.MapOl.mapZoom = 1;
	
	self.FeldNumTh = 0.015;
	
end;

function FieldBuyHudUI:deleteMap()
end;

function FieldBuyHudUI:mouseEvent(posX, posY, isDown, isUp, button)
	
	if self.DrawUI then
		local UpdateMover = false;
		if posX > self.Frame.x and posX < self.Frame.x + self.Frame.w  and posY > self.Frame.y and posY < self.Frame.y + self.Frame.h then
			if button == Input.MOUSE_BUTTON_WHEEL_UP then
				self.Line = self.Line - 1;
				UpdateMover = true;
			elseif button == Input.MOUSE_BUTTON_WHEEL_DOWN then
				self.Line = self.Line + 1;
				UpdateMover = true;
			end
			if self.Line > self.maxLine then self.Line = self.maxLine; end;
			if self.Line < 0 then self.Line = 0; end;
		end
		
		for i = 1, table.getn(self.Scroll)-1 do
			
			self.Scroll[i].MOver = nil;
			
			if posX > self.Scroll[i].x and posX < self.Scroll[i].x2 and posY > self.Scroll[i].y and posY < self.Scroll[i].y2 then
				self.Scroll[i].MOver = true;
				if isDown and button == 1 then
					self.Scroll[i].MDown = true;
				elseif isUp and button == 1 and self.Scroll[i].MDown then
					self.Scroll[i].MDown = false;
					self.Line = self.Line + (-3+i*2);
					UpdateMover = true;
				end;
				if self.Line > self.maxLine then self.Line = self.maxLine; end;
				if self.Line < 0 then self.Line = 0; end;
			end;
			
			if self.Scroll[i].MOver == nil then
				self.Scroll[i].MDown = false;
			end;
		end;
		
		local scroll = self.Scroll[table.getn(self.Scroll)];
		scroll.MOver = nil;
		if posX > scroll.x and posX < scroll.x + scroll.h and posY > scroll.y and posY < scroll.y + scroll.h then
			scroll.MOver = true	;
			if button == 1 then
				if isDown then
					scroll.MouseMove = true;
				elseif isUp then
					scroll.MouseMove = false;
				end;
			end;
		end;
		
		for i = 1, table.getn(self.Btns) do
			self.Btns[i].MOver = nil;
			
			if posX > self.Btns[i].x and posX < self.Btns[i].x2 and posY > self.Btns[i].y and posY < self.Btns[i].y2 then
				self.Btns[i].MOver = true;
				if isDown and button == 1 then
					self.Btns[i].MDown = true;
				elseif isUp and button == 1 and self.Btns[i].MDown then
					self.Btns[i].MDown = false;
					self.Btns[i].function_to_call(self,i);
				end;
			end;
			
			if self.Btns[i].MOver == nil then
				self.Btns[i].MDown = false;
			end;
		end;
		
		if self.Scroll[3].MouseMove and self.OldMouseY then
			if button == 1 and isUp then
				self.Scroll[3].MouseMove = false;
			else
				self.Scroll[3].y = self.Scroll[3].y + (posY - self.OldMouseY);
				if self.Scroll[3].y < self.Scroll[3].rw1 then
					self.Scroll[3].y = self.Scroll[3].rw1;
				elseif self.Scroll[3].y + self.Scroll[3].h > self.Scroll[3].rw2 then
					self.Scroll[3].y = self.Scroll[3].rw2 - self.Scroll[3].h;
				end;
				local Pos = self.Scroll[3].y - self.Scroll[3].rw1;
				local ScalaWidth = self.Scroll[3].rw2 - self.Scroll[3].h - self.Scroll[3].rw1;
				self.Line = math.floor(Utils.lerp(0, self.maxLine, 1 - (Pos / ScalaWidth)));
			end;
		elseif UpdateMover then
			local ScalaWidth = self.Scroll[3].rw2 - self.Scroll[3].h - self.Scroll[3].rw1;
			self.Scroll[3].y = self.Scroll[3].rw1 + (ScalaWidth * (1 - (self.Line/self.maxLine)));
		end;
	end;
	
	self.OldMouseY = posY;
	
end;

function FieldBuyHudUI:keyEvent(unicode, sym, modifier, isDown)
end;


function FieldBuyHudUI:update(dt)
end;

local function showHeatTxt(x,y,t)
	th = 0.024;
	y = y - (th*1.5);
	setTextBold(true);
	setTextAlignment(RenderText.ALIGN_CENTER);
	setTextColor(0, 0, 0, 0.75);
	renderText(x,y-0.0025,th,t);
	setTextColor(1, 1, 1, 1);
	renderText(x,y,th,t);
	setTextBold(false);
end;
local function showTxt(x,y,t,c)
	setTextColor(0, 0, 0, 0.75);
	renderText(x,y-0.0025,0.021,t);
	if c then
		setTextColor(unpack(c));
	else
		setTextColor(1, 1, 1, 1);
	end
	renderText(x,y,0.021,t);
end;
local function showBtnTxt(x,y,t,disable)
	if not disable then disable = (g_server == nil); end;
	if disable then
		setTextColor(1, 1, 1, 0);
	else
		setTextColor(1, 1, 1, 0.75);
	end
	renderText(x,y-0.0015,0.021,t);
	if disable then
		setTextColor(0.1569, 0.2353, 0.0784, 0.5);
	else
		setTextColor(0.1569, 0.2353, 0.0784, 1);
	end
	renderText(x,y,0.021,t); 
end;
local function showFeldNum(x,y,t,th,c)
	y = y - (th/2);
	x = x - 0.0015;
	setTextColor(0, 0, 0, 0.75);
	renderText(x,y-0.0025,th,t);
	if c then
		setTextColor(unpack(c));
	else
		setTextColor(1, 1, 1, 1);
	end
	renderText(x,y,th,t) ;
end;
local function Blink(h,w)
	local t = g_currentMission.time % 1000;
	local t2 = math.floor((500+t)/1000);
	local t3 = t2 + ((t/1000)*Utils.lerp(-1, 1, 1-t2));
	h = h * (1 + Utils.lerp(0, w, t3));
	return h;
end;

function FieldBuyHudUI:draw()
	if self.DrawUI then
		
		if not self.MapOl.Overlay then
			self:CreateMap();
		end
		
		setOverlayColor(self.Frame.overlay, 1,1,1,1);
		renderOverlay(self.Frame.overlay, self.Frame.x, self.Frame.y, self.Frame.w, self.Frame.h);
		
		showHeatTxt(self.Frame.x + self.Frame.w/2, self.Frame.y + self.Frame.h, g_i18n:getText("FieldBuyHeatLine"));
		
		setOverlayColor(self.MapOl.Overlay, 1,1,1,self.MapOl.mapTransp);
		renderOverlay(self.MapOl.Overlay, self.MapOl.mapPosX - (self.MapOl.mapWidth/2),
										  self.MapOl.mapPosY - (self.MapOl.mapHeight/2),
										  self.MapOl.mapWidth, self.MapOl.mapHeight);
				
		for i = 1, table.getn(self.Scroll) do
			if i == 3 then
				setOverlayColor(self.Scroll[i].overlay, 1,1,1,1);
				renderOverlay(self.Scroll[i].overlay, self.Scroll[i].x, self.Scroll[i].y, self.Scroll[i].w, self.Scroll[i].h);
			else
				if self.Scroll[i].MDown then
					self.Scroll[i].pressed:render();	
				elseif self.Scroll[i].MOver then
					self.Scroll[i].highlight:render();
				else
					self.Scroll[i].overlay:render();
				end;
			end;
		end
		
		local fd = g_currentMission.fieldDefinitionBase.fieldDefs;
		local activateText = g_currentMission.fieldDefinitionBase.activateText;
		local MouseOverField = 0;
		
		for i = 1, table.getn(self.Btns) do
		
			local f = fd[i+self.Line];
			if f then
				local txt = g_i18n:getText("FieldNo").." "..f.fieldNumber;
				local price = g_i18n:formatMoney(f.fieldPrice);
				if f.ownedByPlayer then
					price = g_i18n:formatMoney(f.fieldPrice * self.SellFac);
				elseif f.fieldAuctionActive then
					price = g_i18n:formatMoney(f.fieldCurrentBid).." / "..price;
				end
				setTextAlignment(RenderText.ALIGN_LEFT);
				showTxt(self.Frame.x + (self.Frame.w/1.9), self.Btns[i].y + self.Btns[i].ch-( 0.021/2) , txt, f.fieldMapHotspot.baseColor);
				
				if not f.ownedByPlayer or self.CanSell then
					setTextAlignment(RenderText.ALIGN_RIGHT);
					showTxt(self.Btns[i].x - self.Btns[i].cw, self.Btns[i].y + self.Btns[i].ch-( 0.021/2) , price, f.fieldMapHotspot.baseColor);
				end;
				
				local disable = false;
				if (f.ownedByPlayer and self.CanSell) or (not f.ownedByPlayer and g_currentMission.missionStats.money >= f.fieldPrice) then
					if self.Btns[i].MDown then
						self.Btns[i].pressed:render();	
					elseif self.Btns[i].MOver then
						self.Btns[i].highlight:render();
					else
						self.Btns[i].overlay:render();
					end;
				else
					self.Btns[i].overlay:render();
					disable = true;
				end
				if self.Btns[i].MOver then
					MouseOverField = i + self.Line;
				end;
				
				setTextAlignment(RenderText.ALIGN_CENTER);
				
				if f.ownedByPlayer then
					if self.CanSell then
						showBtnTxt(self.Btns[i].x + self.Btns[i].cw, self.Btns[i].y + self.Btns[i].ch-( 0.021/2) , g_i18n:getText("Button_Sell"));
					end;
				else
					if f.fieldAuctionActive then
						showBtnTxt(self.Btns[i].x + self.Btns[i].cw, self.Btns[i].y + self.Btns[i].ch-( 0.021/2) , g_i18n:getText("Button_Bid2"), disable);
					else
						showBtnTxt(self.Btns[i].x + self.Btns[i].cw, self.Btns[i].y + self.Btns[i].ch-( 0.021/2) , activateText, disable);
					end;
				end;
			end;
		end;
		
		setTextAlignment(RenderText.ALIGN_CENTER);
		
		for k,v in pairs(self.felder) do
			local bc = fd[k].fieldMapHotspot.baseColor;
			if k == MouseOverField then
				showFeldNum(self.MapOl.mapPosX + v.tx, self.MapOl.mapPosY + v.ty, v.name, Blink(self.FeldNumTh,1.0), bc);
			else
				showFeldNum(self.MapOl.mapPosX + v.tx, self.MapOl.mapPosY + v.ty, v.name, self.FeldNumTh, bc);
			end;
		end;
			
		setTextAlignment(RenderText.ALIGN_LEFT);
		setTextColor(1, 1, 1, 1);
		self.ShowMouse = true;
		InputBinding.setShowMouseCursor(true);	
	elseif self.ShowMouse then
		self.ShowMouse = nil;
		InputBinding.setShowMouseCursor(false);
	end;
end;

function FieldBuyHudUI.ButtonOnClick(me,i)
	if g_server ~= nil then
		local f = g_currentMission.fieldDefinitionBase.fieldDefs[i+me.Line];
		if f.fieldAuctionActive then
			g_currentMission.fieldDefinitionBase.currentField = f;
			g_currentMission.fieldDefinitionBase:onActivateObject();
		else
			if f.ownedByPlayer then
				if me.CanSell then
					g_currentMission:addMoney(f.fieldPrice * me.SellFac);
					g_client:getServerConnection():sendEvent(FieldBuyHudUIEvent:new(i+me.Line, false));
				end;
			elseif g_currentMission.missionStats.money >= f.fieldPrice then
				g_currentMission:addMoney(-f.fieldPrice);
				g_client:getServerConnection():sendEvent(FieldBuyHudUIEvent:new(i+me.Line, true));
			end;
		end;
	end;
end;

function FieldBuyHudUI:CreateMap()
	
	self.MapOl.file = g_inGameMenu.mapImage.imageFilename;
	self.MapOl.Overlay = createImageOverlay(self.MapOl.file);
	
	self.felder = {};
	local worldSizeZ = g_currentMission.missionPDA.worldSizeZ;
	local worldSizeX = g_currentMission.missionPDA.worldSizeX;
	local fd = g_currentMission.fieldDefinitionBase.fieldDefs;
	for k, f in pairs(fd) do		
		local x, y, z = getWorldTranslation(f.fieldMapIndicator);
		local name = tostring(f.fieldNumber);
		local PosX = ((x/worldSizeX) * self.MapOl.mapWidth);
		local PosY = ((z/worldSizeZ) * self.MapOl.mapHeight) * -1;
		self.felder[k]={name = name, tx = PosX, ty = PosY};
	end;
end;

addModEventListener(FieldBuyHudUI);

 -- Event set setFieldOwnedByPlayer --
 
FieldBuyHudUIEvent = {};
FieldBuyHudUIEvent_mt = Class(FieldBuyHudUIEvent, Event);

InitEventClass(FieldBuyHudUIEvent, "FieldBuyHudUIEvent");

function FieldBuyHudUIEvent:emptyNew()
    local self = Event:new(FieldBuyHudUIEvent_mt);
    return self;
end;
    
function FieldBuyHudUIEvent:new(field, ownedByPlayer)
	local self = FieldBuyHudUIEvent:emptyNew();
	self.field = field;
	self.ownedByPlayer = ownedByPlayer;
	return self;
end;

function FieldBuyHudUIEvent:readStream(streamId, connection)
	if connection:getIsServer() then
		self.field = streamReadInt32(streamId);
		self.ownedByPlayer = streamReadBool(streamId);
	end;
	self:run(connection);
end;

function FieldBuyHudUIEvent:writeStream(streamId, connection)
	if not connection:getIsServer() then
		streamWriteInt32(streamId, self.field);
		streamWriteBool(streamId, self.ownedByPlayer);
	end;
end;

function FieldBuyHudUIEvent:run(connection)
	
	if not connection:getIsServer() then
		g_server:broadcastEvent(self, true);
	else
		local f = g_currentMission.fieldDefinitionBase.fieldDefs[self.field];
		g_currentMission.fieldDefinitionBase:setFieldOwnedByPlayer(f, self.ownedByPlayer);
	end;
	
end;
