-- New Fruits Register LS13
-- Sources: public scriptDoku www.ls-mods.de/scriptDocumentation.php by GIANTS-Software

local regPath = g_currentModDirectory.."map/_Include/HUD/";

-- Sonnenblumen --
print("register fruit types: sunflower, rye, manureSolid, manureLiquid");
local sunflowerHudFile = regPath.."sunflowerHud.dds";
FruitUtil.registerFruitType("sunflower", g_i18n:getText("sunflower"),  true, true, false, 0, 4, 6, 8, false, 0.5, 2.0, 0.05, true, sunflowerHudFile, {0.7, 0.5, 0, 1});

-- Roggen --

local ryeHudFile = regPath.."ryeHud.dds";
FruitUtil.registerFruitType("rye", g_i18n:getText("rye"),  true, true, false, 0, 4, 6, 8, false, 0.5, 2.0, 0.05, true, ryeHudFile, {0.1, 0.1, 0.9, 1});

-- Roggenstroh --
print("register fruit types windrow: rye_windrow, manureSolid_windrow, manureLiquid_windrow");
local rye_windrowHudFile = regPath.."rye_windrowHud.dds";
FruitUtil.registerFruitTypeWindrow(FruitUtil.FRUITTYPE_RYE, "rye_windrow", g_i18n:getText("rye_windrow"), 0.1, 4, false, rye_windrowHudFile);
FruitUtil.registerFruitTypeWindrowForageWagonConversion( FruitUtil.FRUITTYPE_RYE, FruitUtil.FRUITTYPE_WHEAT );

-- für ManureMod
FruitUtil.registerFruitType("manureSolid", "manureSolid", false, false, true, 1, 100, 2, 1, 1, nil);
FruitUtil.registerFruitType("manureLiquid", "manureLiquid", false, false, true, 1, 100, 2, 1, 1, nil);
local mSolid_windrowHudFile = regPath.."manureHud.dds";
FruitUtil.registerFruitTypeWindrow(FruitUtil.FRUITTYPE_MANURESOLID, "manureSolid_windrow", g_i18n:getText("manure"), 0, 3, false, mSolid_windrowHudFile);
local lSolid_windrowHudFile = regPath.."liquidManureHud.dds";
FruitUtil.registerFruitTypeWindrow(FruitUtil.FRUITTYPE_MANURELIQUID, "manureLiquid_windrow", g_i18n:getText("liquidManure"), 0, 3, false, lSolid_windrowHudFile);

local origSowingMachineLoad = SowingMachine.load;
SowingMachine.load = function (self, xmlFile)
	if origSowingMachineLoad ~= nil then
		origSowingMachineLoad(self, xmlFile);
	end;
	
	for k,v in pairs(self.seeds) do  
		fruitTypeMaize = FruitUtil.fruitTypes["maize"];
		fruitTypeWheat = FruitUtil.fruitTypes["wheat"];
		if v == fruitTypeMaize.index then
			table.insert(self.seeds, FruitUtil.fruitTypes["sunflower"].index);
		end;
		if v == fruitTypeWheat.index then
			table.insert(self.seeds, FruitUtil.fruitTypes["rye"].index); 
		end;
	end;
end;

local origBalerload = Baler.load;
Baler.load = function (self, xmlFile)
	if origBalerload ~= nil then
		origBalerload(self, xmlFile);
	end;
	
	self.fillTypes[Fillable.FILLTYPE_RYE_WINDROW] = true;
end;
