print("loading Clock-MOD LS2013");

ClockMod = {};

function ClockMod:loadMap(name)
	self.startzeit = getTime();

	self.language = g_languageShort;
	self.counter = true;
	
	if g_i18n:hasText("cmTimeFormat") then
		self.timform = g_i18n:getText("cmTimeFormat");
	else
		self.timform = 12;
	end;
	
	self.months = {};
    self.months[01] = "Led";
    self.months[02] = "Uno";
    self.months[03] = "Bre";
    self.months[04] = "Dub";
    self.months[05] = "Kve";
    self.months[06] = "Cen";
    self.months[07] = "Cec";
    self.months[08] = "Srp";
    self.months[09] = "Zar";
    self.months[10] = "Rij";
    self.months[11] = "Lis";
    self.months[12] = "Pros";

	self.days = {};
	self.days[1] = "Nedele";
	self.days[2] = "pondeli";
	self.days[3] = "utery";
	self.days[4] = "streda";
	self.days[5] = "ctvrtek";
	self.days[6] = "patek";
	self.days[7] = "sobota";
	
	self.de_tag = self.days[tonumber(getDate("%w"))+1];
	self.curmon = getDate("%m")
	self.de_monat = self.months[tonumber(self.curmon)];
	
end;

function ClockMod:deleteMap()

end;

function ClockMod:mouseEvent(posX, posY, isDown, isUp, button)

end;

function ClockMod:keyEvent(unicode, sym, modifier, isDown)

end;

function ClockMod:update(dt)
		
end;

function ClockMod:draw()
	----
	-- Datum anzeigen / Show Date
	----
	setTextColor(1,1,1,1);
	
	if self.language == "en" then
		renderText(0.83, 0.982, 0.02, getDate("%a, %d.%b %Y"));	-- en
	elseif self.language == "de" then
		renderText(0.83, 0.982, 0.02, (self.de_tag..", "..getDate("%d").."."..self.de_monat.." "..getDate("%Y"))); -- de
	else
		renderText(0.83, 0.982, 0.02, getDate("%a, %d.%b %Y")); -- other
	end;
	----
	
	----
	-- Uhrzeit anzeigen / Show Time
	----
	setTextColor(0,0.5,0.5,1);
	if tonumber(self.timform) == 12 then
		renderText(0.87, 0.905, 0.018, getDate("%I:%M:%S ")..string.lower(getDate("%p")));	-- 12h
	elseif tonumber(self.timform) == 24 then
		renderText(0.87, 0.905, 0.018, getDate("%H:%M:%S"));		-- 24h
	else
		renderText(0.87, 0.905, 0.018, getDate("%I:%M:%S ")..string.lower(getDate("%p")));	-- 12h
	end
	----
	
	----
	-- Spielzeit zeigen / Show Playtime
	----
	if self.counter then
		if g_i18n:hasText("cmPlayTimeAll") then
			renderText(0.83, 0.970, 0.013, g_i18n:getText("cmPlayTimeAll"));	
			renderText(0.83, 0.956, 0.013, g_i18n:getText("cmPlayTimeToday"));	
		else -- other
			renderText(0.83, 0.970, 0.013, "Odehrano celkem:");
			renderText(0.83, 0.956, 0.013, "Odehrano dnes:");
		end

		self.playhours = math.floor(g_currentMission.missionStats.playTime /60)
		self.playmins = g_currentMission.missionStats.playTime - (self.playhours * 60)

		if self.playmins >= 10 then
			renderText(0.91, 0.970, 0.013, (string.format("%.0f", self.playhours)..":"..string.format("%.0f", self.playmins)));
		else
			renderText(0.91, 0.970, 0.013, (string.format("%.0f", self.playhours)..":0"..string.format("%.0f", self.playmins)));
		end

		self.difftim = getTime() - self.startzeit;
		if self.difftim >= 3600 then
			renderText(0.91, 0.957, 0.013, getDate("%H:%M", (getTime() - self.startzeit)));
		elseif self.difftim >= 60 then
			renderText(0.91, 0.957, 0.013, getDate("0:%M", (getTime() - self.startzeit)));
		else
			renderText(0.91, 0.957, 0.013, getDate("0:00"));
		end
	end;
	setTextColor(1, 1, 1, 0);
	----
end;

addModEventListener(ClockMod);