_=[[
author: igor29381

specially for Kuehlauflieger3AchsOverNightExpress, use only with toggleAnimatedParts.lua
  Kuehlauflieger3AchsOverNightExpress,    toggleAnimatedParts.lua
]]

Kuehlauflieger = {};

function Kuehlauflieger.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Trailer, specializations);
end;

function Kuehlauflieger:load(xmlFile)
	self.OpenDoors = false;
	self.ShutDoors = false;
end;

function Kuehlauflieger:delete()
end;

function Kuehlauflieger:readStream(streamId, connection)
end;

function Kuehlauflieger:writeStream(streamId, connection)
end;

function Kuehlauflieger:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Kuehlauflieger:keyEvent(unicode, sym, modifier, isDown)
end;

function Kuehlauflieger:update(dt)
	local FL = math.floor(self.fillLevel);
	local LFL = 0;
	if self.oldFillLevel ~= nil then 
		LFL = math.floor(self.oldFillLevel); 
	else
		LFL = FL;
	end;
	if FL > LFL then self.OpenDoors = true; end;
	if self.OpenDoors == true then
		for _,part in ipairs(self.animParts) do
			local curRot = {getRotation(part.index)};
			local newRot = Utils.getMovedLimitedValues(curRot, part.rotMax, part.rotMin, 3, part.moveTime, dt, false);
			setRotation(part.index, unpack(newRot));
			if math.abs(newRot[2]) >= math.abs(part.rotMax[2]) then
				self.OpenDoors = false;
				self.ShutDoors = true;
			end;
		end;
	end;
	if (self.ShutDoors == true and FL == LFL) then
		for _,part in ipairs(self.animParts) do
			local curRot = {getRotation(part.index)};
			local newRot = Utils.getMovedLimitedValues(curRot, part.rotMax, part.rotMin, 3, part.moveTime, dt, true);
			setRotation(part.index, unpack(newRot));
			if math.abs(newRot[2]) <= 0 then
				self.ShutDoors = false;
			end;
		end;
	end;
	self.oldFillLevel = self.fillLevel;
end;

function Kuehlauflieger:updateTick(dt)
	
end;

function Kuehlauflieger:draw()
end;