--author: igor29381

Fillable.registerFillType("seed_oil", g_i18n:getText("SeedOil"), 1, true, g_currentModDirectory.."huds/seed_oil_hud.dds");
Fillable.registerFillType("packed_seed_oil", g_i18n:getText("PackedSeedOil"), 1.2, true, g_currentModDirectory.."huds/packed_seed_oil_hud.dds");
Fillable.registerFillType("oilcake", g_i18n:getText("Oilcake"), 0.15, false, g_currentModDirectory.."huds/oilcake_hud.dds");
Fillable.registerFillType("husk", g_i18n:getText("Husk"), 0.1, false, g_currentModDirectory.."huds/husk_hud.dds");

OilExtractionPlant = {};
OilExtractionPlant_mt = Class(OilExtractionPlant, Object);
InitObjectClass(OilExtractionPlant, "OilExtractionPlant");

local products = {[Fillable.FILLTYPE_SEED_OIL] = 0,
		[Fillable.FILLTYPE_PACKED_SEED_OIL] = 0,
		[Fillable.FILLTYPE_OILCAKE] = 0,
		[Fillable.FILLTYPE_HUSK] = 0};

function OilExtractionPlant.onCreate(id)
    local object = OilExtractionPlant:new(g_server ~= nil, g_client ~= nil)
    if object:load(id) then
        g_currentMission:addOnCreateLoadedObject(object)
        object:register(true)
    else
        object:delete()
    end
end

function OilExtractionPlant:new(isServer, isClient, customMt)
    local mt = customMt
    if mt == nil then
        mt = OilExtractionPlant_mt
    end
    local self = Object:new(isServer, isClient, OilExtractionPlant_mt);
    registerObjectClassName(self, "OilExtractionPlant");
    return self;
end;

function OilExtractionPlant:load(nodeId)

	self.nodeId = nodeId;

	local tipTrigger = getUserAttribute(nodeId, "tipTrigger");
	if tipTrigger ~= nil then
		local OEPtipTrigger = Utils.indexToObject(nodeId, tipTrigger);
		if OEPtipTrigger ~= nil then
			self.OEPtipTrigger = FeedingTroughTipTrigger:new(self.isServer, self.isClient);
			self.OEPtipTrigger:load(OEPtipTrigger, self);
			g_currentMission:addOnCreateLoadedObject(self.OEPtipTrigger);
			self.OEPtipTrigger:register(true);
			removeTrigger(self.OEPtipTrigger.triggerId);
			addTrigger(self.OEPtipTrigger.triggerId , "OEPtipTriggerCallback", self);
			local desc = Fillable.fillTypeNameToDesc["sunflower"];
			if desc ~= nil then
				self.OEPtipTrigger.acceptedFillTypes[desc.index] = true;
				self.OEPtipTrigger.priceMultipliers[desc.index] = 1.12;
			end;
		end;
	end;
	local adminTrigger = getUserAttribute(nodeId, "adminTrigger");
	if adminTrigger ~= nil then
		self.adminTrigger = Utils.indexToObject(nodeId, adminTrigger);
		if self.adminTrigger ~= nil then
			addTrigger(self.adminTrigger , "adminTriggerCallback", self);
		end;
	end;
	local heap = getUserAttribute(nodeId, "heap");
	if heap ~= nil then self.heap = Utils.indexToObject(nodeId, heap); end;

	g_currentMission:addNodeObject(self.nodeId, self);
	g_currentMission:addOnCreateLoadedObjectToSave(self);
	self.sunflowerLevel = 0;
	self.workTime = Utils.getNoNil(getUserAttribute(nodeId, "workTime"), 50);
	self.jobLiters = Utils.getNoNil(getUserAttribute(nodeId, "jobLiters"), 50);
	self.counter = 0;
	self.counter2 = 0;
	self.PackOil = false;
	self.SellSunflower = false;
    	return true;
end;

function OilExtractionPlant:getSaveAttributesAndNodes(nodeIdent)
	local attributes = 'sunflowerLevel="'..self.sunflowerLevel..'" OilLevel="'..products[Fillable.FILLTYPE_SEED_OIL]..'" PackedOilLevel="'..products[Fillable.FILLTYPE_PACKED_SEED_OIL]..'" OilcakeLevel="'..products[Fillable.FILLTYPE_OILCAKE]..'" HuskLevel="'..products[Fillable.FILLTYPE_HUSK]..'"';
	local nodes = "";
return attributes, nodes;
end;

function OilExtractionPlant:loadFromAttributesAndNodes(xmlFile, Key)
	self.sunflowerLevel = Utils.getNoNil(getXMLFloat(xmlFile, Key.."#sunflowerLevel"),0);
	products[Fillable.FILLTYPE_SEED_OIL] = Utils.getNoNil(getXMLFloat(xmlFile, Key.."#OilLevel"),0);
	products[Fillable.FILLTYPE_PACKED_SEED_OIL] = Utils.getNoNil(getXMLFloat(xmlFile, Key.."#PackedOilLevel"),0);
	products[Fillable.FILLTYPE_OILCAKE] = Utils.getNoNil(getXMLFloat(xmlFile, Key.."#OilcakeLevel"),0);
	products[Fillable.FILLTYPE_HUSK] = Utils.getNoNil(getXMLFloat(xmlFile, Key.."#HuskLevel"),0);
	return true;
end;

function OilExtractionPlant:delete()
	g_currentMission:removeOnCreateLoadedObjectToSave(self);
	removeTrigger(self.adminTrigger);
	if self.OEPtipTrigger.isRegistered then
		self.OEPtipTrigger:unregister();
		self.OEPtipTrigger:delete();
	end;
	if self.nodeId ~= 0 then g_currentMission:removeNodeObject(self.nodeId); end;
	unregisterObjectClassName(self);
end;

function OilExtractionPlant:readStream(streamId, connection)
end

function OilExtractionPlant:writeStream(streamId, connection)
end

function OilExtractionPlant:deleteFinal()
end;

function OilExtractionPlant:update(dt)
	if self.sunflowerLevel > 0 then
		self.counter = self.counter + 1;
		if self.counter == self.workTime then
			local delta = self.jobLiters;
			if self.sunflowerLevel - delta < 0 then delta = self.sunflowerLevel; end;
			self.sunflowerLevel = self.sunflowerLevel - delta;
			products[Fillable.FILLTYPE_SEED_OIL] = products[Fillable.FILLTYPE_SEED_OIL] + (delta*0.45);
			products[Fillable.FILLTYPE_OILCAKE] = products[Fillable.FILLTYPE_OILCAKE] + (delta*0.4);
			products[Fillable.FILLTYPE_HUSK] = products[Fillable.FILLTYPE_HUSK] + (delta*0.15);
			self.counter = 0;
		end;
	end;
	if self.admin == true then
		local seedOilPrice = products[Fillable.FILLTYPE_SEED_OIL]*Fillable.fillTypeIndexToDesc[Fillable.FILLTYPE_SEED_OIL].pricePerLiter;
		local packedSeedOilPrice = products[Fillable.FILLTYPE_PACKED_SEED_OIL]*Fillable.fillTypeIndexToDesc[Fillable.FILLTYPE_PACKED_SEED_OIL].pricePerLiter;
		local oilcakePrice = products[Fillable.FILLTYPE_OILCAKE]*Fillable.fillTypeIndexToDesc[Fillable.FILLTYPE_OILCAKE].pricePerLiter;
		local huskPrice = products[Fillable.FILLTYPE_HUSK]*Fillable.fillTypeIndexToDesc[Fillable.FILLTYPE_HUSK].pricePerLiter;

		g_currentMission:addHelpButtonText(g_i18n:getText("sell_seed_oil")..tostring(math.floor(seedOilPrice))..'$)', InputBinding.SPEED_LEVEL1);
		g_currentMission:addHelpButtonText(g_i18n:getText("sell_packed_seed_oil")..tostring(math.floor(packedSeedOilPrice))..'$)', InputBinding.SPEED_LEVEL2);
		g_currentMission:addHelpButtonText(g_i18n:getText("sell_oilcake")..tostring(math.floor(oilcakePrice))..'$)', InputBinding.SPEED_LEVEL3);
		g_currentMission:addHelpButtonText(g_i18n:getText("sell_husk")..tostring(math.floor(huskPrice))..'$)', InputBinding.SPEED_LEVEL4);
		if self.PackOil == false then
			g_currentMission:addHelpButtonText(g_i18n:getText("StartPackOil"), InputBinding.IMPLEMENT_EXTRA3);
		else
			g_currentMission:addHelpButtonText(g_i18n:getText("StopPackOil"), InputBinding.IMPLEMENT_EXTRA3);
		end;
		if self.SellSunflower == false then
			g_currentMission:addHelpButtonText(g_i18n:getText("SellSunflower"), InputBinding.IMPLEMENT_EXTRA2);
		else
			g_currentMission:addHelpButtonText(g_i18n:getText("ProcessSunflower"), InputBinding.IMPLEMENT_EXTRA2);
		end;
		g_currentMission:addExtraPrintText(g_i18n:getText("SeedOil")..': '..tostring(math.floor(products[Fillable.FILLTYPE_SEED_OIL])), self.typeDesc);
		g_currentMission:addExtraPrintText(g_i18n:getText("PackedSeedOil")..': '..tostring(math.floor(products[Fillable.FILLTYPE_PACKED_SEED_OIL])), self.typeDesc);
		g_currentMission:addExtraPrintText(g_i18n:getText("Oilcake")..': '..tostring(math.floor(products[Fillable.FILLTYPE_OILCAKE])), self.typeDesc);
		g_currentMission:addExtraPrintText(g_i18n:getText("Husk")..': '..tostring(math.floor(products[Fillable.FILLTYPE_HUSK])), self.typeDesc);

		if InputBinding.hasEvent(InputBinding.SPEED_LEVEL1) then 
			g_currentMission:addSharedMoney(seedOilPrice, "other");
			products[Fillable.FILLTYPE_SEED_OIL] = 0;
		end;
		if InputBinding.hasEvent(InputBinding.SPEED_LEVEL2) then 
			g_currentMission:addSharedMoney(packedSeedOilPrice, "other"); 
			products[Fillable.FILLTYPE_PACKED_SEED_OIL] = 0;
		end;
		if InputBinding.hasEvent(InputBinding.SPEED_LEVEL3) then 
			g_currentMission:addSharedMoney(oilcakePrice, "other"); 
			products[Fillable.FILLTYPE_OILCAKE] = 0;
		end;
		if InputBinding.hasEvent(InputBinding.SPEED_LEVEL4) then 
			g_currentMission:addSharedMoney(huskPrice, "other"); 
			products[Fillable.FILLTYPE_HUSK] = 0;
		end;
		if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA3) then self.PackOil = not self.PackOil; end;
		if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA2) then self.SellSunflower = not self.SellSunflower; end;
	end;
	if products[Fillable.FILLTYPE_SEED_OIL] <= 0 then self.PackOil = false; end;
	if self.PackOil == true then
		self.counter2 = self.counter2 + 1;
		if self.counter2 == self.workTime then
			local delta = self.jobLiters;
			if products[Fillable.FILLTYPE_SEED_OIL] - delta < 0 then delta = products[Fillable.FILLTYPE_SEED_OIL]; end;
			products[Fillable.FILLTYPE_SEED_OIL] = products[Fillable.FILLTYPE_SEED_OIL] - delta;
			products[Fillable.FILLTYPE_PACKED_SEED_OIL] = products[Fillable.FILLTYPE_PACKED_SEED_OIL] + delta;
			self.counter2 = 0;
		end;
	end;
	local _,y,_ = getTranslation(self.heap);
	if y > -4.17 then setTranslation(self.heap, 0, y-0.0025, -1.44); end;
end;

function OilExtractionPlant:updateTick()    
end;

function OilExtractionPlant:getNoAllowedText(trailer)
	if trailer.currentFillType ~= Fillable.FILLTYPE_UNKNOWN and not self.OEPtipTrigger.acceptedFillTypes[trailer.currentFillType] then
		return Fillable.fillTypeIndexToDesc[trailer.currentFillType].nameI18N .. g_i18n:getText("notAcceptedHere");
	end;
	return nil;
end;

function OilExtractionPlant:getTipInfoForTrailer(trailer, tipReferencePointIndex)
	local minDistance, bestPoint, trigger = math.huge, nil, nil;
	local distance, Point = self.OEPtipTrigger:getTipDistanceFromTrailer(trailer, tipReferencePointIndex);
	if distance < minDistance then
		minDistance = distance;
		bestPoint = Point;
	end;
	local isAllowed = false;
	if self.OEPtipTrigger.acceptedFillTypes[trailer.currentFillType] then
		isAllowed = true;
	end;
	return isAllowed, minDistance, bestPoint;
end;

function OilExtractionPlant:updateTrailerTipping(trailer, fillDelta, fillType)
	if fillDelta < 0 then
		if self.SellSunflower == false then
			self.sunflowerLevel = self.sunflowerLevel - fillDelta;
		else
			local priceMultiplier = self.OEPtipTrigger.priceMultipliers[fillType];
			local difficultyMultiplier = math.max(2 * (3 - g_currentMission.missionStats.difficulty), 1);
			local money = Fillable.fillTypeIndexToDesc[fillType].pricePerLiter * priceMultiplier * difficultyMultiplier * -fillDelta;
			g_currentMission:addSharedMoney(money, "harvestIncome");
		end;
		local _,y,_ = getTranslation(self.heap);
		setTranslation(self.heap, 0, math.min(y+0.015, -1.7), -1.44);
	end;
end;

function OilExtractionPlant:OEPtipTriggerCallback(triggerId, otherId, onEnter, onLeave, onStay, otherShapeId)
		
	local trailer = g_currentMission.objectToTrailer[otherShapeId];
	if trailer ~= nil and trailer.allowTipDischarge then
		if onEnter then
			if g_currentMission.trailerTipTriggers[trailer] == nil then
				g_currentMission.trailerTipTriggers[trailer] = {};
			end;
			table.insert(g_currentMission.trailerTipTriggers[trailer], self);
		elseif onLeave then
			local triggers = g_currentMission.trailerTipTriggers[trailer];
			if triggers ~= nil then
				for i=1, table.getn(triggers) do
					if triggers[i] == self then
						table.remove(triggers, i);
						if table.getn(triggers) == 0 then
							g_currentMission.trailerTipTriggers[trailer] = nil;
						end;
						break;
					end;
				end;
			end;
		end;
	end;
end;

function OilExtractionPlant:adminTriggerCallback(triggerId, otherId, onEnter, onLeave, onStay, otherShapeId)
	if onEnter then 
		if otherId == g_currentMission.player.rootNode then self.admin = true; end;
	end;
	if onLeave then
		if otherId == g_currentMission.player.rootNode then self.admin = false; end;
	end;
end;

g_onCreateUtil.addOnCreateFunction("OilExtractionPlant", OilExtractionPlant.onCreate);

--------------------------------------------------------------------------------------------

OpenPlantGate = {};
OpenPlantGate_mt = Class(OpenPlantGate, Object);
InitObjectClass(OpenPlantGate, "OpenPlantGate");

function OpenPlantGate.onCreate(id)
    local object = OpenPlantGate:new(g_server ~= nil, g_client ~= nil)
    if object:load(id) then
        g_currentMission:addOnCreateLoadedObject(object)
        object:register(true)
    else
        object:delete()
    end
end

function OpenPlantGate:new(isServer, isClient, customMt)
    local mt = customMt
    if mt == nil then
        mt = OpenPlantGate_mt
    end
    local self = Object:new(isServer, isClient, OpenPlantGate_mt);
    registerObjectClassName(self, "OpenPlantGate");
    return self;
end;

function OpenPlantGate:load(id)
    	self.GateTrigger = id;
    	addTrigger(id, "OpenPlantGateTriggerCallback", self);
	self.gate = getChildAt(id, 0);
	self.count = 0;
    	return true;
end;

function OpenPlantGate:delete()
	removeTrigger(self.GateTrigger);
	unregisterObjectClassName(self);
end;

function OpenPlantGate:readStream(streamId, connection)
end

function OpenPlantGate:writeStream(streamId, connection)
end

function OpenPlantGate:deleteFinal()
end;

function OpenPlantGate:update(dt)
	if self.count > 0 then
		local _, _, z = getTranslation(self.gate);
		setTranslation(self.gate, 0, 0, math.min(z+0.2, 6.2));
	else
		local _, _, z = getTranslation(self.gate);
		setTranslation(self.gate, 0, 0, math.max(z-0.2, 0));
	end;
end;

function OpenPlantGate:updateTick()    
end;

function OpenPlantGate:OpenPlantGateTriggerCallback(triggerId, otherId, onEnter, onLeave, onStay, otherShapeId)
	if onEnter then self.count = self.count + 1; end;
	if onLeave then self.count = self.count - 1; end;
end;

g_onCreateUtil.addOnCreateFunction("OpenPlantGate", OpenPlantGate.onCreate);

--------------------------------------------------------------------------------------------
FillingStation = {};
FillingStation_mt = Class(FillingStation, Object);
InitObjectClass(FillingStation, "FillingStation");

function FillingStation.onCreate(id)
    local object = FillingStation:new(g_server ~= nil, g_client ~= nil)
    if object:load(id) then
        g_currentMission:addOnCreateLoadedObject(object)
        object:register(true)
    else
        object:delete()
    end
end

function FillingStation:new(isServer, isClient, customMt)
    local mt = customMt
    if mt == nil then
        mt = FillingStation_mt
    end
    local self = Object:new(isServer, isClient, FillingStation_mt);
    registerObjectClassName(self, "FillingStation");
    return self;
end;

function FillingStation:load(id)

    	local manipulator = getUserAttribute(id, "manipulator");
    	local ladder = getUserAttribute(id, "ladder");
	local trigger = getUserAttribute(id, "trigger");
	if trigger ~= nil then
		self.trigger = Utils.indexToObject(id, trigger);
		if self.trigger ~= nil then addTrigger(self.trigger, "triggerCallback", self); end;
	end;
	self.InStation = false;
	if manipulator ~= nil then
		self.man01 = Utils.indexToObject(id, manipulator);
		self.man02 = getChildAt(self.man01, 0);
		self.man03 = getChildAt(self.man02, 0);
		self.man04 = getChildAt(self.man03, 0);
	end;
	if ladder ~= nil then
		self.ladder = Utils.indexToObject(id, ladder);
		self.stave = {};
		local numChildren = getNumOfChildren(self.ladder) - 1;
		for i=1, numChildren do
			self.stave[i] = getChildAt(self.ladder, i);
		end;
	end;
    	return true;
end;

function FillingStation:delete()
	removeTrigger(self.trigger);
	unregisterObjectClassName(self);
end;

function FillingStation:readStream(streamId, connection)
end

function FillingStation:writeStream(streamId, connection)
end

function FillingStation:deleteFinal()
end;

function FillingStation:update(dt)

	if self.InStation == true then
		if self.trailer ~= nil then
		local trailer = g_currentMission.objectToTrailer[self.trailer];
		if trailer ~= nil then
			g_currentMission:addExtraPrintText(g_i18n:getText("TankLevel")..tostring(math.floor(trailer.fillLevel)), self.typeDesc);
		end; end;	
		if Input.isKeyPressed(Input.KEY_KP_1) then
			local _, yr, _ = getRotation(self.man01);
			setRotation(self.man01, 0, yr+0.01, 0);
		end;
		if Input.isKeyPressed(Input.KEY_KP_3) then
			local _, yr, _ = getRotation(self.man01);
			setRotation(self.man01, 0, yr-0.01, 0);
		end;
		if Input.isKeyPressed(Input.KEY_KP_4) then
			local _, yr, _ = getRotation(self.man02);
			setRotation(self.man02, 0, yr+0.01, 0);
		end;
		if Input.isKeyPressed(Input.KEY_KP_6) then
			local _, yr, _ = getRotation(self.man02);
			setRotation(self.man02, 0, yr-0.01, 0);
		end;
		if Input.isKeyPressed(Input.KEY_KP_2) then
			local xr, _, _ = getRotation(self.man03);
			local xr1, _, _ = getRotation(self.man04);
			if xr < 0.7 then
				setRotation(self.man03, xr+0.01, 0, 0);
				setRotation(self.man04, xr1-0.01, 0, 0);
			end;
		end;
		if Input.isKeyPressed(Input.KEY_KP_5) then
			local xr, _, _ = getRotation(self.man03);
			local xr1, _, _ = getRotation(self.man04);
			if xr > -0.9 then
				setRotation(self.man03, xr-0.01, 0, 0);
				setRotation(self.man04, xr1+0.01, 0, 0);
			end;
		end;
		if Input.isKeyPressed(Input.KEY_KP_plus) then
			local _, _, zr = getRotation(self.ladder);
			local _, _, zr1 = getRotation(self.stave[1]);
			if zr < 2 then
				setRotation(self.ladder, 0, 0, zr+0.01);
				for i=1, table.getn(self.stave) do
					setRotation(self.stave[i], 0, 0, zr1-0.01);
				end;
			end;
		end;
		if Input.isKeyPressed(Input.KEY_KP_minus) then
			local _, _, zr = getRotation(self.ladder);
			local _, _, zr1 = getRotation(self.stave[1]);
			if zr > 0 then
				setRotation(self.ladder, 0, 0, zr-0.01);
				for i=1, table.getn(self.stave) do
					setRotation(self.stave[i], 0, 0, zr1+0.01);
				end;
			end;
		end;
	else
		local xr, _, _ = getRotation(self.man03);
		if xr > -0.52 then
			local xr1, _, _ = getRotation(self.man04);
			setRotation(self.man03, xr-0.03, 0, 0);
			setRotation(self.man04, xr1+0.03, 0, 0);
		else
			local _, yr, _ = getRotation(self.man02);
			if yr < 2.97 then 
				setRotation(self.man02, 0, yr+0.03, 0);
			else
				local _, yr1, _ = getRotation(self.man01);
				if yr1 > 3.14 then setRotation(self.man01, 0, yr1-0.03, 0); end;
			end;
		end;
		local _, _, zr = getRotation(self.ladder);
		if zr > 0 then
			local _, _, zr1 = getRotation(self.stave[1]);
			setRotation(self.ladder, 0, 0, zr-0.03);
			for i=1, table.getn(self.stave) do
				setRotation(self.stave[i], 0, 0, zr1+0.03);
			end;
		end;
	end;
end;

function FillingStation:updateTick()    
end;

function FillingStation:triggerCallback(triggerId, otherId, onEnter, onLeave, onStay, otherShapeId)
	if onEnter then
		local trailer = g_currentMission.objectToTrailer[otherShapeId];
		if trailer then
		if trailer:allowFillType(Fillable.FILLTYPE_SEED_OIL, false) then self.trailer = otherShapeId; end; end;
		if otherId == g_currentMission.player.rootNode then self.InStation = true; end;
	end;
	if onLeave then
		local trailer = g_currentMission.objectToTrailer[otherShapeId];
		if trailer then self.trailer = nil; end;
		if otherId == g_currentMission.player.rootNode then self.InStation = false; end;
	end;
end;

g_onCreateUtil.addOnCreateFunction("FillingStation", FillingStation.onCreate);

------------------------------------------------------------------------------------------------------

FillProduct = {};
FillProduct_mt = Class(FillProduct, Object);
InitObjectClass(FillProduct, "FillProduct");

function FillProduct.onCreate(id)
    local object = FillProduct:new(g_server ~= nil, g_client ~= nil)
    if object:load(id) then
        g_currentMission:addOnCreateLoadedObject(object)
        object:register(true)
    else
        object:delete()
    end
end

function FillProduct:new(isServer, isClient, customMt)
    local mt = customMt
    if mt == nil then
        mt = FillProduct_mt
    end
    local self = Object:new(isServer, isClient, FillProduct_mt);
    registerObjectClassName(self, "FillProduct");
    return self;
end;

function FillProduct:load(id)
	self.fillTrigger = id;
	addTrigger(self.fillTrigger , "TriggerCallback", self);
	local door = getUserAttribute(id, "door");
	if door ~= nil then self.door = Utils.indexToObject(id, door); end;
	local productPS = getUserAttribute(id, "productPS");
	if productPS ~= nil then
		local prodPS = Utils.indexToObject(id, productPS);
		if prodPS ~= nil then
			self.productPS = {};
			Utils.loadParticleSystemFromNode(prodPS, self.productPS, false, true);
		end;
	end;
	self.fillType = Fillable.FILLTYPE_UNKNOWN;
	local fillType = getUserAttribute(id, "fillType");
	if fillType ~= nil then
		local desc = Fillable.fillTypeNameToDesc[fillType];
		if desc ~= nil then
			self.fillType = desc.index;
		end;
	end;

	self.fillLiters = Utils.getNoNil(getUserAttribute(id, "fillLiters"), 30);
	self.openDoor = false;
    	return true;
end;

function FillProduct:delete()
	removeTrigger(self.fillTrigger);
	if self.productPS ~= nil then Utils.deleteParticleSystem(self.productPS); end;
	unregisterObjectClassName(self);
end;

function FillProduct:readStream(streamId, connection)
end

function FillProduct:writeStream(streamId, connection)
end

function FillProduct:deleteFinal()
end;

function FillProduct:update(dt)
	if self.ProductTrailer ~= nil then
		local trailer = g_currentMission.objectToTrailer[self.ProductTrailer];
		if trailer ~= nil then
		if trailer:allowFillType(self.fillType, false) then	
			if trailer.fillLevel < trailer.capacity then
				if trailer.currentFillType == 0 or trailer.currentFillType == self.fillType then
					if products[self.fillType] > 0 then
						local delta = self.fillLiters;
						if products[self.fillType] - delta < 0 then delta = products[self.fillType]; end;
						products[self.fillType] = products[self.fillType] - delta; 
						local TFL = trailer.fillLevel + delta;
						trailer:setFillLevel(TFL, self.fillType);
						if self.productPS ~= nil then Utils.setEmittingState(self.productPS, true); end;
					else
						if self.productPS ~= nil then Utils.setEmittingState(self.productPS, false); end;
					end;
				end;
			else
				if self.productPS ~= nil then Utils.setEmittingState(self.productPS, false); end;
			end;
		end;
		end;		
	end;
	if self.door ~= nil then
		if self.openDoor == true then
			local _, y, _ = getTranslation(self.door);
			if y < 2.92 then setTranslation(self.door, 0, y + 0.2, 0); end;
		else
			local _, y, _ = getTranslation(self.door);
			if y > 0 then setTranslation(self.door, 0, math.max(y - 0.2, 0), 0); end;
		end;
	end;
end;

function FillProduct:updateTick()    
end;

function FillProduct:TriggerCallback(triggerId, otherId, onEnter, onLeave, onStay, otherShapeId)
	if onEnter then
		local trailer = g_currentMission.objectToTrailer[otherShapeId];
		if trailer then 
			if trailer:allowFillType(self.fillType, false) then
				self.ProductTrailer = otherShapeId;
				if self.door ~= nil then self.openDoor = true; end; 
			end;
		end;
	end;
	if onLeave then
		local trailer = g_currentMission.objectToTrailer[otherShapeId];
		if trailer then
			self.ProductTrailer = nil;
			if self.productPS ~= nil then Utils.setEmittingState(self.productPS, false); end;
			if self.door ~= nil then self.openDoor = false; end;
		end;
	end;
end;

g_onCreateUtil.addOnCreateFunction("FillProduct", FillProduct.onCreate);