--author: werik

AutomaticHatches = {};

function AutomaticHatches.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Trailer, specializations);
end;

function AutomaticHatches:load(xmlFile)
local rotationPartNoderightdoor = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rightdoor#index"));
    if rotationPartNoderightdoor ~= nil then
        self.rotationPartrightdoor = {};
        self.rotationPartrightdoor.node = rotationPartNoderightdoor;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rightdoor#minRot"));
        self.rotationPartrightdoor.minRot = {};
        self.rotationPartrightdoor.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartrightdoor.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartrightdoor.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rightdoor#maxRot"));
        self.rotationPartrightdoor.maxRot = {};
        self.rotationPartrightdoor.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartrightdoor.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartrightdoor.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartrightdoor.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rightdoor#rotTime"), 2)*1000;
        self.rotationPartrightdoor.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rightdoor#touchRotLimit"), 10));
    end;
local rotationPartNodeleftdoor = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.leftdoor#index"));
    if rotationPartNodeleftdoor ~= nil then
        self.rotationPartleftdoor = {};
        self.rotationPartleftdoor.node = rotationPartNodeleftdoor;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.leftdoor#minRot"));
        self.rotationPartleftdoor.minRot = {};
        self.rotationPartleftdoor.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartleftdoor.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartleftdoor.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.leftdoor#maxRot"));
        self.rotationPartleftdoor.maxRot = {};
        self.rotationPartleftdoor.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartleftdoor.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartleftdoor.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartleftdoor.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.leftdoor#rotTime"), 2)*1000;
        self.rotationPartleftdoor.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.leftdoor#touchRotLimit"), 10));
    end;
local rotationPartNoderightwindows = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rightwindows#index"));
    if rotationPartNoderightwindows ~= nil then
        self.rotationPartrightwindows = {};
        self.rotationPartrightwindows.node = rotationPartNoderightwindows;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rightwindows#minRot"));
        self.rotationPartrightwindows.minRot = {};
        self.rotationPartrightwindows.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartrightwindows.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartrightwindows.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rightwindows#maxRot"));
        self.rotationPartrightwindows.maxRot = {};
        self.rotationPartrightwindows.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartrightwindows.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartrightwindows.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartrightwindows.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rightwindows#rotTime"), 2)*1000;
        self.rotationPartrightwindows.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rightwindows#touchRotLimit"), 10));
    end;
local rotationPartNodeleftwindows = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.leftwindows#index"));
    if rotationPartNodeleftwindows ~= nil then
        self.rotationPartleftwindows = {};
        self.rotationPartleftwindows.node = rotationPartNodeleftwindows;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.leftwindows#minRot"));
        self.rotationPartleftwindows.minRot = {};
        self.rotationPartleftwindows.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartleftwindows.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartleftwindows.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.leftwindows#maxRot"));
        self.rotationPartleftwindows.maxRot = {};
        self.rotationPartleftwindows.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartleftwindows.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartleftwindows.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartleftwindows.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.leftwindows#rotTime"), 2)*1000;
        self.rotationPartleftwindows.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.leftwindows#touchRotLimit"), 10));
    end;
	self.lastFillLevel = self.fillLevel;
end;

function AutomaticHatches:delete()
end;

function AutomaticHatches:readStream(streamId, connection)
end;

function AutomaticHatches:writeStream(streamId, connection)
end;

function AutomaticHatches:mouseEvent(posX, posY, isDown, isUp, button)
end;

function AutomaticHatches:keyEvent(unicode, sym, modifier, isDown)
end;

function AutomaticHatches:update(dt)
		local FL = string.format("%1.0f", self.fillLevel);
		local LFL = string.format("%1.0f", self.lastFillLevel);
		if FL ~= LFL or self.rotationMaxrightdoor then
                                          self.rotationMaxrightdoor = true;
                                          self.rotationMaxleftdoor = true;
                                          self.rotationMaxrightwindows = true;
                                          self.rotationMaxleftwindows = true;
		else
                                          self.rotationMaxrightdoor = false;
                                          self.rotationMaxleftdoor = false;
                                          self.rotationMaxrightwindows = false;
                                          self.rotationMaxleftwindows = false;
		end;
        if self.rotationPartrightdoor ~= nil then
		   local x, y, z = getRotation(self.rotationPartrightdoor.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartrightdoor.maxRot, self.rotationPartrightdoor.minRot, 3, self.rotationPartrightdoor.rotTime, dt, not self.rotationMaxrightdoor);
		   setRotation(self.rotationPartrightdoor.node, unpack(newRot));
        end;
        if self.rotationPartleftdoor ~= nil then
		   local x, y, z = getRotation(self.rotationPartleftdoor.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartleftdoor.maxRot, self.rotationPartleftdoor.minRot, 3, self.rotationPartleftdoor.rotTime, dt, not self.rotationMaxleftdoor);
		   setRotation(self.rotationPartleftdoor.node, unpack(newRot));
        end;
        if self.rotationPartrightwindows ~= nil then
		   local x, y, z = getRotation(self.rotationPartrightwindows.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartrightwindows.maxRot, self.rotationPartrightwindows.minRot, 3, self.rotationPartrightwindows.rotTime, dt, not self.rotationMaxrightwindows);
		   setRotation(self.rotationPartrightwindows.node, unpack(newRot));
        end;
        if self.rotationPartleftwindows ~= nil then
		   local x, y, z = getRotation(self.rotationPartleftwindows.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartleftwindows.maxRot, self.rotationPartleftwindows.minRot, 3, self.rotationPartleftwindows.rotTime, dt, not self.rotationMaxleftwindows);
		   setRotation(self.rotationPartleftwindows.node, unpack(newRot));
        end;
	      self.lastFillLevel = self.fillLevel;
    end;

function AutomaticHatches:updateTick(dt)
	if g_currentMission.player ~= nil then
		-- Getting the distance between the player and the implement 
		local nearestDistance = 6.0; --max distance allowed
		local px, py, pz = getWorldTranslation(self.rootNode); 
		local vx, vy, vz = getWorldTranslation(g_currentMission.player.rootNode);
		local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);	
		if distance < nearestDistance then
                                          self.rotationMaxrightdoor = true;
                                          self.rotationMaxleftdoor = true;
                                          self.rotationMaxrightwindows = true;
                                          self.rotationMaxleftwindows = true;
		else
                                          self.rotationMaxrightdoor = false;
                                          self.rotationMaxleftdoor = false;
                                          self.rotationMaxrightwindows = false;
                                          self.rotationMaxleftwindows = false;
		end;
	end;
end;

function AutomaticHatches:draw()
end;