--author: werik, igor29381

AutomaticPlasticPlane = {};

function AutomaticPlasticPlane.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Trailer, specializations);
end;

function AutomaticPlasticPlane:load(xmlFile)

	local PlaneCloseIndex = getXMLString(xmlFile, "vehicle.AutomaticPlasticPlaneClose#index");
	if PlaneCloseIndex ~= nil then
		self.PlaneClose = Utils.indexToObject(self.components, PlaneCloseIndex);
	end;
	self.PlaneClosed = false;
	local PlaneOpenIndex = getXMLString(xmlFile, "vehicle.AutomaticPlasticPlaneOpen#index");
	if PlaneOpenIndex ~= nil then
		self.PlaneOpen = Utils.indexToObject(self.components, PlaneOpenIndex);
	end;
	self.PlaneOpened = true;
end;

function AutomaticPlasticPlane:delete()
end;

function AutomaticPlasticPlane:readStream(streamId, connection)
end;

function AutomaticPlasticPlane:writeStream(streamId, connection)
end;

function AutomaticPlasticPlane:mouseEvent(posX, posY, isDown, isUp, button)
end;

function AutomaticPlasticPlane:keyEvent(unicode, sym, modifier, isDown)
end;

function AutomaticPlasticPlane:update(dt)
	if (self.PlaneClose ~= nil and self.PlaneOpen ~= nil) then
		if self:getIsActiveForInput() then
			if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA2) then
				self.PlaneClosed = not self.PlaneClosed;
				self.PlaneOpened = not self.PlaneOpened;
			end;
		end;
		local FL = math.floor(self.fillLevel);
		local LFL = 0;
		if self.lastFillLevel ~= nil then LFL = math.floor(self.lastFillLevel); end;
		if FL ~= LFL or not self.PlaneClosed then
			setVisibility(self.PlaneClose, false);
			setVisibility(self.PlaneOpen, true);
		else
			setVisibility(self.PlaneClose, true);
			setVisibility(self.PlaneOpen, false);
		end;
		if self.tipState ~= Trailer.TIPSTATE_CLOSED then
			setVisibility(self.PlaneClose, false);
			setVisibility(self.PlaneOpen, true);
		end;
		self.lastFillLevel = self.fillLevel;
	end;
end;

function AutomaticPlasticPlane:updateTick(dt)
end;

function AutomaticPlasticPlane:draw()
          if self.PlaneClosed then
              g_currentMission:addExtraPrintText(string.format(g_i18n:getText("tentOpen")));
          else
              g_currentMission:addExtraPrintText(string.format(g_i18n:getText("tentClose")));
          end;
end;