--
-- FoldingBoards
-- author: Burner
-- date: 23.08.2012
--

FoldingBoards = {};

function FoldingBoards.prerequisitesPresent(specializations)
	return true;
end;

function FoldingBoards:load(xmlFile)
	self.itemInRange = FoldingBoards.itemInRange;
	self.leftBoard = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.boards#leftIndex"));
	self.rightBoard = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.boards#rightIndex"));
end;

function FoldingBoards:delete()
end;

function FoldingBoards:update(dt)
	if self.isClient then
		if self.varBody.activeIdx == 4 then
			if self:itemInRange(self.leftBoard) or self:itemInRange(self.rightBoard) then
				if InputBinding.hasEvent(InputBinding.D47_ToggleBoards) then
					if self.animationParts[1].clipEndTime then
						self:setAnimationTime(1, self.animationParts[1].startPosition);
					else
						self:setAnimationTime(1, self.animationParts[1].animDuration);
					end;
				end;
				if self.animationParts[1].clipEndTime then
					g_currentMission:addHelpButtonText(string.format(g_i18n:getText("D47_CloseBoard")), InputBinding.D47_ToggleBoards);
				else
					g_currentMission:addHelpButtonText(string.format(g_i18n:getText("D47_OpenBoard")), InputBinding.D47_ToggleBoards);
				end;
			end;
		
			self:setAnimationTime(1, self.animationParts[1].startPosition);
		end;
	end;
end;

function FoldingBoards:mouseEvent(posX, posY, isDown, isUp, button)
end;

function FoldingBoards:keyEvent(unicode, sym, modifier, isDown)
end;

function FoldingBoards:draw()
end;

function FoldingBoards:itemInRange(object)
	if g_currentMission.player ~= nil and object ~= nil then
		local nearestDistance = 2;
		local vx, vy, vz = getWorldTranslation(g_currentMission.player.rootNode);
		local px, py, pz = getWorldTranslation(object); 
		local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);	
		if distance < nearestDistance then
			return true;
		else
			return false;
		end;
	else
		return false;
	end;
end;

function FoldingBoards:onAttach(attacherVehicle)
end;

function FoldingBoards:onDetach()
end;

function FoldingBoards:onDeactivate()
end;

function FoldingBoards:onDeactivateSounds()
end;

function FoldingBoards:onLeave()
end;