-- BaleToManure Skript by rafftnix
-- author: rafftnix
-- date: 29.07.2012
-- Keine Vernderung ohne meine Erlaubnis!
-- No modification without my permission!
-- release history:
--          v 1.0  (August 2012)

BaleToManure = {}
local BaleToManure_mt = Class(BaleToManure, Object);

print("BaleToManure v1.0 by rafftnix loaded");

function baleToManureOnCreate(id)
	local trigger = BaleToManure:new(g_server ~= nil, g_client ~= nil);
    local index = g_currentMission:addOnCreateLoadedObject(trigger);
    trigger:load(id);
    trigger:register(true);
end;

g_onCreateUtil.addOnCreateFunction("baleToManureOnCreate", baleToManureOnCreate);

function BaleToManure:new(isServer, isClient)
	local self = Object:new(isServer, isClient, BaleToManure_mt);
	self.className = "BaleToManure";
	return self;
end;

function BaleToManure:delete()
	removeTrigger(self.triggerId);
end;

function BaleToManure:load(id)
	self.triggerId = id;
	self.massPerBale = getUserAttribute(id, "massPerBale");	
	addTrigger(self.triggerId, "triggerCallback", self);
end;

function BaleToManure:update(dt)
	
end;

function BaleToManure:triggerCallback(triggerId, otherId, onEnter, onLeave, onStay, otherShapeId)
	if g_server ~= nil then
		local object = g_currentMission:getNodeObject(otherId);
		if object ~= nil and object:isa(Bale) then
			if not (object.isAttached ~= nil and object.isAttached) then
				object:delete();
				g_currentMission:setSiloAmount(Fillable.FILLTYPE_MANURE, g_currentMission:getSiloAmount(Fillable.FILLTYPE_MANURE) + self.massPerBale);
			end;
		end;
	end;
end;