CutAreaEvent = {};
CutAreaEvent_mt = Class(CutAreaEvent, Event);

InitEventClass(CutAreaEvent, "CutAreaEvent");

function CutAreaEvent:emptyNew()
    local self = Event:new(CutAreaEvent_mt);
    self.className="CutAreaEvent";
    return self;
end;

function CutAreaEvent:new(cuttingAreas, fruitType)
    local self = CutAreaEvent:emptyNew()
    self.cuttingAreas = cuttingAreas;
    self.fruitType = fruitType;
    return self;
end;

function CutAreaEvent:readStream(streamId, connection)
    local fruitType = streamReadInt8(streamId, FruitUtil.sendNumBits);
    local numAreas = streamReadUIntN(streamId, 4)+1;
    local fruitDesc = FruitUtil.fruitIndexToDesc[fruitType]
	  
	  
    local params = g_currentMission.areaCompressionParams;
    local paramsRelative = g_currentMission.areaRelativeCompressionParams;
    for i=1, numAreas do
        local x = Utils.readCompressedWorldPosition(streamId, params);
        local z = Utils.readCompressedWorldPosition(streamId, params);
        local x1 = x + Utils.readCompressedWorldPosition(streamId, paramsRelative);
        local z1 = z + Utils.readCompressedWorldPosition(streamId, paramsRelative);
        local x2 = x + Utils.readCompressedWorldPosition(streamId, paramsRelative);
        local z2 = z + Utils.readCompressedWorldPosition(streamId, paramsRelative);
		
		Utils.updateFruitWindrowArea(fruitType, x, z, x1, z1, x2, z2, 0);

		if fruitType == FruitUtil.FRUITTYPE_GRASS or fruitType == FruitUtil.FRUITTYPE_DRYGRASS then
			Utils.switchFruitTypeArea(FruitUtil.FRUITTYPE_GRASS, FruitUtil.FRUITTYPE_DRYGRASS, x, z, x1, z1, x2, z2, 1)
		end;
    end;
end;

function CutAreaEvent:writeStream(streamId, connection)
    -- streamWriteInt8(streamId,self.fruitType);
    streamWriteInt8(streamId, self.fruitType, FruitUtil.sendNumBits);	
    local numAreas = table.getn(self.cuttingAreas);
    streamWriteUIntN(streamId, numAreas-1, 4);

	  
    local params = g_currentMission.areaCompressionParams;
    local paramsRelative = g_currentMission.areaRelativeCompressionParams;
    for i=1, numAreas do
        local d = self.cuttingAreas[i];
        Utils.writeCompressedWorldPosition(streamId, d[1], params);
        Utils.writeCompressedWorldPosition(streamId, d[2], params);
        Utils.writeCompressedWorldPosition(streamId, d[3] - d[1], paramsRelative);
        Utils.writeCompressedWorldPosition(streamId, d[4] - d[2], paramsRelative);
        Utils.writeCompressedWorldPosition(streamId, d[5] - d[1], paramsRelative);
        Utils.writeCompressedWorldPosition(streamId, d[6] - d[2], paramsRelative);
     end
end;

function CutAreaEvent:run(connection)
    print("Error: Do not run CutAreaEvent locally");
end;

function CutAreaEvent.runLocally(cuttingAreas, fillTypes, currentFillType)

    local numAreas = table.getn(cuttingAreas);
    local area = 0;	
    local params = g_currentMission.areaCompressionParams;
    local paramsRelative = g_currentMission.areaRelativeCompressionParams;
    for i=1, numAreas do
        local d = cuttingAreas[i];
        local x = Utils.simWriteCompressedWorldPosition(d[1], params);
        local z = Utils.simWriteCompressedWorldPosition(d[2], params);
        local x1 = x + Utils.simWriteCompressedWorldPosition(d[3] - d[1], paramsRelative);
        local z1 = z + Utils.simWriteCompressedWorldPosition(d[4] - d[2], paramsRelative);
        local x2 = x + Utils.simWriteCompressedWorldPosition(d[5] - d[1], paramsRelative);
        local z2 = z + Utils.simWriteCompressedWorldPosition(d[6] - d[2], paramsRelative);
		for fruitType,v in pairs(fillTypes) do
			if fruitType ~= Fillable.FILLTYPE_UNKNOWN then
				if currentFillType == fruitType or currentFillType == Fillable.FILLTYPE_UNKNOWN then
					local fruitType = FruitUtil.fillTypeToFruitType[fruitType];


					area = area + Utils.updateFruitWindrowArea(fruitType, x, z, x1, z1, x2, z2, 0);
					
					if area > 0 then
						if fruitType == FruitUtil.FRUITTYPE_GRASS or fruitType == FruitUtil.FRUITTYPE_DRYGRASS then
							Utils.switchFruitTypeArea(FruitUtil.FRUITTYPE_GRASS, FruitUtil.FRUITTYPE_DRYGRASS, x, z, x1, z1, x2, z2, 1)
						end;
						return area, fruitType;
					end;						
				end;
			end;
		end;
	
    end;
    return area, fruitType;
end;