planka = {};

function planka.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Attachable, specializations);
end;

function planka:load(xmlFile)	
		
local attacherJointPTS = {};
attacherJointPTS.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.attacherJointPTS#index"));
if attacherJointPTS.node ~= nil then
    attacherJointPTS.topReferenceNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.attacherJointPTS#topReferenceNode"));
    attacherJointPTS.rootNode = Utils.getNoNil(Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.attacherJointPTS#rootNode")), self.components[1].node);
    attacherJointPTS.fixedRotation = Utils.getNoNil(getXMLBool(xmlFile, "vehicle.attacherJointPTS#fixedRotation"), false);

    attacherJointPTS.allowsJointRotLimitMovement = Utils.getNoNil(getXMLBool(xmlFile, "vehicle.attacherJointPTS#allowsJointRotLimitMovement"), true);
    attacherJointPTS.allowsJointTransLimitMovement = Utils.getNoNil(getXMLBool(xmlFile, "vehicle.attacherJointPTS#allowsJointTransLimitMovement"), true);

    --load joint limit scales
    local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile,  "vehicle.attacherJointPTS#rotLimitScale"));
    attacherJointPTS.rotLimitScale = { Utils.getNoNil(x, 1), Utils.getNoNil(y, 1), Utils.getNoNil(z, 1) };
    local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile,  "vehicle.attacherJointPTS#transLimitScale"));
    attacherJointPTS.transLimitScale = { Utils.getNoNil(x, 1), Utils.getNoNil(y, 1), Utils.getNoNil(z, 1) };

    local jointTypeStr = getXMLString(xmlFile, "vehicle.attacherJointPTS#jointType")
    local jointType;
    if jointTypeStr ~= nil then
        jointType = Vehicle.jointTypeNameToInt[jointTypeStr];
        if jointType == nil then
            print("Warning: invalid jointType " .. jointTypeStr);
        end;
    else
        print("Warning: missing jointType");
    end;
    if jointType == nil then
        local needsTrailerJoint = Utils.getNoNil(getXMLBool(xmlFile, "vehicle.attacherJointPTS#needsTrailerJoint"), false);
        local needsLowTrailerJoint = Utils.getNoNil(getXMLBool(xmlFile, "vehicle.attacherJointPTS#needsLowJoint"), false);
        if needsTrailerJoint then
            if needsLowTrailerJoint then
                jointType = Vehicle.JOINTTYPE_TRAILERLOW;
            else
                jointType = Vehicle.JOINTTYPE_TRAILER;
            end;
        else
            jointType = Vehicle.JOINTTYPE_IMPLEMENT;
        end;
    end;
    attacherJointPTS.jointType = jointType;

    self.attacherJointPTS = attacherJoint;
end;

end;

function planka:delete()
end;

function planka:mouseEvent(posX, posY, isDown, isUp, button)
end;

function planka:keyEvent(unicode, sym, modifier, isDown)
end;

function planka:update(dt)
end;

function planka:draw()
end;