--
-- planka for Niva CK 5M
-- by Northern_Strike(RUS) for LSSA 
-- http://lssa.ru/
-- 24.01.12
-- 

Vehicle.registerJointType("planka");
Vehicle.registerJointType("plankaLow");

nivaplanka = {};

function nivaplanka.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Attachable, specializations);
end;

function nivaplanka:load(xmlFile)

local i=0;
while true do
    local baseName = string.format("vehicle.plankaAttacherJoints.plankaAttacherJoint(%d)", i);
    local index = getXMLString(xmlFile, baseName.. "#index");
    if index == nil then
        break;
    end;
    local object = Utils.indexToObject(instance.components, index);
    if object ~= nil then
        local entry = {};
        entry.jointTransform = object;
        entry.jointIndex = 0;
        local isLow = Utils.getNoNil(getXMLBool(xmlFile, baseName.."#low"), false);

        if isLow then
            entry.jointType = Vehicle.JOINTTYPE_plankaLOW;
        else
            entry.jointType = Vehicle.JOINTTYPE_planka;
        end;

        entry.allowsJointLimitMovement = Utils.getNoNil(getXMLBool(xmlFile, baseName.."#allowsJointLimitMovement"), false);
        entry.allowsLowering = false;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, baseName.."#maxRotLimit"));
        entry.maxRotLimit = {};
        entry.maxRotLimit[1] = Utils.degToRad(math.abs(Utils.getNoNil(x, 10)));
        entry.maxRotLimit[2] = Utils.degToRad(math.abs(Utils.getNoNil(y, 50)));
        entry.maxRotLimit[3] = Utils.degToRad(math.abs(Utils.getNoNil(z, 50)));

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, baseName.."#minRotLimit"));
        entry.minRotLimit = {};
        entry.minRotLimit[1] = math.rad(math.abs(Utils.getNoNil(x, 0)));
        entry.minRotLimit[2] = math.rad(math.abs(Utils.getNoNil(y, 0)));
        entry.minRotLimit[3] = math.rad(math.abs(Utils.getNoNil(z, 0)));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, baseName.."#maxTransLimit"));
        entry.maxTransLimit = {};
        entry.maxTransLimit[1] = math.abs(Utils.getNoNil(x, 0));
        entry.maxTransLimit[2] = math.abs(Utils.getNoNil(y, 0));
        entry.maxTransLimit[3] = math.abs(Utils.getNoNil(z, 0));

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, baseName.."#minTransLimit"));
        entry.minTransLimit = {};
        entry.minTransLimit[1] = math.abs(Utils.getNoNil(x, 0));
        entry.minTransLimit[2] = math.abs(Utils.getNoNil(y, 0));
        entry.minTransLimit[3] = math.abs(Utils.getNoNil(z, 0));

        entry.rootNode = Utils.getNoNil(Utils.indexToObject(instance.components, getXMLString(xmlFile, baseName.."#rootNode")), instance.components[1].node);

        table.insert(instance.attacherJoints, entry);
    end;
    i = i+1;
end;	

end;

function nivaplanka:delete()
end;

function nivaplanka:readStream(streamId, connection)
end;

function nivaplanka:writeStream(streamId, connection)
end;

function nivaplanka:readUpdateStream(streamId, timestamp, connection)
end;

function nivaplanka:writeUpdateStream(streamId, connection, dirtyMask)
end;

function nivaplanka:mouseEvent(posX, posY, isDown, isUp, button)
end;

function nivaplanka:keyEvent(unicode, sym, modifier, isDown)

end;

function nivaplanka:update(dt)
end;

function nivaplanka:updateTick(dt)
end;

function nivaplanka:draw()

end;

function nivaplanka:onDetach()
end;

function nivaplanka:onAttach()
end;

function nivaplanka:onLeave()

end;

function nivaplanka:onDeactivate()
end;