--
-- kolosSzK
-- This is the specialization for combines
--
-- @author  Stefan Geiger
-- @date  30/11/08
--
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.

kolosSzK = {};

function NIVACK5M.prerequisitesPresent(specializations)
	return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function NIVACK5M:load(xmlFile)

		self.nivapunActive = false;

local gazNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.NIVACK5M.gaz#index"));
    if gazNode ~= nil then
        self.gaz = {};
        self.gaz.node = gazNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.NIVACK5M.gaz#minRot"));
        self.gaz.minRot = {};
        self.gaz.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.gaz.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.gaz.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.NIVACK5M.gaz#maxRot"));
        self.gaz.maxRot = {};
        self.gaz.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.gaz.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.gaz.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        self.gaz.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.NIVACK5M.gaz#rotTime"), 2)*1000;
        self.gaz.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.NIVACK5M.gaz#touchRotLimit"), 10));
    end;

	local translationOknoNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.NIVACK5M.translationOkno#index"));
    if translationOknoNode ~= nil then
        self.translationOkno = {};
        self.translationOkno.node = translationOknoNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.NIVACK5M.translationOkno#minTrans"));
        self.translationOkno.minTrans = {};
        self.translationOkno.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationOkno.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationOkno.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.NIVACK5M.translationOkno#maxTrans"));
        self.translationOkno.maxTrans = {};
        self.translationOkno.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationOkno.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationOkno.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translationOkno.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.NIVACK5M.translationOkno#transTime"), 2)*1000;
        self.translationOkno.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.NIVACK5M.translationOkno#touchTransLimit"), 10);
    end;

	self.dumParticle = {};
    local i = 0;
    while true do
        local namei = string.format("vehicle.NIVACK5M.dum.dum(%d)", i);
		local nodei = Utils.indexToObject(self.components, getXMLString(xmlFile, namei .. "#index"));
		if nodei == nil then
			break;
		end; 
        Utils.loadParticleSystem(xmlFile, self.dumParticle, namei, nodei, false, nil, self.baseDirectory)		
		Utils.setEmittingState(self.dumParticle,false)
		self.particleSystemdisableTime = 0;
		i = i +1;		
    end;

    self.keys = {};
    local i=0;
    while true do
        local baseName = string.format("vehicle.keys.input(%d)", i);
        local inputName = getXMLString(xmlFile, baseName.. "#name");
        if inputName == nil then
            break;
        end;
        local inputKey = getXMLString(xmlFile, baseName.. "#key");
        if Input[inputKey] == nil then
            print("Error: invalid key '" .. inputKey .. "'  for input event '" .. inputName .. "'");
            break;
        end;
        self.keys[inputName] = Input[inputKey];
        i = i+1;
    end;

local rotationPartNoderuchnik = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.NIVACK5M.ruchnik#index"));

    if rotationPartNoderuchnik ~= nil then
        self.rotationPartruchnik = {};
        self.rotationPartruchnik.node = rotationPartNoderuchnik;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.NIVACK5M.ruchnik#minRot"));
        self.rotationPartruchnik.minRot = {};
        self.rotationPartruchnik.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartruchnik.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartruchnik.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.NIVACK5M.ruchnik#maxRot"));
        self.rotationPartruchnik.maxRot = {};
        self.rotationPartruchnik.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartruchnik.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartruchnik.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartruchnik.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.NIVACK5M.ruchnik#rotTime"), 2)*1000;
        self.rotationPartruchnik.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.NIVACK5M.ruchnik#touchRotLimit"), 10));
    end;

		self.shnek = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.NIVACK5M.shnek#index"));
		self.shnek1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.NIVACK5M.shnek1#index"));

     local rotationPartNoderuchag2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.NIVACK5M.ruchag2#index"));
    if rotationPartNoderuchag2 ~= nil then
        self.rotationPartruchag2 = {};
        self.rotationPartruchag2.node = rotationPartNoderuchag2;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.NIVACK5M.rotationPartruchag2#minRot"));
        self.rotationPartruchag2.minRot = {};
        self.rotationPartruchag2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartruchag2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartruchag2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.NIVACK5M.ruchag2#maxRot"));
        self.rotationPartruchag2.maxRot = {};
        self.rotationPartruchag2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartruchag2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartruchag2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartruchag2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.NIVACK5M.ruchag2#rotTime"), 2)*1000;
        self.rotationPartruchag2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.NIVACK5M.ruchag2#touchRotLimit"), 10));
    end;

     local rotationPartNoderuchag1 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.NIVACK5M.ruchag1#index"));
    if rotationPartNoderuchag1 ~= nil then
        self.rotationPartruchag1 = {};
        self.rotationPartruchag1.node = rotationPartNoderuchag1;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.NIVACK5M.rotationPartruchag1#minRot"));
        self.rotationPartruchag1.minRot = {};
        self.rotationPartruchag1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartruchag1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartruchag1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.NIVACK5M.ruchag1#maxRot"));
        self.rotationPartruchag1.maxRot = {};
        self.rotationPartruchag1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartruchag1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartruchag1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartruchag1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.NIVACK5M.ruchag1#rotTime"), 2)*1000;
        self.rotationPartruchag1.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.NIVACK5M.ruchag1#touchRotLimit"), 10));
    end;


     local rotationPartNodedver1 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.NIVACK5M.dver1#index"));
    if rotationPartNodedver1 ~= nil then
        self.rotationPartdver1 = {};
        self.rotationPartdver1.node = rotationPartNodedver1;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.NIVACK5M.rotationPartdver1#minRot"));
        self.rotationPartdver1.minRot = {};
        self.rotationPartdver1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartdver1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartdver1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.NIVACK5M.dver1#maxRot"));
        self.rotationPartdver1.maxRot = {};
        self.rotationPartdver1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartdver1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartdver1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartdver1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.NIVACK5M.dver1#rotTime"), 2)*1000;
        self.rotationPartdver1.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.NIVACK5M.dver1#touchRotLimit"), 10));
    end;

       self.ventelator1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.NIVACK5M.ventelator1#index"));
	   
    local attachNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.NIVACK5M.attach#index"));
    if attachNode ~= nil then
        self.attach = {};
        self.attach.node = attachNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.NIVACK5M.attach#minRot"));
        self.attach.minRot = {};
        self.attach.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.attach.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.attach.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.NIVACK5M.attach#maxRot"));
        self.attach.maxRot = {};
        self.attach.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.attach.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.attach.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.attach.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.NIVACK5M.attach#rotTime"), 2)*1000;
        self.attach.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.NIVACK5M.attach#touchRotLimit"), 10));
    end;	
	
end;


function NIVACK5M:mouseEvent(posX, posY, isDown, isUp, button)
end;

function NIVACK5M:keyEvent(unicode, sym, modifier, isDown)

		if sym == Input.KEY_KP_3 then
			self.MaxGaz = isDown;
		end;
		
		if sym == Input.KEY_KP_1 then
			self.gazMin = isDown;
			self.MinGaz = isDown;
		end;

		if sym == Input.KEY_KP_3 then
			self.gazMax = isDown;
			self.MaxGaz = isDown;
		end;
		
		if sym == Input.KEY_KP_5 then
			self.translationOknoMax = isDown;
		end;
		
		if sym == Input.KEY_KP_2 then
			self.translationOknoMin = isDown;
		end;
		
	if isDown and sym == self.keys.ruchnik then
		self.handbrake = not self.handbrake
	end;

	if sym == Input.KEY_pagedown then
		self.attachMax = isDown;
	end;
	if sym == Input.KEY_pageup then
		self.attachMin = isDown;
	end;

end;

function NIVACK5M:update(dt)

local doRotate = self.gazMax or self.gazMin 
		if self.gaz ~= nil and doRotate then
        	local x, y, z = getRotation(self.gaz.node);
        	local rot = {x,y,z};
        	local newRot = Utils.getMovedLimitedValues(rot, self.gaz.maxRot, self.gaz.minRot, 3, self.gaz.rotTime, dt, not self.gazMax);
        	setRotation(self.gaz.node, unpack(newRot));
		end;

	local doTranslate = self.translationOknoMax or self.translationOknoMin 
	if self.translationOkno ~= nil and doTranslate then 
		local x, y, z = getTranslation(self.translationOkno.node); 
		local trans = {x,y,z}; 
		local newTrans = Utils.getMovedLimitedValues(trans, self.translationOkno.maxTrans, self.translationOkno.minTrans, 3, self.translationOkno.transTime, dt, not self.translationOknoMax); 
		setTranslation(self.translationOkno.node, unpack(newTrans));
	end; 

	Utils.setEmittingState(self.dumParticle, self.dum);

if self:getIsActiveForInput() then
        if self.MaxGaz then
		    self.motor.minRpm = self.motor.minRpm - 50;
		elseif self.MinGaz then
		    self.motor.minRpm = self.motor.minRpm + 50;
	    end;
    end;

    if self.isEntered then
		if self.motor.minRpm < -1600 then
			self.motor.minRpm = -1600;
		elseif self.motor.minRpm > 100 then
			self.motor.minRpm = 100;
		end;

	end;

if self.rotationPartruchnik  ~= nil then
		local x, y, z = getRotation(self.rotationPartruchnik .node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartruchnik.maxRot, self.rotationPartruchnik.minRot, 3, self.rotationPartruchnik.rotTime, dt, not self.rotationMaxruchnik);
		setRotation(self.rotationPartruchnik .node, unpack(newRot));
	end;

	if self.handbrake then
		self.motor.backwardGearRatio = 0;
		self.motor.forwardGearRatios = {0, 0, 0};
		self.motor.brakeForce = 100;	
		self.rotationMaxruchnik = true;
	else
		self.motor.backwardGearRatio = 2.8;
		self.motor.forwardGearRatios = {3.5, 3.5, 3.5};
		self.motor.brakeForce = 7;	
		self.rotationMaxruchnik = false;
	end;

	if self.pipeIsUnloading then
	self:setAnimationTime(3, self.animationParts[3].animDuration);	
	else
		self:setAnimationTime(3, self.animationParts[3].offSet);
	end;
	
	if self.pipeIsUnloading then
		rotate(self.shnek, dt*0.005, 0, 0 );	
		rotate(self.shnek1, dt*0.005, 0, 0 );	
	end;

	    if self.rotationPartruchag2 ~= nil then
		   local x, y, z = getRotation(self.rotationPartruchag2.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartruchag2.maxRot, self.rotationPartruchag2.minRot, 3, self.rotationPartruchag2.rotTime, dt, not self.rotationMaxruchag2);
		   setRotation(self.rotationPartruchag2.node, unpack(newRot));
        end;
		
		if self.isThreshing then
		self.nivapunActive = true;
		self.dum = true;
		self.rotationMaxruchag1 = true;
		self.rotationMaxruchag2 = true;
		else
		self.nivapunActive = false;
		self.dum = false;
		self.rotationMaxruchag1 = false;
		self.rotationMaxruchag2 = false;
		end;

	    if self.rotationPartruchag1 ~= nil then
		   local x, y, z = getRotation(self.rotationPartruchag1.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartruchag1.maxRot, self.rotationPartruchag1.minRot, 3, self.rotationPartruchag1.rotTime, dt, not self.rotationMaxruchag1);
		   setRotation(self.rotationPartruchag1.node, unpack(newRot));
        end;

if self.inrange or self.isEntered then
	if InputBinding.hasEvent(InputBinding.dver1_niva) then
		self.rotationMaxdver1 = not self.rotationMaxdver1;
	end;  
end; 

	    if self.rotationPartdver1 ~= nil then
		   local x, y, z = getRotation(self.rotationPartdver1.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartdver1.maxRot, self.rotationPartdver1.minRot, 3, self.rotationPartdver1.rotTime, dt, not self.rotationMaxdver1);
		   setRotation(self.rotationPartdver1.node, unpack(newRot));
        end;

	if self.isMotorStarted then
         		rotate(self.ventelator1, dt*0.03, 0, 0 );		
	end;

	local doRotate = self.attachMax or self.attachMin 
	if self.attach ~= nil and doRotate then
        	local x, y, z = getRotation(self.attach.node);		
        	local rot = {x,y,z};
        	local newRot = Utils.getMovedLimitedValues(rot, self.attach.maxRot, self.attach.minRot, 3, self.attach.rotTime, dt, not self.attachMax);
        	setRotation(self.attach.node, unpack(newRot));
	end;  

	
	if self.setAnimationTime ~= nil then
		if self.isThreshing then
			self:setAnimationTime(1, 1);
		else
			self:setAnimationTime(1, 0);
		end;
	end;

	if self.setAnimationTime ~= nil then
		if self.isMotorStarted then
			self:setAnimationTime(2, 1);
		else
			self:setAnimationTime(2, 0);
		end;
	end;
	
end;

function NIVACK5M:updateTick(dt)
if g_currentMission.player ~= nil then
		-- Getting the distance between the player and the implement 
		local nearestDistance = 4.0; --max distance allowed
		local px, py, pz = getWorldTranslation(self.rootNode); 
		local vx, vy, vz = getWorldTranslation(g_currentMission.player.rootNode);
		local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);	
		if distance < nearestDistance then
			self.inrange = true; 
		else
			self.inrange = false; 
		end;
end;
end;

function NIVACK5M:draw()

end;


function NIVACK5M:onLeave()

		self.rotationMaxdver1 = true;

end;

function NIVACK5M:delete()

end;

function key_convert(key)
    if key ~= nil then 
	    local keyname = "";
	    if key > 32 and key < 123 then
	    	keyname = string.upper(string.char(key));
	    elseif key > 255 and key < 266 then
	    	keyname = "NUM "..string.char(key-208);
	    else 
	    	keyname = "";
	    end;
	    return(keyname);
	  end;
end;

function NIVACK5M:validateAttacherJoint(implement, jointDesc, dt)
    return true;
end;