--
-- NHCR9090
-- Specialization for New Holland CR 9090 Elevation mod
--
-- @author  wohlstandskind
-- @date  20/12/09
-- @beacon-lights by Sven777b
-- @last edit 26/12/09 by yekk1

NHCR9090 = {};

function NHCR9090.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function NHCR9090:load(xmlFile)

self.TreshedNumber = 0;
self.TreshedTotalNumber = 0;

function NHCR9090:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
   local TreshedTotalNumber =  Utils.getNoNil(getXMLFloat(xmlFile, key.."#TreshedTotalNumber"),0);
   self.TreshedTotalNumber = TreshedTotalNumber;
    return BaseMission.VEHICLE_LOAD_OK;
	end;

	local numWorkLights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.workLights#count"), 0);
    self.workLights = {};
    for i=1, numWorkLights do
        local worklightnamei = string.format("vehicle.workLights.workLight%d", i);
        self.workLights[i] = Utils.indexToObject(self.components, getXMLString(xmlFile, worklightnamei .. "#index"));
        setVisibility(self.workLights[i], false);
    end;
	self.workLightsActive = false;

	print("specialization rundumleuchten by Sven777b");
	local i = 0;
	self.rundumleuchten = {};
    self.rundumleuchtenAn = false;
	while true do
		local rul = {};
		local objname = string.format("vehicle.rundumleuchten.rundumleuchte(%d)",i);
      	local rotnode = getXMLString(xmlFile, objname .. "#rotNode");
      	if rotnode == nil then 
      		break;
     end;
     
      rul = {};
      rul.rotNode = Utils.indexToObject(self.components, rotnode);
      rul.light = Utils.indexToObject(self.components, getXMLString(xmlFile, objname .. "#light"));
      if(rul.rotNode == nil or rul.light == nil) then
      	print("Error: Index ("..rotnode..") zur Rundumleuchte nicht gefunden");
      else
	      rul.speed = Utils.getNoNil(getXMLInt(xmlFile,  objname .. "#rotSpeed"), 1)/1000;
	      rul.source = Utils.indexToObject(self.components, getXMLString(xmlFile, objname .. "#lightsource"));
	      if (rul.source == nil) then
	      	rul.emit = false;
	      else
      		rul.emit = Utils.getNoNil(getXMLBool(xmlFile, objname .. "#emitLight"), true);
      		if not rul.emit then
      			setVisibility(rul.source, false);
      		end;
      	end;
      	table.insert(self.rundumleuchten, rul);
      end;
      i=i+1;
    end;
    self.rundumleuchtenAnz = table.getn(self.rundumleuchten);

    self.hudInfoBasePosX = 0.833;
    self.hudInfoBaseWidth = 0.17;
    self.hudInfoBasePosY = 0.1725;
    self.hudInfoBaseHeight = 0.55;
    self.infoPanelPath = Utils.getFilename("NHCR9090_HUD.dds", self.baseDirectory);
	  self.hudInfoBaseOverlay = Overlay:new("hudInfoBaseOverlay", self.infoPanelPath, self.hudInfoBasePosX, self.hudInfoBasePosY, self.hudInfoBaseWidth, self.hudInfoBaseHeight);
    self.showHudInfoBase = true;

    local motorMinRpm = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motor#minRpm"), 1000);
    local motorMaxRpmStr = getXMLString(xmlFile, "vehicle.motor#maxRpm");
    local motorMaxRpm1, motorMaxRpm2, motorMaxRpm3 = Utils.getVectorFromString(motorMaxRpmStr);
    motorMaxRpm1 = Utils.getNoNil(motorMaxRpm1, 800);
    motorMaxRpm2 = Utils.getNoNil(motorMaxRpm2, 1000);
    motorMaxRpm3 = Utils.getNoNil(motorMaxRpm3, 1800);
    local motorMaxRpm = {motorMaxRpm1, motorMaxRpm2, motorMaxRpm3};
    self.motorMaxRpmLimit = motorMaxRpm;
    
    self.rotorFan2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotorFan2#index"));
    self.rotorFan3 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rotorFan3#index"));
    
    local rotationPartNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPart#index"));
    if rotationPartNode ~= nil then
        self.rotationPart = {};
        self.rotationPart.node = rotationPartNode;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart#minRot"));
        self.rotationPart.minRot = {};
        self.rotationPart.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart#maxRot"));
        self.rotationPart.maxRot = {};
        self.rotationPart.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPart.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart#rotTime"), 2)*1000;
        self.rotationPart.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart#touchRotLimit"), 10));
     end;
     
     
     local rotationPartNode2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPart2#index"));
     if rotationPartNode2 ~= nil then
        self.rotationPart2 = {};
        self.rotationPart2.node = rotationPartNode2;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart2#minRot"));
        self.rotationPart2.minRot = {};
        self.rotationPart2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart2#maxRot"));
        self.rotationPart2.maxRot = {};
        self.rotationPart2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPart2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart2#rotTime"), 2)*1000;
        self.rotationPart2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart2#touchRotLimit"), 10));
     end;
     
     
     local rotationPartNode3 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPart3#index"));
     if rotationPartNode3 ~= nil then
        self.rotationPart3 = {};
        self.rotationPart3.node = rotationPartNode3;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart3#minRot"));
        self.rotationPart3.minRot = {};
        self.rotationPart3.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart3.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart3.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart3#maxRot"));
        self.rotationPart3.maxRot = {};
        self.rotationPart3.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart3.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart3.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPart3.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart3#rotTime"), 2)*1000;
        self.rotationPart3.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart3#touchRotLimit"), 10));
     end;
     
     
     local rotationPartNode4 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPart4#index"));
     if rotationPartNode4 ~= nil then
        self.rotationPart4 = {};
        self.rotationPart4.node = rotationPartNode4;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart4#minRot"));
        self.rotationPart4.minRot = {};
        self.rotationPart4.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart4.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart4.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart4#maxRot"));
        self.rotationPart4.maxRot = {};
        self.rotationPart4.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart4.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart4.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPart4.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart4#rotTime"), 2)*1000;
        self.rotationPart4.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart4#touchRotLimit"), 10));
     end;
     
     
     local rotationPartNode5 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPart5#index"));
     if rotationPartNode5 ~= nil then
        self.rotationPart5 = {};
        self.rotationPart5.node = rotationPartNode5;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart5#minRot"));
        self.rotationPart5.minRot = {};
        self.rotationPart5.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart5.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart5.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart5#maxRot"));
        self.rotationPart5.maxRot = {};
        self.rotationPart5.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart5.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart5.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPart5.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart5#rotTime"), 2)*1000;
        self.rotationPart5.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart5#touchRotLimit"), 10));
     end;
     
     
     local rotationPartNode6 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPart6#index"));
     if rotationPartNode6 ~= nil then
        self.rotationPart6 = {};
        self.rotationPart6.node = rotationPartNode6;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart6#minRot"));
        self.rotationPart6.minRot = {};
        self.rotationPart6.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart6.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart6.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart6#maxRot"));
        self.rotationPart6.maxRot = {};
        self.rotationPart6.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart6.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart6.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPart6.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart6#rotTime"), 2)*1000;
        self.rotationPart6.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart6#touchRotLimit"), 10));
     end;

     local rotationPartNode7 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPart7#index"));
     if rotationPartNode7 ~= nil then
        self.rotationPart7 = {};
        self.rotationPart7.node = rotationPartNode7;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart7#minRot"));
        self.rotationPart7.minRot = {};
        self.rotationPart7.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart7.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart7.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart7#maxRot"));
        self.rotationPart7.maxRot = {};
        self.rotationPart7.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart7.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart7.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPart7.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart7#rotTime"), 2)*1000;
        self.rotationPart7.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart7#touchRotLimit"), 10));
     end;
end;

function NHCR9090:delete()

if self.hudInfoBaseOverlay ~= nil then
		self.hudInfoBaseOverlay:delete();
	end;
	for k, worklight in pairs(self.workLights) do
		setVisibility(worklight, false);
	end;
	self.workLightsActive = false;
	
end;

function NHCR9090:getSaveAttributesAndNodes(nodeIdent)
   local TreshedTotalNumber= Utils.getNoNil(self.TreshedTotalNumber, 10);
    local attributes = 'TreshedTotalNumber="'..string.format("%.1f",TreshedTotalNumber)..'"';
   return attributes, nil;
end;

 
function NHCR9090:mouseEvent(posX, posY, isDown, isUp, button)
end;
 
function NHCR9090:keyEvent(unicode, sym, modifier, isDown)

if InputBinding.isPressed(InputBinding.workmode) then
		self.rotationMax = not self.rotationMax;
	end;

end;

function NHCR9090:update(dt)

		if self.isThreshing then
		local pixelToQm = 2048 / 4096 * 2048 / 4096; -- 4096px are mapped to 2048m
		self.TreshedNumber = self.TreshedNumber + self.lastArea*pixelToQm/(40000);
		self.TreshedTotalNumber = self.TreshedTotalNumber + self.lastArea*pixelToQm/(40000);
		end;

		local prozent = self.grainTankFillLevel/self.grainTankCapacity*100;
		if prozent > 0 then
		renderText(0.78, 0.84, 0.02,""..string.format("CR9090: %.0f (%d%%)", self.grainTankFillLevel-1, prozent).."");
		end;

		if self.isThreshing then
			self.rotationMax = true;
		end;

if self.isEntered then
		if InputBinding.hasEvent(InputBinding.TOGGLEHUD) then
			self.showHudInfoBase = not self.showHudInfoBase;
		end;
	end;

if self.isEntered then
		if InputBinding.hasEvent(InputBinding.WORKLIGHTS) then
			self.workLightsActive = not self.workLightsActive;
		end;
	
		for k, worklight in pairs(self.workLights) do
			setVisibility(worklight, self.workLightsActive);
		end;
	end;

if self.rundumleuchtenAnz > 0 and self:getIsActive() then
    if InputBinding.hasEvent(InputBinding.RUNDUMLEUCHTE) then
    	self.rundumleuchtenAn = not self.rundumleuchtenAn;
      for i=1, self.rundumleuchtenAnz do
        setVisibility(self.rundumleuchten[i].light, self.rundumleuchtenAn);
      end;
    end;
    if self.rundumleuchtenAn then
      for i=1, self.rundumleuchtenAnz do
        rotate(self.rundumleuchten[i].rotNode, 0, dt*self.rundumleuchten[i].speed, 0);
      end;
    end;
  end;

if self:getIsActiveForInput() and self.isEntered then
	    if self.motor.speedLevel ~= 0 then
            if InputBinding.isPressed(InputBinding.ACCELERATE) then
		        if self.motor.maxRpm[self.motor.speedLevel] <= (self.motorMaxRpmLimit[3] - 15) then
		            self.motor.maxRpm[self.motor.speedLevel] = self.motor.maxRpm[self.motor.speedLevel] + 15;
			    end;
		    elseif InputBinding.isPressed(InputBinding.DECELERATE) then
		        if self.motor.maxRpm[self.motor.speedLevel] >= 10 then
			        self.motor.maxRpm[self.motor.speedLevel] = self.motor.maxRpm[self.motor.speedLevel] - 15;
			    end;
	    	end;
		else
            if InputBinding.isPressed(InputBinding.ACCELERATE) then
		        if self.motor.maxRpm[3] <= (self.motorMaxRpmLimit[3] - 15) then
		            self.motor.maxRpm[3] = self.motor.maxRpm[3] + 10;
			    end;
		    elseif InputBinding.isPressed(InputBinding.DECELERATE) then
		        if self.motor.maxRpm[3] >= 10 then
			        self.motor.maxRpm[3] = self.motor.maxRpm[3] - 15;
			    end;
	    	end;
		end;
end;
          
        if self.isThreshing and self.rotorFan2 ~= nil then
          rotate(self.rotorFan2, dt*0.009, 0, 0);
        end;

        if self.isThreshing and self.rotorFan3 ~= nil then
          rotate(self.rotorFan3, dt*0.009, 0, 0);
        end;

        if self.rotationPart ~= nil then
          local x, y, z = getRotation(self.rotationPart.node);
           local rot = {x,y,z};
            local newRot = Utils.getMovedLimitedValues(rot, self.rotationPart.maxRot, self.rotationPart.minRot, 3, self.rotationPart.rotTime, dt, not self.rotationMax);
              setRotation(self.rotationPart.node, unpack(newRot));
        end;
        
        if self.rotationPart2 ~= nil then
          local x, y, z = getRotation(self.rotationPart2.node);
           local rot = {x,y,z};
            local newRot = Utils.getMovedLimitedValues(rot, self.rotationPart2.maxRot, self.rotationPart2.minRot, 3, self.rotationPart2.rotTime, dt, not self.rotationMax);
              setRotation(self.rotationPart2.node, unpack(newRot));
        end;
        
        if self.rotationPart3 ~= nil then
          local x, y, z = getRotation(self.rotationPart3.node);
           local rot = {x,y,z};
            local newRot = Utils.getMovedLimitedValues(rot, self.rotationPart3.maxRot, self.rotationPart3.minRot, 3, self.rotationPart3.rotTime, dt, not self.rotationMax);
              setRotation(self.rotationPart3.node, unpack(newRot));
        end;
        
        if self.rotationPart4 ~= nil then
          local x, y, z = getRotation(self.rotationPart4.node);
           local rot = {x,y,z};
            local newRot = Utils.getMovedLimitedValues(rot, self.rotationPart4.maxRot, self.rotationPart4.minRot, 3, self.rotationPart4.rotTime, dt, not self.rotationMax);
              setRotation(self.rotationPart4.node, unpack(newRot));
        end;
        
        if self.rotationPart5 ~= nil then
          local x, y, z = getRotation(self.rotationPart5.node);
           local rot = {x,y,z};
            local newRot = Utils.getMovedLimitedValues(rot, self.rotationPart5.maxRot, self.rotationPart5.minRot, 3, self.rotationPart5.rotTime, dt, not self.rotationMax);
              setRotation(self.rotationPart5.node, unpack(newRot));
        end;
        
        if self.rotationPart6 ~= nil then
          local x, y, z = getRotation(self.rotationPart6.node);
           local rot = {x,y,z};
            local newRot = Utils.getMovedLimitedValues(rot, self.rotationPart6.maxRot, self.rotationPart6.minRot, 3, self.rotationPart6.rotTime, dt, not self.rotationMax);
              setRotation(self.rotationPart6.node, unpack(newRot));
        end;        

        if self.rotationPart7 ~= nil then
          local x, y, z = getRotation(self.rotationPart7.node);
           local rot = {x,y,z};
            local newRot = Utils.getMovedLimitedValues(rot, self.rotationPart7.maxRot, self.rotationPart7.minRot, 3, self.rotationPart7.rotTime, dt, not self.rotationMax);
              setRotation(self.rotationPart7.node, unpack(newRot));
        end;    
end;

function NHCR9090:onLeave()
	for k, worklight in pairs(self.workLights) do
		setVisibility(worklight, false);
	end;
	self.workLightsActive = false;
end;

function NHCR9090:draw()

	if not self.rotationMax and not self.pipeOpen and InputBinding.isPressed(InputBinding.EMPTY_GRAIN) then
		g_currentMission:addWarning("CHANGE TO FIELDMODE FIRST",0.09,0.03);
	end;


	if self.showHudInfoBase and self.isEntered then
		self.hudInfoBaseOverlay:render();

		setTextBold(true);
		renderText(0.835, 0.350, 0.021, string.format("Hectare"));
		renderText(0.835, 0.335, 0.021, string.format("Today"));
		renderText(0.835, 0.315, 0.021, string.format("%.1f", self.TreshedNumber));
		renderText(0.835, 0.285, 0.021, string.format("Hectare"));
		renderText(0.835, 0.270, 0.021, string.format("SUM"));
		renderText(0.835, 0.250, 0.021, string.format("%.1f", self.TreshedTotalNumber));
		setTextBold(false);
	end;

	if self.motor.speedLevel ~= 0 then
            g_currentMission:addExtraPrintText("Key NUM +/-:   "..string.format("%d RPM",self.motor.maxRpm[self.motor.speedLevel]).."");
	else
            g_currentMission:addExtraPrintText("Key NUM +/-:   "..string.format("%d RPM",self.motor.maxRpm[3]).."");
	end;
	
	--Kompass
	local x,y,z = localDirectionToWorld(self.rootNode, 0, 0, 1);
	local length = Utils.vector2Length(x,z);
	local dX = x/length;
	local dZ = z/length;
	local Richtung = math.deg(math.atan2(dX,dZ));
	if Richtung < 0  then 
		Richtung = 360 - (Richtung * -1);
    end;
	renderText(0.60,0.95,0.03,string.format("Compass: %3.0f ",360 - math.floor(Richtung + 0.5) ));
end;

function NHCR9090:openPipe()
    self.pipeOpening = self.rotationMax;
end;