-- author: rafftnix
-- date: 25.05.2014

MapTreePlacement = {}

function MapTreePlacement.onCreate(id)
	local x, y, z = getWorldTranslation(id);
	local xr, yr, zr = getRotation(id);
	
	if g_currentMission.missionStats.traveledDistanceTotal == 0 and g_server ~= nil then
		local treeType = Utils.getNoNil(getUserAttribute(id, "treeType"), "fir");
		local treeIndex = Utils.getNoNil(getUserAttribute(id, "treeIndex"), 1);
		local scale = Utils.getNoNil(getUserAttribute(id, "scale"), 1);
		table.insert(aForestMod.TreeManager.treesToPlace, {x,y,z,yr,treeType,treeIndex,scale})
	end;
	
	delete(id);
end;

g_onCreateUtil.addOnCreateFunction("onCreateMapTreePlacement", MapTreePlacement.onCreate);