--
-- FarmHUD
-- Shows Farm Silo Amounts
--
-- @author  	eRaZeR (Schwabenmodding)
-- @version 	v1.0
-- @date  		29/07/13
--

PosX=0.670;		--Changes the X Position, Value [0,1]
PosY=0.878;		--Changes the Y Position, Value [0,1]
show=true;		--Visibility at Game Start
FarmHUD = {};
overlayPath=g_currentModDirectory.."Overlay.dds";

function FarmHUD:loadMap(name)
	self.Overlay=createImageOverlay(overlayPath);
end;
function FarmHUD:deleteMap()
end;
function FarmHUD:mouseEvent(posX, posY, isDown, isUp, button)
end;
function FarmHUD:keyEvent(unicode, sym, modifier, isDown)
end;
function FarmHUD:update(dt)
	if InputBinding.hasEvent(InputBinding.TOGGLE_FARMHUD) then
		show=not show;
	end;
end;
function FarmHUD:updateTick(dt)
end;
function FarmHUD:draw()
	if PosX < 1 and PosY < 1 and PosX > 0 and PosY > 0 then
		if show == true then
			local Font=0.015;
			local TPosX=PosX+0.005;
			local TPosYBegin=PosY+0.086;
			local APosX=PosX+0.092;
			setTextColor(1, 1, 1, 1);	
			-- Render Overlay
			renderOverlay(self.Overlay, PosX, PosY, 0.144, 0.11);
			renderText(TPosX, TPosYBegin, Font, g_i18n:getText("Wheat_storage")..":");
			renderText(TPosX, TPosYBegin-Font, Font, g_i18n:getText("Barley_storage")..":");
			renderText(TPosX, TPosYBegin-Font*2, Font, g_i18n:getText("Rapeseed_storage")..":");
			renderText(TPosX, TPosYBegin-Font*3, Font, g_i18n:getText("Maize_storage")..":");
			renderText(TPosX, TPosYBegin-Font*4, Font, g_i18n:getText("Potato_storage")..":");
			renderText(TPosX, TPosYBegin-Font*5, Font, g_i18n:getText("SugarBeet_storage")..":");
			-- Render Amounts
			renderText(APosX, TPosYBegin, Font, string.format("%1.0f",g_currentMission:getSiloAmount(Fillable.FILLTYPE_WHEAT)).." "..g_i18n:getText("fluid_unit_short"));
			renderText(APosX, TPosYBegin-Font, Font, string.format("%1.0f",g_currentMission:getSiloAmount(Fillable.FILLTYPE_BARLEY)).." "..g_i18n:getText("fluid_unit_short"));
			renderText(APosX, TPosYBegin-Font*2, Font, string.format("%1.0f",g_currentMission:getSiloAmount(Fillable.FILLTYPE_RAPE)).." "..g_i18n:getText("fluid_unit_short"));
			renderText(APosX, TPosYBegin-Font*3, Font, string.format("%1.0f",g_currentMission:getSiloAmount(Fillable.FILLTYPE_MAIZE)).." "..g_i18n:getText("fluid_unit_short"));
			renderText(APosX, TPosYBegin-Font*4, Font, string.format("%1.0f",g_currentMission:getSiloAmount(Fillable.FILLTYPE_POTATO)).." "..g_i18n:getText("fluid_unit_short"));
			renderText(APosX, TPosYBegin-Font*5, Font, string.format("%1.0f",g_currentMission:getSiloAmount(Fillable.FILLTYPE_SUGARBEET)).." "..g_i18n:getText("fluid_unit_short"));
		end;
	end;
end;

addModEventListener(FarmHUD);