--
-- SampleModMap
--
-- @author  Stefan Geiger
-- @date  06/08/12
--
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.

SampleModMap = {}

local SampleModMap_mt = Class(SampleModMap, Mission00);


function SampleModMap:new(baseDirectory, customMt)
    FruitUtil.registerFruitType("dinkel", g_i18n:getText("dinkel"), true, true, false, 0, 4, 6, 8, true, 0.4, 3, 0.05, true, Utils.getFilename("huds/dinkelHud.dds", baseDirectory), {2,0,0.1,1});
    FruitUtil.registerFruitType("oat", g_i18n:getText("oat"), true, true, false, 0, 4, 6, 8, true, 0.4, 3, 0.05, true, Utils.getFilename("huds/oatHud.dds", baseDirectory), {2,0,1,1});
    FruitUtil.registerFruitType("sunflower", g_i18n:getText("sunflower"), true, true, false, 0, 4, 6, 8, true, 0.4, 3, 0.05, true, Utils.getFilename("huds/sunflowerHud.dds", baseDirectory), {0,1,0,1});
    FruitUtil.registerFruitType("sorghum", g_i18n:getText("sorghum"), true, true, false, 0, 4, 6, 8, true, 0.4, 3, 0.05, true, Utils.getFilename("huds/sorghumHud.dds", baseDirectory), {0.6,2,2,0.3});
    FruitUtil.registerFruitType("greenwheat", g_i18n:getText("greenwheat"), true, true, false, 0, 4, 6, 8, true, 0.4, 3, 0.05, true, Utils.getFilename("huds/greenwheatHud.dds", baseDirectory), {2,0,1,1});
    FruitUtil.registerFruitType("rye", g_i18n:getText("rye"), true, true, false, 0, 4, 6, 8, true, 0.4, 3, 0.05, true, Utils.getFilename("huds/ryeHud.dds", baseDirectory), {2,0,1,1});
    FruitUtil.registerFruitType("soybean", g_i18n:getText("soybean"), true, true, false, 0, 4, 6, 8, true, 0.4, 3, 0.05, true, Utils.getFilename("huds/soybeanHud.dds", baseDirectory), {0,1,0,1});
   FruitUtil.registerFruitTypeWindrow(FruitUtil.FRUITTYPE_DINKEL, "dinkel_windrow", g_i18n:getText("dinkel_windrow"), 0.2, 3, false, Utils.getFilename("huds/dinkelWindrow.dds", baseDirectory));
   FruitUtil.registerFruitTypeWindrow(FruitUtil.FRUITTYPE_OAT, "oat_windrow", g_i18n:getText("oat_windrow"), 0.2, 3, false, Utils.getFilename("huds/oatWindrow.dds", baseDirectory));
   FruitUtil.registerFruitTypeWindrow(FruitUtil.FRUITTYPE_GREENWHEAT, "greenwheat_windrow", g_i18n:getText("greenwheat_windrow"), 0.2, 3, false, Utils.getFilename("huds/greenwheatWindrow.dds", baseDirectory));
   FruitUtil.registerFruitTypeWindrow(FruitUtil.FRUITTYPE_RYE, "rye_windrow", g_i18n:getText("rye_windrow"), 0.2, 3, false, Utils.getFilename("huds/ryeWindrow.dds", baseDirectory));
    	    -- nonseedable
--	FruitUtil.registerFruitType("milk", g_i18n:getText("milk"), false, false, false, 0, 4, 6, 8, false, 1.4, 3, 0.05, true, Utils.getFilename("huds/milkHud.dds", baseDirectory), {1,1,1,1});
--	FruitUtil.registerFruitType("water", g_i18n:getText("water"), false, false, false, 0, 4, 6, 8, false, 0.5, 3, 0.05, true, Utils.getFilename("huds/waterHud.dds", baseDirectory), {1,1,1,1});
	local mt = customMt;
    local mt = customMt;
    if mt == nil then
        mt = SampleModMap_mt;
    end;
    local self = SampleModMap:superClass():new(baseDirectory, mt);

--    self.playerStartX = 39;
--    self.playerStartY = 0.1;
--    self.playerStartZ = -330;
--    self.playerRotX = 0;
--    self.playerRotY = Utils.degToRad(90);

    --#############################################################################
    --## SoilMod - Begin ##########################################################
    if fmcSoilMod ~= nil and fmcSoilMod.setup_map_new ~= nil then
        --fmcSoilMod.setup_map_new(baseDirectory .. "map/fmcSoilManagement/filltypeOverlays")  -- If map provides its own fill-type HUD overlay icons.
        fmcSoilMod.setup_map_new() -- If using icons included with the SoilManagement.ZIP mod.
    end
    --## SoilMod - End ############################################################
    --#############################################################################

    return self;
end;

function SampleModMap:delete()
    --#############################################################################
    --## SoilMod - Begin ##########################################################
    if fmcSoilMod ~= nil and fmcSoilMod.teardown_map_delete ~= nil then
        fmcSoilMod.teardown_map_delete()
    end
    --## SoilMod - End ############################################################
    --#############################################################################

    SampleModMap:superClass().delete(self);
end;

function SampleModMap:load()
    self:startLoadingTask();

    self.environment = Environment:new(Utils.getFilename("map/sky/sky_day_night.i3d", self.baseDirectory), true, 8, true, true);

    self.helpIconsBase = nil;
    self.collectableHorseshoesObject = nil;
    self.fieldDefinitionBase = nil;
    self.vehicleShopBase = nil;

    self:loadMap(Utils.getFilename("map/map.i3d", self.baseDirectory), true, self.loadMap01Finished, self);
end;

function SampleModMap:loadMap01Finished(node, arguments)

    self:loadMapXMLFile(Utils.getFilename("SampleModMap.xml", self.baseDirectory));

    self.missionPDA:loadMap(Utils.getFilename("pda_map.png", self.baseDirectory), 2048, 2048);

    g_inGameMenu:setMapViewsMap(Utils.getFilename("pda_map.png", self.baseDirectory));

    local iconSize = self.missionPDA.pdaMapWidth / 15;

    SampleModMap:superClass().load(self);

    if not self.missionDynamicInfo.isMultiplayer then
        self:updateFoundHorseshoes();
        self:updateFoundHelpIcons();
        self:updateMeteoriteCrash();
        self:updateRainbow();
    else
        self:removeAllHorseshoes();
        self:removeAllHelpIcons();
    end;

    if g_isGamescomVersion then
        self:playerOwnsAllFields();
    end;

    --#############################################################################
    --## SoilMod - Begin ##########################################################
    if fmcSoilMod ~= nil and fmcSoilMod.postInit_loadMapFinished ~= nil then
        if fmcSoilMod.setFruit_FertilizerBoost_HerbicideAffected ~= nil then
            -- If needed, set up this map's custom fruit-types fertilizer-boost and herbicide-affected attributes.
            
            -- <<Examples>>
            fmcSoilMod.setFruit_FertilizerBoost_HerbicideAffected("dinkel"   ,"fertilizer"   ,"herbicide3")
            fmcSoilMod.setFruit_FertilizerBoost_HerbicideAffected("oat"  ,"fertilizer"  ,"herbicide" )
            fmcSoilMod.setFruit_FertilizerBoost_HerbicideAffected("sunflower"  ,"fertilizer3"  ,"herbicide2")
            fmcSoilMod.setFruit_FertilizerBoost_HerbicideAffected("sorghum"   ,"fertilizer"   ,"herbicide2")
            fmcSoilMod.setFruit_FertilizerBoost_HerbicideAffected("greenwheat"  ,"fertilizer2"  ,"herbicide" )
            fmcSoilMod.setFruit_FertilizerBoost_HerbicideAffected("rye"  ,"fertilizer3"  ,"herbicide2")
            fmcSoilMod.setFruit_FertilizerBoost_HerbicideAffected("soybean"  ,"fertilizer3"  ,"herbicide2")
        end
        --
        fmcSoilMod.postInit_loadMapFinished()
    end
    --## SoilMod - End ############################################################
    --#############################################################################

    self:finishLoadingTask();
end;

function SampleModMap:onStartMission()
    SampleModMap:superClass().onStartMission(self);
end;

function SampleModMap:mouseEvent(posX, posY, isDown, isUp, button)
    SampleModMap:superClass().mouseEvent(self, posX, posY, isDown, isUp, button);
end;

function SampleModMap:keyEvent(unicode, sym, modifier, isDown)
    SampleModMap:superClass().keyEvent(self, unicode, sym, modifier, isDown);
end;

function SampleModMap:update(dt)
    SampleModMap:superClass().update(self, dt);

    --#############################################################################
    --## SoilMod - Begin ##########################################################
    if fmcSoilMod ~= nil and fmcSoilMod.update ~= nil then
        fmcSoilMod.update(dt)
    end
    --## SoilMod - End ############################################################
    --#############################################################################
end;

function SampleModMap:draw()
    SampleModMap:superClass().draw(self);

    --#############################################################################
    --## SoilMod - Begin ##########################################################
    if fmcSoilMod ~= nil and fmcSoilMod.draw ~= nil then
        fmcSoilMod.draw()
    end
    --## SoilMod - End ############################################################
    --#############################################################################
end;