--
-- SampleModMap
--
-- @author  Stefan Geiger
-- @date  06/08/12
--
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.

SampleModMap = {}

local SampleModMap_mt = Class(SampleModMap, Mission00);


function SampleModMap:new(baseDirectory, customMt)
    FruitUtil.registerFruitType("hemp", g_i18n:getText("hemp"), true, true, false, 0, 4, 6, 8, true, 0.4, 3, 0.05, true, Utils.getFilename("huds/hempHud.dds", baseDirectory), {2,0,0.1,1});
    FruitUtil.registerFruitType("oat", g_i18n:getText("oat"), true, true, false, 0, 4, 6, 8, true, 0.4, 3, 0.05, true, Utils.getFilename("huds/oatHud.dds", baseDirectory), {2,0,1,1});
    FruitUtil.registerFruitType("sunflower", g_i18n:getText("sunflower"), true, true, false, 0, 4, 6, 8, true, 0.4, 3, 0.05, true, Utils.getFilename("huds/sunflowerHud.dds", baseDirectory), {0,1,0,1});
    FruitUtil.registerFruitType("sorghum", g_i18n:getText("sorghum"), true, true, false, 0, 4, 6, 8, true, 0.4, 3, 0.05, true, Utils.getFilename("huds/sorghumHud.dds", baseDirectory), {0.6,2,2,0.3});
    FruitUtil.registerFruitType("greenwheat", g_i18n:getText("greenwheat"), true, true, false, 0, 4, 6, 8, true, 0.4, 3, 0.05, true, Utils.getFilename("huds/greenwheatHud.dds", baseDirectory), {2,0,1,1});
    FruitUtil.registerFruitType("millet", g_i18n:getText("millet"), true, true, false, 0, 4, 6, 8, true, 0.4, 3, 0.05, true, Utils.getFilename("huds/milletHud.dds", baseDirectory), {2,0,1,1});
    FruitUtil.registerFruitType("rye", g_i18n:getText("rye"), true, true, false, 0, 4, 6, 8, true, 0.4, 3, 0.05, true, Utils.getFilename("huds/ryeHud.dds", baseDirectory), {2,0,1,1});
    	    -- nonseedable
--	FruitUtil.registerFruitType("milk", g_i18n:getText("milk"), false, false, false, 0, 4, 6, 8, false, 1.4, 3, 0.05, true, Utils.getFilename("huds/milkHud.dds", baseDirectory), {1,1,1,1});
--	FruitUtil.registerFruitType("water", g_i18n:getText("water"), false, false, false, 0, 4, 6, 8, false, 0.5, 3, 0.05, true, Utils.getFilename("huds/waterHud.dds", baseDirectory), {1,1,1,1});
	local mt = customMt;
    local mt = customMt;
    if mt == nil then
        mt = SampleModMap_mt;
    end;
    local self = SampleModMap:superClass():new(baseDirectory, mt);

--    self.playerStartX = 39;
--    self.playerStartY = 0.1;
--    self.playerStartZ = -330;
--    self.playerRotX = 0;
--    self.playerRotY = Utils.degToRad(90);

    return self;
end;

function SampleModMap:delete()
    SampleModMap:superClass().delete(self);
end;

function SampleModMap:load()
    self:startLoadingTask();

    self.environment = Environment:new(Utils.getFilename("$data/sky/sky_day_night.i3d", self.baseDirectory), true, 8, true, true);

    self.helpIconsBase = nil;
    self.collectableHorseshoesObject = nil;
    self.fieldDefinitionBase = nil;
    self.vehicleShopBase = nil;

    self:loadMap(Utils.getFilename("map/map.i3d", self.baseDirectory), true, self.loadMap01Finished, self);
end;

function SampleModMap:loadMap01Finished(node, arguments)

    self:loadMapXMLFile(Utils.getFilename("SampleModMap.xml", self.baseDirectory));

    self.missionPDA:loadMap(Utils.getFilename("pda_map.png", self.baseDirectory), 2048, 2048);

    g_inGameMenu:setMapViewsMap(Utils.getFilename("pda_map.png", self.baseDirectory));

    local iconSize = self.missionPDA.pdaMapWidth / 15;

    SampleModMap:superClass().load(self);

    if not self.missionDynamicInfo.isMultiplayer then
        self:updateFoundHorseshoes();
        self:updateFoundHelpIcons();
        self:updateMeteoriteCrash();
        self:updateRainbow();
    else
        self:removeAllHorseshoes();
        self:removeAllHelpIcons();
    end;

    if g_isGamescomVersion then
        self:playerOwnsAllFields();
    end;

    self:finishLoadingTask();
end;

function SampleModMap:onStartMission()
    SampleModMap:superClass().onStartMission(self);
end;

function SampleModMap:mouseEvent(posX, posY, isDown, isUp, button)
    SampleModMap:superClass().mouseEvent(self, posX, posY, isDown, isUp, button);
end;

function SampleModMap:keyEvent(unicode, sym, modifier, isDown)
    SampleModMap:superClass().keyEvent(self, unicode, sym, modifier, isDown);
end;

function SampleModMap:update(dt)
    SampleModMap:superClass().update(self, dt);
end;

function SampleModMap:draw()
    SampleModMap:superClass().draw(self);
end;