--
-- NewHollandCombineAddon
-- Specialization for NewHollandCombineAddon
--
-- @author  	(Flagsystems) Manuel Leithner
-- @version 	v1.0
-- @date  		14/05/11
-- @history:	v1.0 - Initial version
--

NewHollandCombineAddon = {};

function NewHollandCombineAddon.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Combine, specializations);
end;

function NewHollandCombineAddon:load(xmlFile)
	
	self.graintankDrums = {};
	self.graintankDrums.node1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.graintankDrums#node1"));
	self.graintankDrums.speed1 = getXMLFloat(xmlFile, "vehicle.graintankDrums#speed1");
	self.graintankDrums.node2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.graintankDrums#node2"));
	self.graintankDrums.speed2 = getXMLFloat(xmlFile, "vehicle.graintankDrums#speed2");
	
	self.graintankParticleSystems = {};
	local i = 0;
	while true do
		local key = string.format("vehicle.graintankParticleSystems.graintankParticleSystem(%d)", i);
		local t = getXMLString(xmlFile, key .. "#type");
		if t == nil then
			break;
		end;
		local desc = FruitUtil.fruitTypes[t];
		if desc ~= nil then
			local currentPS = {};

			local particleNode = Utils.loadParticleSystem(xmlFile, currentPS, key, self.components, false, "$data/vehicles/particleSystems/wheatParticleSystem.i3d", self.baseDirectory);
			self.graintankParticleSystems[desc.index] = currentPS;
			if self.defaultGraintankParticleSystem == nil then
				self.defaultGraintankParticleSystem = currentPS;
			end;
		end;
		i = i + 1;
	end;

	self.currentGraintankParticleSystem = nil;	
	
	self.attacherHydraulic = nil;
	local hydraulic = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.attacherJoints#movingPart"));
	for _, part in pairs(self.movingParts) do
		if part.node == hydraulic then
			self.attacherHydraulic = part;
			break;
		end;
	end;
	
	self.chopperBlindHydraulic = nil;
	hydraulic = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.chopperBlindHydraulic#movingPart"));
	if hydraulic ~= nil then
		for _, part in pairs(self.movingParts) do
			if part.node == hydraulic then
				self.chopperBlindHydraulic = part;
				break;
			end;
		end;
	end;
	
	self.attachedCutterBackup = {};
	for _,v in pairs(self.attacherJoints) do 
		if v.maxRot ~= nil then
			v.maxRotBx = v.maxRot[1];
		end;
	end;
	
end;

function NewHollandCombineAddon:delete()
	for k,v in pairs(self.graintankParticleSystems) do
        Utils.deleteParticleSystem(v);
    end;
end;

function NewHollandCombineAddon:mouseEvent(posX, posY, isDown, isUp, button)
end;

function NewHollandCombineAddon:keyEvent(unicode, sym, modifier, isDown)
end;

function NewHollandCombineAddon:update(dt)
	if self:getIsActive() then
		if self.isThreshing and self.graintankDrums.node1 ~= nil then
			rotate(self.graintankDrums.node1, dt * self.graintankDrums.speed1, 0, 0);
		end;
		
		if self.pipeIsUnloading and self.graintankDrums.node2 ~= nil then
			rotate(self.graintankDrums.node2, dt * self.graintankDrums.speed2, 0, 0);
		end;
		
		if self.attacherHydraulic ~= nil then
			Cylindered.updateMovingPart(self, self.attacherHydraulic);
		end;
		if self.chopperBlindHydraulic ~= nil then
			if self:getIsAnimationPlaying("chopperBlind") then	
				Cylindered.updateMovingPart(self, self.chopperBlindHydraulic);
			end;
		end;	
	end;
end;

function NewHollandCombineAddon:updateTick(dt)
	if self:getIsActive() then
		--addin by Sven777b. not nice but works
		if g_currentMission.attachableInMountRange ~= nil and g_currentMission.attachableInMountRangeVehicle == self then
			local aj = self.attacherJoints[g_currentMission.attachableInMountRangeIndex];
			if aj.jointIndex == 0 and aj.jointType == Vehicle.JOINTTYPE_CUTTER then
				local x1,y1,z1 = getWorldTranslation(g_currentMission.attachableInMountRange.attacherJoint.node);
				local x2,y2,z2 = getWorldTranslation(aj.jointTransform);
				local diff = y2-y1;
				if diff > 0 and diff < 0.8 then
					aj.maxRot[1] = aj.minRot[1] + math.rad(21 * diff / 0.8);
				end;
			end;
		end;
		--
		
		if self.attachedCutterBackup.implement ~= nil then	
			self.allowsThreshing = self.attacherJoints[1].moveDown;
			
			if not self.allowsThreshing then
				self.attachedCutterBackup.implement.speedLimit = 1000; 
			else
				self.attachedCutterBackup.implement.speedLimit = self.attachedCutterBackup.speedBackup;
			end;			
		end;
	end;
end;

function NewHollandCombineAddon:draw()	
end;

function NewHollandCombineAddon:onDeactivate()
    for k,v in pairs(self.graintankParticleSystems) do
        Utils.setEmittingState(v, false);
    end;
end;

function NewHollandCombineAddon:detachImplement(implementIndex)
	local object = self.attachedImplements[implementIndex].object;
	if object.speedLimit ~= nil then	
		object.speedLimit = self.attachedCutterBackup.speedBackup;
		self.attachedCutterBackup = {};
	end;	
end;

function NewHollandCombineAddon:attachImplement(implement)	
	local object  = implement.object;
	if object.speedLimit ~= nil then
		self.attachedCutterBackup.implement = object;
		self.attachedCutterBackup.speedBackup = object.speedLimit;
	end;
	if self.attacherJoints[implement.jointDescIndex].maxRot ~= nil then
		self.attacherJoints[implement.jointDescIndex].maxRot[1] = self.attacherJoints[implement.jointDescIndex].maxRotBx;
	end;
end;


local oldCombineSetStrawEnableEvent = CombineSetStrawEnableEvent.execute;
CombineSetStrawEnableEvent.execute = function(object, enabled, fruitType)

	oldCombineSetStrawEnableEvent(object, enabled, fruitType);
	if object.graintankParticleSystems ~= nil then
		if object.currentGraintankParticleSystem ~= nil then
			Utils.setEmittingState(object.currentGraintankParticleSystem, false);
		end;
		object.currentGraintankParticleSystem = object.graintankParticleSystems[fruitType];
		if object.currentGraintankParticleSystem == nil then
			object.currentGraintankParticleSystem = object.defaultGraintankParticleSystem;
		end;
		if enabled then
			Utils.setEmittingState(object.currentGraintankParticleSystem, true);
		else
			Utils.setEmittingState(object.currentGraintankParticleSystem, false);
		end;	
	end;
end;

local oldCombineSetChopperEnableEvent = CombineSetChopperEnableEvent.execute;
CombineSetChopperEnableEvent.execute = function(object, enabled, fruitType)
	oldCombineSetChopperEnableEvent(object, enabled, fruitType);
	if object.graintankParticleSystems ~= nil then
		if object.currentGraintankParticleSystem ~= nil then
			Utils.setEmittingState(object.currentGraintankParticleSystem, false);
		end;
		object.currentGraintankParticleSystem = object.graintankParticleSystems[fruitType];
		if object.currentGraintankParticleSystem == nil then
			object.currentGraintankParticleSystem = object.defaultGraintankParticleSystem;
		end;
		if enabled then
			Utils.setEmittingState(object.currentGraintankParticleSystem, true);
		else
			Utils.setEmittingState(object.currentGraintankParticleSystem, false);
		end;	
	end;
end;



